<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" sizes="any">
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" type="image/svg+xml">
    <link rel="apple-touch-icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?> - <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?> Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        [x-cloak] { display: none !important; }
        
        /* Hide scrollbar for main content */
        .scrollbar-hide {
            -ms-overflow-style: none;  /* Internet Explorer 10+ */
            scrollbar-width: none;  /* Firefox */
        }
        .scrollbar-hide::-webkit-scrollbar {
            display: none;  /* Safari and Chrome */
        }
        
        /* Custom styled scrollbar for mobile sidebar */
        .scrollbar-styled {
            scrollbar-width: thin;
            scrollbar-color: #cbd5e1 #f1f5f9;
        }
        .scrollbar-styled::-webkit-scrollbar {
            width: 6px;
        }
        .scrollbar-styled::-webkit-scrollbar-track {
            background: #f1f5f9;
            border-radius: 3px;
        }
        .scrollbar-styled::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }
        .scrollbar-styled::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50 antialiased">
    <!-- Main Layout Container -->
    <div class="flex h-screen bg-gray-50">
        <!-- Sidebar -->
        <?php echo $__env->make('components.admin.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col overflow-hidden transition-all duration-300" id="main-content">
            <!-- Header -->
            <?php echo $__env->make('components.admin.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            
            <!-- Main Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 px-4 py-6 scrollbar-styled">
                <!-- Page Content -->
                <div class="container mx-auto pb-20 md:pb-0">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </main>
        </div>
    </div>

    <!-- Mobile Sidebar Overlay -->
    <div id="mobile-overlay" class="fixed inset-0 bg-gray-900/20 z-40 hidden md:hidden" onclick="toggleMobileSidebar()"></div>

    <!-- Mobile Sidebar -->
    <?php echo $__env->make('components.admin.mobile-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        function toggleProfileDropdown() {
            const dropdown = document.getElementById('profileDropdown');
            dropdown.classList.toggle('hidden');
        }

        // Close profile dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const profileDropdown = document.getElementById('profileDropdown');
            
            // Close profile dropdown
            if (!profileDropdown.contains(event.target) && !event.target.closest('[onclick="toggleProfileDropdown()"]')) {
                profileDropdown.classList.add('hidden');
            }
        });

        // Close profile dropdown when pressing Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                document.getElementById('profileDropdown').classList.add('hidden');
            }
        });
    </script>
    <?php app('livewire')->forceAssetInjection(); ?>
<?php echo app('flux')->scripts(); ?>

</body>
</html>
<?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/components/layouts/admin.blade.php ENDPATH**/ ?>