<?php $__env->startComponent('mail::message'); ?>
# <?php echo new \Illuminate\Support\EncodedHtmlString($notification->title); ?>


Hello <?php echo new \Illuminate\Support\EncodedHtmlString($user->name); ?>,

<?php echo new \Illuminate\Support\EncodedHtmlString($notification->message); ?>


<?php if($notification->type === 'account_created' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Account Details
- **Account Number:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['account_number'] ?? 'N/A'); ?>

- **Account Type:** <?php echo new \Illuminate\Support\EncodedHtmlString(ucfirst($notification->data['account_type'] ?? 'N/A')); ?>

- **Currency:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['currency'] ?? 'N/A'); ?>

- **Account Status:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['is_master_account'] ? 'Master Account' : 'Secondary Account'); ?>

- **Created On:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['created_at']) ? \Carbon\Carbon::parse($notification->data['created_at'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>


**Next Steps:**
- Your account is currently pending verification
- You will receive another notification once verification is complete
- You can start using your account for basic transactions once verified
<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->type === 'virtual_card_created' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Virtual Card Details
- **Card Name:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['card_name'] ?? 'N/A'); ?>

- **Card Type:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['card_type'] ?? 'N/A'); ?>

- **Card Brand:** <?php echo new \Illuminate\Support\EncodedHtmlString(ucfirst($notification->data['card_brand'] ?? 'N/A')); ?>

- **Last 4 Digits:** **** **** **** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['last_four_digits'] ?? 'N/A'); ?>

- **Currency:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['currency'] ?? 'N/A'); ?>

- **Expiry Date:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['expiry_date'] ?? 'N/A'); ?>

- **Linked Account:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['account_number'] ?? 'N/A'); ?>

- **Created On:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['created_at']) ? \Carbon\Carbon::parse($notification->data['created_at'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>


**Card Features:**
- Secure online transactions
- Real-time balance monitoring
- Instant funding from your master account
- 24/7 card management through your dashboard
- Multi-currency support
- Advanced fraud protection

**Security Reminders:**
- Never share your card details with anyone
- Always verify transactions before confirming
- Monitor your card activity regularly
- Report any suspicious activity immediately
<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->type === 'transfer_completed' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Transfer Details
- **Amount:** <?php echo new \Illuminate\Support\EncodedHtmlString(number_format($notification->data['amount'] ?? 0, 2)); ?> <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['currency'] ?? 'N/A'); ?>

- **Recipient:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['recipient'] ?? 'N/A'); ?>

- **Reference Number:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['reference'] ?? 'N/A'); ?>

- **Completed On:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['completed_at']) ? \Carbon\Carbon::parse($notification->data['completed_at'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>

<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->type === 'inter_account_transfer' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Transfer Details
- **Amount:** <?php echo new \Illuminate\Support\EncodedHtmlString(number_format($notification->data['amount'] ?? 0, 2)); ?> <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['currency'] ?? 'N/A'); ?>

- **From Account:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['from_account'] ?? 'N/A'); ?>

- **To Account:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['to_account'] ?? 'N/A'); ?>

- **Transferred On:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['transferred_at']) ? \Carbon\Carbon::parse($notification->data['transferred_at'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>

<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->type === 'cheque_deposit' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Cheque Deposit Details
- **Amount:** <?php echo new \Illuminate\Support\EncodedHtmlString(number_format($notification->data['amount'] ?? 0, 2)); ?> <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['currency'] ?? 'N/A'); ?>

- **Status:** <?php echo new \Illuminate\Support\EncodedHtmlString(ucfirst($notification->data['status'] ?? 'N/A')); ?>

- **Processed On:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['processed_at']) ? \Carbon\Carbon::parse($notification->data['processed_at'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>

<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->type === 'login_ip_change' && $notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
## Security Alert Details
- **IP Address:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['ip_address'] ?? 'N/A'); ?>

- **Location:** <?php echo new \Illuminate\Support\EncodedHtmlString($notification->data['location'] ?? 'Unknown'); ?>

- **Login Time:** <?php echo new \Illuminate\Support\EncodedHtmlString(isset($notification->data['timestamp']) ? \Carbon\Carbon::parse($notification->data['timestamp'])->format('F j, Y \a\t g:i A') : 'N/A'); ?>


**If this wasn't you:**
- Change your password immediately
- Enable two-factor authentication
- Contact our support team
<?php echo $__env->renderComponent(); ?>
<?php elseif($notification->data): ?>
<?php $__env->startComponent('mail::panel'); ?>
**Additional Details:**
<?php $__currentLoopData = $notification->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
- **<?php echo new \Illuminate\Support\EncodedHtmlString(ucfirst(str_replace('_', ' ', $key))); ?>:** <?php echo new \Illuminate\Support\EncodedHtmlString(is_array($value) ? json_encode($value) : $value); ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

<?php $__env->startComponent('mail::button', ['url' => config('app.url') . '/dashboard']); ?>
View Dashboard
<?php echo $__env->renderComponent(); ?>

If you have any questions or concerns, please don't hesitate to contact our support team.

Thanks,<br>
<?php echo new \Illuminate\Support\EncodedHtmlString(\App\Helpers\SettingsHelper::bankName()); ?> Team

---
*This is an automated message. Please do not reply to this email.*
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/emails/banking-notification.blade.php ENDPATH**/ ?>