<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<section class="relative h-96 bg-cover bg-center bg-no-repeat" style="background-image: url('/Frontend/images/background/8.jpg');">
    <div class="absolute inset-0 bg-black opacity-50"></div>
    <div class="relative z-10 h-full flex items-center">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full">
            <div class="flex items-center">
                <!-- Blue separator line -->
                <div class="w-1 h-12 bg-[#303ffa] mr-4"></div>
                <div>
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">Privacy Policy</h1>
                    <nav class="text-white text-sm">
                        <a href="<?php echo e(route('home')); ?>" class="hover:text-gray-300">Home</a>
                        <span class="mx-2">></span>
                        <span class="text-gray-300">Legal</span>
                        <span class="mx-2">></span>
                        <span class="text-gray-300">Privacy Policy</span>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Privacy Policy Content -->
<section class="py-16 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Last Updated -->
        <div class="text-center mb-8">
            <p class="text-sm text-gray-500">Last updated: <?php echo e(date('F d, Y')); ?></p>
        </div>

        <!-- Table of Contents -->
        <div class="bg-gray-50 rounded-lg p-6 mb-12">
            <h2 class="text-xl font-bold text-[#1e3a8a] mb-4">Table of Contents</h2>
            <div class="grid md:grid-cols-2 gap-2">
                <a href="#introduction" class="text-blue-600 hover:text-blue-800 text-sm">1. Introduction</a>
                <a href="#information-collection" class="text-blue-600 hover:text-blue-800 text-sm">2. Information We Collect</a>
                <a href="#how-we-use" class="text-blue-600 hover:text-blue-800 text-sm">3. How We Use Your Information</a>
                <a href="#information-sharing" class="text-blue-600 hover:text-blue-800 text-sm">4. Information Sharing</a>
                <a href="#data-security" class="text-blue-600 hover:text-blue-800 text-sm">5. Data Security</a>
                <a href="#your-rights" class="text-blue-600 hover:text-blue-800 text-sm">6. Your Rights</a>
                <a href="#cookies" class="text-blue-600 hover:text-blue-800 text-sm">7. Cookies and Tracking</a>
                <a href="#children-privacy" class="text-blue-600 hover:text-blue-800 text-sm">8. Children's Privacy</a>
                <a href="#changes" class="text-blue-600 hover:text-blue-800 text-sm">9. Changes to This Policy</a>
                <a href="#contact" class="text-blue-600 hover:text-blue-800 text-sm">10. Contact Us</a>
            </div>
        </div>

        <!-- Introduction -->
        <div id="introduction" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">1. Introduction</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    At <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>, we are committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website, use our mobile applications, or interact with our banking services.
                </p>
                <p class="text-gray-700 leading-relaxed">
                    This policy applies to all information collected by <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?> and its affiliates, including information collected through our website, mobile applications, online banking services, and any other digital platforms we operate.
                </p>
            </div>
        </div>

        <!-- Information We Collect -->
        <div id="information-collection" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">2. Information We Collect</h2>
            <div class="prose prose-lg max-w-none">
                <h3 class="text-xl font-semibold text-gray-800 mb-3">Personal Information</h3>
                <p class="text-gray-700 leading-relaxed mb-4">
                    We collect personal information that you provide directly to us, including:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li>Name, address, phone number, and email address</li>
                    <li>Social Security number and date of birth</li>
                    <li>Financial information, including account numbers and transaction history</li>
                    <li>Employment information and income details</li>
                    <li>Government-issued identification documents</li>
                    <li>Biometric data (if applicable for security purposes)</li>
                </ul>

                <h3 class="text-xl font-semibold text-gray-800 mb-3">Automatically Collected Information</h3>
                <p class="text-gray-700 leading-relaxed mb-4">
                    We automatically collect certain information when you use our services:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li>Device information (IP address, browser type, operating system)</li>
                    <li>Usage data (pages visited, time spent, click patterns)</li>
                    <li>Location data (with your consent)</li>
                    <li>Cookies and similar tracking technologies</li>
                </ul>
            </div>
        </div>

        <!-- How We Use Your Information -->
        <div id="how-we-use" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">3. How We Use Your Information</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    We use your personal information for various business purposes, including:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li>Providing and maintaining our banking services</li>
                    <li>Processing transactions and managing your accounts</li>
                    <li>Verifying your identity and preventing fraud</li>
                    <li>Complying with legal and regulatory requirements</li>
                    <li>Communicating with you about your accounts and services</li>
                    <li>Improving our products and services</li>
                    <li>Marketing and promotional activities (with your consent)</li>
                    <li>Risk management and security purposes</li>
                </ul>
            </div>
        </div>

        <!-- Information Sharing -->
        <div id="information-sharing" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">4. Information Sharing</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    We do not sell, trade, or rent your personal information to third parties. We may share your information in the following circumstances:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li><strong>Service Providers:</strong> With trusted third-party vendors who assist us in providing our services</li>
                    <li><strong>Legal Requirements:</strong> When required by law, court order, or regulatory authority</li>
                    <li><strong>Business Transfers:</strong> In connection with mergers, acquisitions, or asset sales</li>
                    <li><strong>Consent:</strong> When you have given us explicit consent to share your information</li>
                    <li><strong>Protection of Rights:</strong> To protect our rights, property, or safety, or that of our customers</li>
                </ul>
            </div>
        </div>

        <!-- Data Security -->
        <div id="data-security" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">5. Data Security</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    We implement appropriate technical and organizational measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. These measures include:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li>Encryption of data in transit and at rest</li>
                    <li>Regular security assessments and updates</li>
                    <li>Access controls and authentication protocols</li>
                    <li>Employee training on data protection practices</li>
                    <li>Incident response procedures</li>
                </ul>
            </div>
        </div>

        <!-- Your Rights -->
        <div id="your-rights" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">6. Your Rights</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    Depending on your jurisdiction, you may have the following rights regarding your personal information:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li><strong>Access:</strong> Request access to your personal information</li>
                    <li><strong>Correction:</strong> Request correction of inaccurate information</li>
                    <li><strong>Deletion:</strong> Request deletion of your personal information</li>
                    <li><strong>Portability:</strong> Request a copy of your data in a portable format</li>
                    <li><strong>Restriction:</strong> Request restriction of processing</li>
                    <li><strong>Objection:</strong> Object to certain types of processing</li>
                    <li><strong>Withdraw Consent:</strong> Withdraw consent for data processing</li>
                </ul>
                <p class="text-gray-700 leading-relaxed">
                    To exercise these rights, please contact us using the information provided in the "Contact Us" section below.
                </p>
            </div>
        </div>

        <!-- Cookies and Tracking -->
        <div id="cookies" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">7. Cookies and Tracking Technologies</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    We use cookies and similar tracking technologies to enhance your experience on our website and mobile applications. Cookies are small text files stored on your device that help us:
                </p>
                <ul class="list-disc list-inside text-gray-700 mb-6 space-y-2">
                    <li>Remember your preferences and settings</li>
                    <li>Analyze website traffic and usage patterns</li>
                    <li>Provide personalized content and advertisements</li>
                    <li>Improve website functionality and performance</li>
                </ul>
                <p class="text-gray-700 leading-relaxed">
                    You can control cookie settings through your browser preferences, but disabling cookies may affect the functionality of our services.
                </p>
            </div>
        </div>

        <!-- Children's Privacy -->
        <div id="children-privacy" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">8. Children's Privacy</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed">
                    Our services are not directed to children under the age of 13. We do not knowingly collect personal information from children under 13. If we become aware that we have collected personal information from a child under 13, we will take steps to delete such information promptly.
                </p>
            </div>
        </div>

        <!-- Changes to Policy -->
        <div id="changes" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">9. Changes to This Privacy Policy</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed">
                    We may update this Privacy Policy from time to time to reflect changes in our practices or applicable laws. We will notify you of any material changes by posting the updated policy on our website and updating the "Last Updated" date. We encourage you to review this policy periodically to stay informed about how we protect your information.
                </p>
            </div>
        </div>

        <!-- Contact Us -->
        <div id="contact" class="mb-12">
            <h2 class="text-2xl font-bold text-[#1e3a8a] mb-4">10. Contact Us</h2>
            <div class="prose prose-lg max-w-none">
                <p class="text-gray-700 leading-relaxed mb-4">
                    If you have any questions about this Privacy Policy or our data practices, please contact us:
                </p>
                <div class="bg-gray-50 rounded-lg p-6">
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-semibold text-[#1e3a8a] mb-2">Privacy Officer</h4>
                            <p class="text-gray-700"><?php echo e(\App\Helpers\SettingsHelper::bankName()); ?></p>
                            <p class="text-gray-700"><?php echo e(\App\Helpers\SettingsHelper::bankAddress()); ?></p>
                        </div>
                        <div>
                            <h4 class="font-semibold text-[#1e3a8a] mb-2">Contact Information</h4>
                            <p class="text-gray-700">Email: <?php echo e(\App\Helpers\SettingsHelper::bankEmail()); ?></p>
                            <p class="text-gray-700">Phone: <?php echo e(\App\Helpers\SettingsHelper::bankPhone()); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Back to Top Button -->
        <div class="text-center">
            <button onclick="window.scrollTo({top: 0, behavior: 'smooth'})" 
                class="bg-[#1e3a8a] text-white px-6 py-3 rounded-lg hover:bg-blue-800 transition-colors duration-300">
                Back to Top
            </button>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Smooth scrolling for table of contents links
document.addEventListener('DOMContentLoaded', function() {
    const tocLinks = document.querySelectorAll('a[href^="#"]');
    
    tocLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const targetId = this.getAttribute('href').substring(1);
            const targetElement = document.getElementById(targetId);
            
            if (targetElement) {
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/privacy-policy.blade.php ENDPATH**/ ?>