<footer class="bg-[#011a55] text-white relative overflow-hidden">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute left-0 top-0 w-1/3 h-full">
            <div class="w-full h-full" style="background: linear-gradient(45deg, transparent 40%, rgba(255,255,255,0.1) 50%, transparent 60%); background-size: 20px 20px;"></div>
        </div>
        <div class="absolute right-0 top-0 w-1/3 h-full">
            <div class="w-full h-full" style="background: linear-gradient(-45deg, transparent 40%, rgba(255,255,255,0.1) 50%, transparent 60%); background-size: 20px 20px;"></div>
        </div>
    </div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Company Info -->
            <div class="lg:col-span-1">
                <div class="flex items-center space-x-3 mb-6">
                    <!-- Bank Logo -->
                    <img src="<?php echo e(\App\Helpers\SettingsHelper::bankLogo()); ?>" alt="<?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>" class="h-14 w-auto filter brightness-0 invert">
                    <!-- Bank Name -->
                </div>
                <p class="text-gray-300 text-sm leading-relaxed">
                    <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?> was designed for those who demand banking that's dramatically better than what they've 
                    experienced in the past. Our innovative methods and products keep pace with your life and your business.
                </p>
            </div>
            
            <!-- Links Column -->
            <div>
                <h4 class="text-lg font-bold mb-4 text-white">LINKS</h4>
                <ul class="space-y-2">
                    <li>
                        <a href="<?php echo e(route('home')); ?>" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Home
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('about-us')); ?>" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            About
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Personal
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Business
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('contact')); ?>" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Contact
                        </a>
                    </li>
                </ul>
            </div>
            
            <!-- Support Column -->
            <div>
                <h4 class="text-lg font-bold mb-4 text-white">SUPPORT</h4>
                <ul class="space-y-2">
                    <li>
                        <a href="<?php echo e(route('privacy-policy')); ?>" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Privacy Policy
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Careers
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Investor Relations
                        </a>
                    </li>
                    <li>
                        <a href="#" class="text-gray-300 hover:text-white transition-colors flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mr-2 text-xs"></i>
                            Privacy & Security
                        </a>
                    </li>
                </ul>
            </div>
            
            <!-- Contact Column -->
            <div>
                <h4 class="text-lg font-bold mb-4 text-white">CONTACT</h4>
                <div class="space-y-3">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-blue-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                        <span class="text-gray-300 text-sm"><?php echo e(\App\Helpers\SettingsHelper::bankPhone()); ?></span>
                    </div>
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-blue-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <span class="text-gray-300 text-sm"><?php echo e(\App\Helpers\SettingsHelper::bankEmail()); ?></span>
                    </div>
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-blue-400 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <span class="text-gray-300 text-sm"><?php echo e(\App\Helpers\SettingsHelper::bankAddress()); ?></span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Copyright Section -->
        <div class="mt-12 pt-8 border-t border-blue-800">
            <div class="text-center">
                <p class="text-gray-400 text-sm">
                    <?php echo e(date('Y')); ?> © All rights reserved <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>

                </p>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/sbrbot/pay.sbrbot.trading/resources/views/components/public/footer.blade.php ENDPATH**/ ?>