<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" sizes="any">
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" type="image/svg+xml">
    <link rel="apple-touch-icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>">

    <title><?php echo e(\App\Helpers\SettingsHelper::bankName()); ?> - Admin</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        }
        .admin-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="font-sans antialiased flex items-center justify-center min-h-screen p-4 sm:p-6">
    <div class="w-full max-w-md mx-auto">
        <!-- Content Slot -->
        <div>
            <?php echo e($slot); ?>

        </div>

        <!-- Footer/Copyright -->
        <div class="mt-8 text-center text-gray-600 text-sm">
            &copy; <?php echo e(date('Y')); ?> <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?>. All rights reserved.
        </div>
    </div>
    <?php app('livewire')->forceAssetInjection(); ?>
<?php echo app('flux')->scripts(); ?>

</body>
</html>
<?php /**PATH /home/isibiico/cyclo.mydigitaltestdev.sbs/resources/views/components/layouts/admin-auth.blade.php ENDPATH**/ ?>