<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Error'); ?> - <?php echo e(\App\Helpers\SettingsHelper::bankName()); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" sizes="any">
    <link rel="icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>" type="image/svg+xml">
    <link rel="apple-touch-icon" href="<?php echo e(\App\Helpers\SettingsHelper::bankFavicon()); ?>">
</head>
<body class="font-sans antialiased bg-gray-50">
    <div class="min-h-screen flex flex-col">

        <!-- Main Content -->
        <div class="flex-1 flex items-center justify-center px-4 sm:px-6 lg:px-8 py-12">
            <div class="max-w-2xl w-full">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>

    </div>
</body>
</html>
<?php /**PATH /home/isibiico/cyclo.mydigitaltestdev.sbs/resources/views/errors/layout.blade.php ENDPATH**/ ?>