<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Auth\AdminLoginController;
use App\Http\Controllers\Admin\Auth\AdminLogoutController;

// Admin Authentication Routes (No middleware - accessible without auth)
Route::prefix('admin')->name('admin.')->group(function () {
    // Admin Login Routes
    Route::middleware('admin.guest')->group(function () {
        Route::get('login', [AdminLoginController::class, 'showLoginForm'])->name('login');
        Route::post('login', [AdminLoginController::class, 'login'])->name('login.post');
    });
    
    // Admin Logout Route
    Route::middleware(['auth', 'admin.auth'])->group(function () {
        Route::post('logout', [AdminLogoutController::class, 'logout'])->name('logout');
    });
});
