@extends('layouts.public')

@section('title', \App\Helpers\SettingsHelper::bankName() . ' - Banking Solutions Built for You')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-screen flex flex-col lg:flex-row items-center overflow-hidden bg-cover bg-right bg-no-repeat"  style="background-image: url('/Frontend/images/main-slider/1.png');">
    <!-- Background Overlay -->
    <div class="absolute inset-0 bg-gray-100 opacity-25 z-0"></div>
    
    <!-- Left Side - White Background with Pattern -->
    <div class="w-full lg:w-1/2 bg-white relative z-10 order-1 lg:order-1">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-10">
            <div class="w-full h-full" style="background: linear-gradient(45deg, transparent 40%, #1e3a8a 50%, transparent 60%); background-size: 20px 20px;"></div>
        </div>
        
        <div class="relative z-10 max-w-2xl mx-auto px-4 sm:px-6 lg:px-8 py-12 sm:py-16 lg:py-24 xl:py-32">
            <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-6xl font-bold text-[#1e3a8a] leading-tight mb-4 sm:mb-6">
                Our Finance Can Give More Possibilities Of 
                <span class="text-[#465ba9]">Business</span>
            </h1>
            
             <!-- Separator Line -->
             <div class="w-16 sm:w-20 h-1 bg-[#465ba9] mb-6 sm:mb-8"></div>
            
            
            <p class="text-base sm:text-lg text-gray-700 mb-6 sm:mb-8 leading-relaxed">
                Our innovative financial solutions keep pace with your life and your business. 
                {{ \App\Helpers\SettingsHelper::bankName() }} is here to help you thrive.
            </p>
            
            <a href="{{ route('login') }}" class="inline-flex items-center bg-[#1e3a8a] text-white px-6 sm:px-8 py-3 sm:py-4 rounded-full font-semibold text-base sm:text-lg hover:bg-blue-800 transition-colors">
                Online Banking
                <svg class="ml-2 w-4 h-4 sm:w-5 sm:h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                </svg>
            </a>
        </div>
    </div>
    
    
    <!-- Right Side - Modern Curved Design with Image -->
    <div class="md:w-full lg:w-1/2 relative h-64 sm:h-80 lg:h-full order-2 lg:order-2">
        <!-- Content Overlay -->
        <div class="relative z-20 h-full flex flex-col justify-between p-4 sm:p-6 lg:p-8 xl:p-12">
            <!-- Top Stats or Features -->
            <div class="flex justify-center lg:justify-end space-x-4 sm:space-x-6 lg:space-x-8 text-white mb-4 lg:mb-0">
                <div class="text-center">
                    <div class="text-xl sm:text-2xl lg:text-3xl font-bold">24/7</div>
                    <div class="text-xs sm:text-sm opacity-90">Support</div>
                </div>
                <div class="text-center">
                    <div class="text-xl sm:text-2xl lg:text-3xl font-bold">100%</div>
                    <div class="text-xs sm:text-sm opacity-90">Secure</div>
                </div>
                <div class="text-center">
                    <div class="text-xl sm:text-2xl lg:text-3xl font-bold">50+</div>
                    <div class="text-xs sm:text-sm opacity-90">Services</div>
                </div>
            </div>
            
            <!-- Bottom Features -->
            <div class="space-y-3 sm:space-y-4">
                <div class="flex items-center text-white">
                    <div class="w-10 h-10 sm:w-12 sm:h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mr-3 sm:mr-4 flex-shrink-0">
                        <svg class="w-5 h-5 sm:w-6 sm:h-6 text-[#1e3a8a]" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                        </svg>
                    </div>
                    <div class="min-w-0">
                        <div class="font-semibold text-sm sm:text-base">Instant Transfers</div>
                        <div class="text-xs sm:text-sm opacity-90">Send money anywhere, anytime</div>
                    </div>
                </div>
                
                <div class="flex items-center text-white">
                    <div class="w-10 h-10 sm:w-12 sm:h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mr-3 sm:mr-4 flex-shrink-0">
                        <svg class="w-5 h-5 sm:w-6 sm:h-6 text-[#1e3a8a]" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
                        </svg>
                    </div>
                    <div class="min-w-0">
                        <div class="font-semibold text-sm sm:text-base">Bank-Level Security</div>
                        <div class="text-xs sm:text-sm opacity-90">Your money is always protected</div>
                    </div>
                </div>
                
                <div class="flex items-center text-white">
                    <div class="w-10 h-10 sm:w-12 sm:h-12 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mr-3 sm:mr-4 flex-shrink-0">
                        <svg class="w-5 h-5 sm:w-6 sm:h-6 text-[#1e3a8a]" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M11.8 10.9c-2.27-.59-3-1.2-3-2.15 0-1.09 1.01-1.85 2.7-1.85 1.78 0 2.44.85 2.5 2.1h2.21c-.07-1.72-1.12-3.3-3.21-3.81V3h-3v2.16c-1.94.42-3.5 1.68-3.5 3.61 0 2.31 1.91 3.46 4.7 4.13 2.5.6 3 1.48 3 2.41 0 .69-.49 1.79-2.7 1.79-2.06 0-2.87-.92-2.98-2.1h-2.2c.12 2.19 1.76 3.42 3.68 3.83V21h3v-2.15c1.95-.37 3.5-1.5 3.5-3.55 0-2.84-2.43-3.81-4.7-4.4z"/>
                        </svg>
                    </div>
                    <div class="min-w-0">
                        <div class="font-semibold text-sm sm:text-base">Competitive Rates</div>
                        <div class="text-xs sm:text-sm opacity-90">Best rates in the market</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section id="services" class="py-20 bg-gray-50 relative">    
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-2xl sm:text-2xl lg:text-3xl font-bold text-[#1e3a8a] mb-4">Our Services</h2>
            <p class="text-base sm:text-base lg:text-xl text-gray-600 max-w-3xl mx-auto">
                Comprehensive banking solutions designed to meet your personal and business needs
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Service 1: Checking Management -->
            <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 p-8 border border-gray-100 group">
                <div class="w-20 h-20 bg-[#1e3a8a] rounded-full flex items-center justify-center mb-6 mx-auto group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-[#1e3a8a] mb-4 text-center">Checking Management</h3>
                <p class="text-gray-600 mb-6 text-center">Convenient Options Earn Rewards or Interest Free eStatements</p>
                <div class="flex justify-center">
                    <button class="w-12 h-12 bg-[#1e3a8a] rounded-full flex items-center justify-center hover:bg-[#0a2a6b] transition-colors duration-300 group-hover:scale-110">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                    </button>
                </div>
            </div>
            
            <!-- Service 2: Business Loans -->
            <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 p-8 border border-gray-100 group">
                <div class="w-20 h-20 bg-[#1e3a8a] rounded-full flex items-center justify-center mb-6 mx-auto group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-[#1e3a8a] mb-4 text-center">Business Loans</h3>
                <p class="text-gray-600 mb-6 text-center">Access funds for expansion, new equipment or unexpected market events.</p>
                <div class="flex justify-center">
                    <button class="w-12 h-12 bg-[#1e3a8a] rounded-full flex items-center justify-center hover:bg-[#0a2a6b] transition-colors duration-300 group-hover:scale-110">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                    </button>
                </div>
            </div>
            
            <!-- Service 3: Mortgages Management -->
            <div class="bg-white rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 p-8 border border-gray-100 group">
                <div class="w-20 h-20 bg-[#1e3a8a] rounded-full flex items-center justify-center mb-6 mx-auto group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-[#1e3a8a] mb-4 text-center">Mortgages Management</h3>
                <p class="text-gray-600 mb-6 text-center">Buying and refinancing solutions to help you own your dream home.</p>
                <div class="flex justify-center">
                    <button class="w-12 h-12 bg-[#1e3a8a] rounded-full flex items-center justify-center hover:bg-[#0a2a6b] transition-colors duration-300 group-hover:scale-110">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Section -->
<section id="about" class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Column - Text Content -->
            <div>
                <div class="text-sm font-semibold text-[#1e3a8a] uppercase tracking-wide mb-4">About Us</div>
                <h2 class="text-2xl sm:text-2xl lg:text-3xl font-bold text-[#1e3a8a] mb-6 leading-tight">
                    We are here to manage your finance with 
                    <span class="text-[#4A90E2]">experience</span>
                </h2>
                
                <!-- Underline -->
                <div class="w-20 h-1 bg-[#1e3a8a] mb-8"></div>
                
                <div class="space-y-6 text-gray-700">
                    <p class="text-base leading-relaxed">
                        {{ \App\Helpers\SettingsHelper::bankName() }} was designed for those who demand banking that's dramatically better than what they've experienced in the past. 
                        Our innovative methods and products keep pace with your life and your business.
                    </p>
                    <p class="text-base leading-relaxed">
                        Our hyper-focused associates respond with the resources you need anytime you reach a review point you'll end up reviewing and negotiating the content itself and not the design.
                    </p>
                </div>
                
                <div class="mt-8">
                    <h4 class="text-base font-semibold text-[#1e3a8a] uppercase tracking-wide mb-4">Our Mission</h4>
                    <p class="text-base text-gray-700">
                        {{ \App\Helpers\SettingsHelper::bankName() }} vision is to be one of the highest performing banking companies among the fifty largest in Warsaw Poland.
                    </p>
                </div>
                
                <div class="mt-8 pt-6 border-t border-gray-200">
                    <p class="text-[#1e3a8a] text-base">
                        <span class="font-semibold">For Enquiry Email: {{ \App\Helpers\SettingsHelper::bankEmail() }} </span>
                    </p>
                </div>
            </div>
            
            <!-- Right Column - Video Player -->
            <div class="relative">
                <div class="bg-white rounded-2xl shadow-2xl overflow-hidden">
                    <!-- Video Container -->
                    <div class="relative aspect-video bg-gray-100">
                        <!-- Placeholder Video Image -->
                        <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('/Frontend/images/resource/video-img.jpg');">
                            <div class="absolute inset-0 bg-gray-500 opacity-30"></div>
                        </div>
                        
                        <!-- Play Button Overlay -->
                        <div class="absolute inset-0 flex items-center justify-center">
                            <button class="w-20 h-20 bg-[#1e3a8a] rounded-full flex items-center justify-center hover:bg-[#0a2a6b] transition-colors duration-300 shadow-lg hover:scale-110 transform">
                                <svg class="w-8 h-8 text-white ml-1" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M8 5v14l11-7z"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Solutions Slider Section -->
<section id="solutions" class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-2xl sm:text-2xl lg:text-3xl font-bold text-[#1e3a8a] mb-4">Our Solutions</h2>
            <p class="text-base sm:text-base lg:text-xl text-gray-600 max-w-3xl mx-auto">
                Comprehensive financial solutions tailored for businesses of all sizes
            </p>
        </div>
        
        <!-- Slider Container -->
        <div class="relative">
            <!-- Slider Wrapper -->
            <div class="overflow-hidden">
                <div class="flex transition-transform duration-500 ease-in-out" id="slider">
                    <!-- Slide 1: Business Solution -->
                    <div class="w-full flex-shrink-0">
                        <div class="relative bg-gradient-to-br from-[#1e3a8a] to-[#0a2a6b] md:rounded-2xl overflow-hidden md:min-h-[400px] min-h-[200px]">
                            <!-- Background Image -->
                            <div class="absolute inset-0 bg-cover bg-center opacity-20" style="background-image: url('/Frontend/images/gallery/1.jpg');"></div>
                            
                            <!-- Content Overlay -->
                            <div class="absolute bottom-0 left-5 right-0 z-10 p-8 lg:p-12">
                                <div class="max-w-2xl">
                                    <h3 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-4 sm:mb-6">Business Solution</h3>
                                    <p class="text-sm md:block hidden sm:text-base md:text-lg lg:text-xl text-white leading-relaxed">
                                        We work with all types of small and medium sized companies. Do you need a business loan, tailored insurance or treasury management services? Then we can help.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Slide 2: Commercial -->
                    <div class="w-full flex-shrink-0">
                        <div class="relative bg-gradient-to-br from-[#1e3a8a] to-[#0a2a6b] md:rounded-2xl overflow-hidden md:min-h-[400px] min-h-[200px]">
                            <!-- Background Image -->
                            <div class="absolute inset-0 bg-cover bg-center opacity-20" style="background-image: url('/Frontend/images/gallery/31.jpg');"></div>
                            
                            <!-- Content Overlay -->
                            <div class="absolute bottom-0 left-5 right-0 z-10 p-8 lg:p-12">
                                <div class="max-w-2xl">
                                    <h3 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-4 sm:mb-6">Commercial</h3>
                                    <p class="text-sm md:block hidden sm:text-base md:text-lg lg:text-xl text-white leading-relaxed">
                                        Corporation helping the commercial financial aspects of your business. We provide comprehensive commercial banking services to support your corporate growth and success.
                                    </p>        
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Slide 3: Personal Banking -->
                    <div class="w-full flex-shrink-0">
                        <div class="relative bg-gradient-to-br from-[#1e3a8a] to-[#0a2a6b] md:rounded-2xl overflow-hidden md:min-h-[400px] min-h-[200px]">
                            <!-- Background Image -->
                            <div class="absolute inset-0 bg-cover bg-center opacity-20" style="background-image: url('/Frontend/images/gallery/32.jpg');"></div>
                            
                            <!-- Content Overlay -->
                            <div class="absolute bottom-0 left-5 right-0 z-10 p-8 lg:p-12">
                                <div class="max-w-2xl">
                                    <h3 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-4 sm:mb-6">Personal Banking</h3>
                                    <p class="text-sm md:block hidden sm:text-base md:text-lg lg:text-xl text-white leading-relaxed">
                                        Personal banking solutions designed for individuals and families. From checking accounts to personal loans, we provide the financial tools you need for life's important moments.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Navigation Arrows -->
            <button id="prevBtn" class="absolute md:block hidden left-4 top-1/2 transform -translate-y-1/2 bg-black bg-opacity-50 hover:bg-opacity-70 text-white p-3 rounded-full transition-all duration-300 z-20">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
            </button>
            
            <button id="nextBtn" class="absolute md:block hidden right-4 top-1/2 transform -translate-y-1/2 bg-black bg-opacity-50 hover:bg-opacity-70 text-white p-3 rounded-full transition-all duration-300 z-20">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </button>
            
            <!-- Dots Indicator -->
            <div class="flex justify-center mt-8 space-x-2">
                <button class="w-3 h-3 rounded-full bg-[#1e3a8a] transition-all duration-300" data-slide="0"></button>
                <button class="w-3 h-3 rounded-full bg-gray-300 hover:bg-[#1e3a8a] transition-all duration-300" data-slide="1"></button>
                <button class="w-3 h-3 rounded-full bg-gray-300 hover:bg-[#1e3a8a] transition-all duration-300" data-slide="2"></button>
            </div>
        </div>
    </div>
</section>
<!-- Services Section -->
<section id="services" class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="text-sm font-semibold text-[#1e3a8a] uppercase tracking-wide mb-4">Services</div>
            <h2 class="text-2xl sm:text-2xl lg:text-3xl font-bold text-[#1e3a8a] mb-6">
                Banking solutions built for the way you live and work.
            </h2>
            <div class="w-20 h-1 bg-[#1e3a8a] mx-auto"></div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Service 1: Personal Banking -->
            <div class="bg-white md:rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 group overflow-hidden">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('/Frontend/images/resource/service-1.jpg');">
                    <div class="absolute inset-0 bg-[#1e3a8a] opacity-50"></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <circle cx="12" cy="12" r="10" stroke-width="2"/>
                            <circle cx="12" cy="12" r="6" stroke-width="2"/>
                            <circle cx="12" cy="12" r="2" stroke-width="2"/>
                        </svg>
                    </div>
                </div>
                <div class="p-6 text-left">
                    <h3 class="text-base lg:text-xl font-semibold text-[#1e3a8a] mb-2">Personal Banking</h3>
                </div>
            </div>
            
            <!-- Service 2: Business Banking -->
            <div class="bg-white md:rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 group overflow-hidden">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('/Frontend/images/resource/service-2.jpg');">
                    <div class="absolute inset-0 bg-[#1e3a8a] opacity-50"></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                </div>
                <div class="p-6 text-left">
                    <h3 class="text-base lg:text-xl font-semibold text-[#1e3a8a] mb-2">Business Banking</h3>
                </div>
            </div>
            
            <!-- Service 3: Business Loans -->
            <div class="bg-white md:rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 group overflow-hidden">
                <div class="relative h-64 bg-cover bg-center" style="background-image: url('/Frontend/images/resource/service-18.jpg');">
                    <div class="absolute inset-0 bg-[#1e3a8a] opacity-50"></div>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </div>
                </div>
                <div class="p-6 text-left">
                    <h3 class="text-base lg:text-xl font-semibold text-[#1e3a8a] mb-2">Business Loans</h3>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="bg-gray-900 py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h2 class="text-2xl sm:text-4xl lg:text-4xl font-bold text-white mb-8">
                Have a great opportunity to<br>
                <span class="text-[#4A90E2]">manage your finance</span>
            </h2>
        </div>
    </div>
</section>

<!-- Partners/Trusted By Section -->
<section class="bg-white py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h3 class="text-lg font-semibold text-gray-600 uppercase tracking-wide">Trusted by leading companies</h3>
        </div>
        
        <!-- Mobile Carousel -->
        <div class="md:hidden">
            <div class="relative overflow-hidden">
                <div class="flex transition-transform duration-500 ease-in-out" id="partnersCarousel">
                    <!-- Partner 1: CAPITAL -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/2.png" alt="CAPITAL" class="h-14 w-auto object-contain">
                        </div>
                    </div>
                    
                    <!-- Partner 2: Accession -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/3.png" alt="Accession" class="h-14 w-auto object-contain">
                        </div>
                    </div>
                    
                    <!-- Partner 3: Dynamic -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/4.png" alt="Dynamic" class="h-14 w-auto object-contain">
                        </div>
                    </div>
                    
                    <!-- Partner 4: Status Group -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/5.png" alt="Status Group" class="h-14 w-auto object-contain">
                        </div>
                    </div>
                    
                    <!-- Partner 5: Copixel -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/6.png" alt="Copixel" class="h-14 w-auto object-contain">
                        </div>
                    </div>
                    
                    <!-- Partner 6: Finance Strategy -->
                    <div class="w-1/2 flex-shrink-0 flex flex-col items-center justify-center p-4">
                        <div class="mb-2 flex items-center justify-center">
                            <img src="/Frontend/images/clients/1.png" alt="Finance Strategy" class="h-12 w-auto object-contain">
                        </div>
                    </div>
                </div>
                
                <!-- Mobile Navigation Arrows -->
                <button id="partnersPrevBtn" class="absolute left-2 top-1/2 transform -translate-y-1/2 bg-white bg-opacity-80 hover:bg-opacity-100 text-gray-600 p-2 rounded-full shadow-lg transition-all duration-300">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                
                <button id="partnersNextBtn" class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-white bg-opacity-80 hover:bg-opacity-100 text-gray-600 p-2 rounded-full shadow-lg transition-all duration-300">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
            </div>
            
            <!-- Mobile Dots Indicator -->
            <div class="flex justify-center mt-6 space-x-2">
                <button class="w-2 h-2 rounded-full bg-[#1e3a8a] transition-all duration-300" data-partner-slide="0"></button>
                <button class="w-2 h-2 rounded-full bg-gray-300 hover:bg-[#1e3a8a] transition-all duration-300" data-partner-slide="1"></button>
                <button class="w-2 h-2 rounded-full bg-gray-300 hover:bg-[#1e3a8a] transition-all duration-300" data-partner-slide="2"></button>
            </div>
        </div>
        
        <!-- Desktop Grid -->
        <div class="hidden md:grid grid-cols-3 lg:grid-cols-6 gap-8 items-center">
            <!-- Partner 1: CAPITAL -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/2.png" alt="CAPITAL" class="h-14 w-auto object-contain">
                </div>
            </div>
            
            <!-- Partner 2: Accession -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/3.png" alt="Accession" class="h-14 w-auto object-contain">
                </div>
            </div>
            
            <!-- Partner 3: Dynamic -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/4.png" alt="Dynamic" class="h-14 w-auto object-contain">
                </div>
            </div>
            
            <!-- Partner 4: Status Group -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/5.png" alt="Status Group" class="h-14 w-auto object-contain">
                </div>
            </div>
            
            <!-- Partner 5: Copixel -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/6.png" alt="Copixel" class="h-14 w-auto object-contain">
                </div>
            </div>
            
            <!-- Partner 6: Finance Strategy -->
            <div class="flex flex-col items-center justify-center p-4">
                <div class="mb-2 flex items-center justify-center">
                    <img src="/Frontend/images/clients/1.png" alt="Finance Strategy" class="h-14 w-auto object-contain">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- News Section -->
<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Section Header -->
        <div class="text-center mb-12">
        <div class="text-sm font-semibold text-[#1e3a8a] uppercase tracking-wide mb-4">Latest Blog</div>
            <h2 class="text-2xl md:text-3xl font-bold text-[#1e3a8a] mb-4">
                Learn some new info from our <br>
                <span class="relative">
                    latest news
                    <div class="absolute -bottom-1 left-0 w-full h-1 bg-[#1e3a8a]"></div>
                </span>
            </h2>
        </div>

        <!-- News Cards -->
        <div class="grid md:grid-cols-3 gap-8 mb-12">
            <!-- News Article 1 -->
            <div class="bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="h-48 bg-cover bg-center bg-no-repeat" style="background-image: url('/Frontend/images/resource/news-1.jpg');">
                </div>
                <div class="p-6">
                    <div class="text-sm text-[#1e3a8a] mb-2">February 26, 2024</div>
                    <h3 class="text-xl font-bold text-[#1e3a8a] mb-3">Invest in Your Future</h3>
                    <p class="text-[#1e3a8a] leading-relaxed">Work with a dedicated advisor who can personalize a plan that evolves with you as your priorities change.</p>
                </div>
            </div>

            <!-- News Article 2 -->
            <div class="bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="h-48 bg-cover bg-center bg-no-repeat" style="background-image: url('/Frontend/images/resource/news-2.jpg');">
                </div>
                <div class="p-6">
                    <div class="text-sm text-[#1e3a8a] mb-2">February 12, 2024</div>
                    <h3 class="text-xl font-bold text-[#1e3a8a] mb-3">CARES Act Paycheck Protection Program</h3>
                    <p class="text-[#1e3a8a] leading-relaxed">Learn more about the SBA stimulus package.</p>
                </div>
            </div>

            <!-- News Article 3 -->
            <div class="bg-white rounded-lg shadow-lg overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="h-48 bg-cover bg-center bg-no-repeat" style="background-image: url('/Frontend/images/resource/news-3.jpg');">
                </div>
                <div class="p-6">
                    <div class="text-sm text-[#1e3a8a] mb-2">January 15, 2024</div>
                    <h3 class="text-xl font-bold text-[#1e3a8a] mb-3">Online Banking with Fluent</h3>
                    <p class="text-[#1e3a8a] leading-relaxed">Banking done quick and easy.</p>
                </div>
            </div>
        </div>

        <!-- View More Button -->
        <div class="text-center">
            <button class="inline-flex items-center px-8 py-3 bg-[#1e3a8a] text-white font-semibold rounded-full hover:bg-blue-800 transition-colors duration-300 group">
                View More
                <div class="ml-3 w-8 h-8 bg-[#1e3a8a] rounded-full flex items-center justify-center group-hover:bg-blue-800 transition-colors duration-300">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                    </svg>
                </div>
            </button>
        </div>
    </div>
</section>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const slider = document.getElementById('slider');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const dots = document.querySelectorAll('[data-slide]');
    
    let currentSlide = 0;
    const totalSlides = 3;
    
    function updateSlider() {
        const translateX = -currentSlide * 100;
        slider.style.transform = `translateX(${translateX}%)`;
        
        // Update dots
        dots.forEach((dot, index) => {
            if (index === currentSlide) {
                dot.classList.remove('bg-gray-300');
                dot.classList.add('bg-[#1e3a8a]');
            } else {
                dot.classList.remove('bg-[#1e3a8a]');
                dot.classList.add('bg-gray-300');
            }
        });
    }
    
    function nextSlide() {
        currentSlide = (currentSlide + 1) % totalSlides;
        updateSlider();
    }
    
    function prevSlide() {
        currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
        updateSlider();
    }
    
    // Event listeners
    nextBtn.addEventListener('click', nextSlide);
    prevBtn.addEventListener('click', prevSlide);
    
    // Dot navigation
    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            currentSlide = index;
            updateSlider();
        });
    });
    
    // Auto-play (optional)
    setInterval(nextSlide, 5000);
});

// Partners Carousel
document.addEventListener('DOMContentLoaded', function() {
    const partnersCarousel = document.getElementById('partnersCarousel');
    const partnersPrevBtn = document.getElementById('partnersPrevBtn');
    const partnersNextBtn = document.getElementById('partnersNextBtn');
    const partnerDots = document.querySelectorAll('[data-partner-slide]');
    
    let currentPartnerSlide = 0;
    const totalPartnerSlides = 3; // 6 partners, 2 per slide = 3 slides
    
    function updatePartnersCarousel() {
        const translateX = -currentPartnerSlide * 50; // 50% per slide (2 partners per slide)
        partnersCarousel.style.transform = `translateX(${translateX}%)`;
        
        // Update dots
        partnerDots.forEach((dot, index) => {
            if (index === currentPartnerSlide) {
                dot.classList.remove('bg-gray-300');
                dot.classList.add('bg-[#1e3a8a]');
            } else {
                dot.classList.remove('bg-[#1e3a8a]');
                dot.classList.add('bg-gray-300');
            }
        });
    }
    
    function nextPartnerSlide() {
        currentPartnerSlide = (currentPartnerSlide + 1) % totalPartnerSlides;
        updatePartnersCarousel();
    }
    
    function prevPartnerSlide() {
        currentPartnerSlide = (currentPartnerSlide - 1 + totalPartnerSlides) % totalPartnerSlides;
        updatePartnersCarousel();
    }
    
    // Event listeners
    if (partnersNextBtn) {
        partnersNextBtn.addEventListener('click', nextPartnerSlide);
    }
    if (partnersPrevBtn) {
        partnersPrevBtn.addEventListener('click', prevPartnerSlide);
    }
    
    // Dot navigation
    partnerDots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            currentPartnerSlide = index;
            updatePartnersCarousel();
        });
    });
    
    // Auto-play for partners carousel
    setInterval(nextPartnerSlide, 4000);
});
</script>
@endpush
