<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Transfer Receipt</title>
    <link rel="stylesheet" href="{{ asset('pdf.css') }}" type="text/css">
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <div class="logo-section">
            <img src="{{ asset(\App\Helpers\SettingsHelper::bankLogo()) }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="logo">
        </div>
    </div>

    <!-- Receipt Title -->
    <div class="receipt-title">
        <h1>Transaction Receipt</h1>
        <p class="generation-info">Generated from {{ \App\Helpers\SettingsHelper::bankName() }} on {{ now()->format('d/m/y H:i:s') }}</p>
    </div>

    <!-- Transaction Details -->
    <table class="transaction-details">
        <tr>
            <td class="label">Transaction Amount:</td>
            <td class="value">
                <div class="amount-value">{{ $transaction->currency }} {{ number_format($transaction->amount, 2) }}</div>
            </td>
        </tr>
        
        <tr>
            <td class="label">Transaction Type:</td>
            <td class="value">{{ strtoupper($transaction->subcategory ?? 'transfer') }} TRANSFER</td>
        </tr>
        
        <tr>
            <td class="label">Transaction Date:</td>
            <td class="value">{{ $transaction->created_at->format('Y-m-d H:i:s') }}</td>
        </tr>
        
        <tr>
            <td class="label">Sender:</td>
            <td class="value">{{ auth()->user()->name ?? 'Account Holder' }}</td>
        </tr>
        
        @if($transaction->subcategory === 'international')
        <tr>
            <td class="label">Beneficiary:</td>
            <td class="value">
                <div class="beneficiary-details">
                    @if($transaction->metadata['manual_transfer'] ?? false)
                        <div class="value">{{ $transaction->metadata['recipient_details']['name'] ?? 'N/A' }}</div>
                        @if($transaction->metadata['recipient_details']['account_number'] ?? false)
                        <div class="value">{{ $transaction->metadata['recipient_details']['account_number'] }}</div>
                        @endif
                        <div class="value">{{ $transaction->metadata['recipient_details']['country'] ?? 'N/A' }}</div>
                    @elseif($beneficiary)
                        <div class="value">{{ $beneficiary->name }}</div>
                        @if($beneficiary->account_number)
                        <div class="value">{{ $beneficiary->account_number }}</div>
                        @endif
                        <div class="value">{{ $beneficiary->country }}</div>
                    @else
                        <div class="value">N/A</div>
                    @endif
                </div>
            </td>
        </tr>
        @endif
        
        @if($transaction->description)
        <tr>
            <td class="label">Remark:</td>
            <td class="value">{{ $transaction->description }}</td>
        </tr>
        @endif
        
        <tr>
            <td class="label">Transaction Reference:</td>
            <td class="value">{{ $transaction->transaction_id }}</td>
        </tr>
        
        <tr>
            <td class="label">Transaction Status:</td>
            <td class="value">
                {{ ucfirst($transaction->status) }}
            </td>
        </tr>
        
        @if($transaction->fee_amount > 0)
        <tr>
            <td class="label">Transfer Fee:</td>
            <td class="value">{{ $transaction->currency }} {{ number_format($transaction->fee_amount, 2) }}</td>
        </tr>
        @endif
        
        <tr>
            <td class="label">Total Amount:</td>
            <td class="value">
                <div class="amount-value">{{ $transaction->currency }} {{ number_format($transaction->net_amount, 2) }}</div>
            </td>
        </tr>
    </table>

    <!-- Additional Beneficiary Information -->
    @if($transaction->subcategory === 'international')
    <table class="transaction-details">
        @if($transaction->metadata['manual_transfer'] ?? false)
            @if($transaction->metadata['recipient_details']['address'] ?? false)
            <tr>
                <td class="label">Address:</td>
                <td class="value">{{ $transaction->metadata['recipient_details']['address'] }}</td>
            </tr>
            @endif
            
            @if($transaction->metadata['recipient_details']['iban'] ?? false)
            <tr>
                <td class="label">IBAN:</td>
                <td class="value">{{ $transaction->metadata['recipient_details']['iban'] }}</td>
            </tr>
            @endif
            
            @if($transaction->metadata['recipient_details']['swift_code'] ?? false)
            <tr>
                <td class="label">SWIFT Code:</td>
                <td class="value">{{ $transaction->metadata['recipient_details']['swift_code'] }}</td>
            </tr>
            @endif
        @elseif($beneficiary)
            @if($beneficiary->address)
            <tr>
                <td class="label">Address:</td>
                <td class="value">{{ $beneficiary->address }}</td>
            </tr>
            @endif
            
            @if($beneficiary->iban)
            <tr>
                <td class="label">IBAN:</td>
                <td class="value">{{ $beneficiary->iban }}</td>
            </tr>
            @endif
            
            @if($beneficiary->swift_code)
            <tr>
                <td class="label">SWIFT Code:</td>
                <td class="value">{{ $beneficiary->swift_code }}</td>
            </tr>
            @endif
        @endif
    </table>
    @endif

    <!-- QR Code Section -->
    <div class="qr-section">
        <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data={{ urlencode($transaction->transaction_id) }}" 
             alt="Transaction QR Code" class="qr-code">
        <p class="qr-label">Scan to verify transaction</p>
    </div>

    <!-- Contact Information -->
    <div class="contact-section">
        <p>If you have any questions or would like more information, please call our 24-hour Contact Centre on {{ \App\Helpers\SettingsHelper::bankPhone() }} or send an email to {{ \App\Helpers\SettingsHelper::supportEmail() }}</p>
        <p class="thank-you">Thank you for choosing {{ \App\Helpers\SettingsHelper::bankName() }}.</p>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Banking with {{ \App\Helpers\SettingsHelper::bankName() }}: Branch | ATM | Online | Mobile | Contact Centre</p>
        <p>This is an official receipt for your transfer transaction.</p>
        <p>Generated on {{ now()->format('M d, Y h:i A') }}</p>
    </div>
</body>
</html>
