<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Account Statement</title>
    <link rel="stylesheet" href="{{ asset('account-statement.css') }}" type="text/css">
</head>
<body>
    <!-- Header Section -->
    <div class="header-container">
        <div class="left-header">
            <div class="bank-branding">
                <img src="{{ asset(\App\Helpers\SettingsHelper::bankLogo()) }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="bank-logo">
            </div>
            <div class="bank-license">
                {{ \App\Helpers\SettingsHelper::bankCode() }} - {{ \App\Helpers\SettingsHelper::bankSwiftCode() }}<br>
                {{ \App\Helpers\SettingsHelper::bankAddress() }}
            </div>
            
            <div class="customer-info">
                <div class="customer-name">{{ strtoupper(auth()->user()->name ?? 'ACCOUNT HOLDER') }}</div>
                <div class="customer-address">
                    {{ auth()->user()->profile->address_line_1 ?? 'Address not provided' }}
                </div>
            </div>
        </div>

                 <div class="right-summary">
             <div class="summary-title">Transaction Summary</div>
             <div class="summary-box">
                 <div class="summary-row">
                     <span class="summary-label">Account Number</span>
                     <span class="summary-value">{{ $masterAccount->account_number }}</span>
                 </div>
                 <div class="summary-row">
                     <span class="summary-label">Opening Balance</span>
                     <span class="summary-value">{{ \App\Helpers\CurrencyHelper::format((float)$openingBalance, $currency) }}</span>
                 </div>
                 <div class="summary-row">
                     <span class="summary-label">Closing Balance</span>
                     <span class="summary-value">{{ \App\Helpers\CurrencyHelper::format((float)$currentBalance, $currency) }}</span>
                 </div>
             </div>
         </div>
    </div>

    <!-- Main Content Section -->
    <div class="main-section">
        <div class="section-header">Account Activity</div>
        
        <div class="welcome-text">
            Dear {{ strtoupper(auth()->user()->name ?? 'ACCOUNT HOLDER') }},<br>
            Here's your account information and a list of transactions 
            @if($dateFrom && $dateTo)
                from {{ \Carbon\Carbon::parse($dateFrom)->format('d/m/y') }}-{{ \Carbon\Carbon::parse($dateTo)->format('d/m/y') }}.
            @else
                for all periods.
            @endif
        </div>

        <div class="note-text">
            <strong>Note:</strong> Please check that the entries listed on this statement are correct. For further information on your account including details of features, fees, any errors or complaints, please contact us on the details above. Proceeds of cheques are not available until cleared.
        </div>

        <!-- Transaction Table -->
        <table class="transaction-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Transaction</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                @if($processedTransactions->count() > 0)
                    <!-- Opening Balance Row -->
                    <tr>
                        <td>{{ $processedTransactions->first()['transaction']->created_at->format('d M') }}</td>
                        <td>
                            <div class="transaction-description">OPENING BALANCE</div>
                        </td>
                        <td></td>
                        <td></td>
                        <td>{{ \App\Helpers\CurrencyHelper::format((float)($openingBalance ?? 0), $currency) }}</td>
                    </tr>
                    
                    @foreach($processedTransactions->take(50) as $processedTransaction)
                        <tr>
                            <td>{{ $processedTransaction['transaction']->created_at->format('d M') }}</td>
                            <td>
                                <div class="transaction-description">
                                    {{ strtoupper($processedTransaction['transaction']->description ?: $processedTransaction['type_label']) }}
                                </div>
                                @if($processedTransaction['transaction']->reference)
                                    <div class="transaction-reference">
                                        {{ $processedTransaction['transaction']->reference }}
                                    </div>
                                @endif
                            </td>
                            <td>
                                @if(!$processedTransaction['is_credit'])
                                    <span class="debit-amount">
                                        {{ \App\Helpers\CurrencyHelper::format((float)$processedTransaction['transaction']->amount, $processedTransaction['transaction']->currency ?? $currency) }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                @if($processedTransaction['is_credit'])
                                    <span class="credit-amount">
                                        {{ \App\Helpers\CurrencyHelper::format((float)$processedTransaction['transaction']->amount, $processedTransaction['transaction']->currency ?? $currency) }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                {{ \App\Helpers\CurrencyHelper::format((float)($processedTransaction['running_balance'] ?? $currentBalance), $currency) }}
                            </td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="5" style="text-align: center; padding: 30px; color: #666;">
                            No transactions found for the selected period
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>

    <!-- Contact Information -->
    <div class="contact-info">
        If you have any questions about this statement or would like more information,<br>
        please call our 24-hour Contact Centre on <strong>{{ \App\Helpers\SettingsHelper::bankPhone() }}</strong> or send an email to <strong>{{ \App\Helpers\SettingsHelper::supportEmail() }}</strong><br><br>
        <strong>Thank you for choosing {{ \App\Helpers\SettingsHelper::bankName() }}.</strong>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p><strong>Banking with {{ \App\Helpers\SettingsHelper::bankName() }}:</strong> Branch | ATM | Online | Mobile | Contact Centre</p>
        <p>This is an official account statement for your records.</p>
        <p>Generated on {{ now()->format('M d, Y h:i A') }}</p>
    </div>
</body>
</html>