<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Inter-Account Transfer
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Transfer funds between your accounts with real-time exchange rates</p>
        </div>
    </div>

    <!-- Transfer Form -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Left Column - Transfer Form -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Transfer Details
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <form wire:submit.prevent="transfer" class="space-y-4">
                        <!-- Account Selection -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- From Account -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">{{ __('From Account') }}</label>
                                <flux:dropdown class="w-full">
                                    <flux:button 
                                        variant="outline" 
                                        class="w-full justify-between text-sm"
                                        icon:trailing="chevron-down"
                                    >
                                        @if($fromAccount)
                                            {{ $fromAccount['label'] }}
                                        @else
                                            Select Source Account
                                        @endif
                                    </flux:button>
                                    <flux:menu>
                                        @foreach($userAccounts as $account)
                                            <flux:menu.item 
                                                wire:click="$set('fromAccountId', '{{ $account['id'] }}')"
                                                class="cursor-pointer"
                                            >
                                                <div class="flex flex-col">
                                                    <span class="font-medium">{{ $account['label'] }}</span>
                                                    <span class="text-xs text-gray-500">
                                                        Balance: {{ number_format($account['balance'], 2) }} {{ $account['currency'] }}
                                                    </span>
                                                </div>
                                            </flux:menu.item>
                                        @endforeach
                                    </flux:menu>
                                </flux:dropdown>
                                @if($fromAccount)
                                    <div class="mt-2 p-3 bg-gray-50 rounded-lg">
                                        <div class="flex justify-between text-xs">
                                            <span class="text-gray-600">Available Balance:</span>
                                            <span class="font-medium text-gray-900">
                                                {{ number_format($fromAccount['balance'], 2) }} {{ $fromAccount['currency'] }}
                                            </span>
                                        </div>
                                    </div>
                                @endif
                            </div>

                            <!-- To Account -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">{{ __('To Account') }}</label>
                                <flux:dropdown class="w-full">
                                    <flux:button 
                                        variant="outline" 
                                        class="w-full justify-between text-sm"
                                        icon:trailing="chevron-down"
                                    >
                                        @if($toAccount)
                                            {{ $toAccount['label'] }}
                                        @else
                                            Select Destination Account
                                        @endif
                                    </flux:button>
                                    <flux:menu>
                                        @foreach($userAccounts as $account)
                                            <flux:menu.item 
                                                wire:click="$set('toAccountId', '{{ $account['id'] }}')"
                                                class="cursor-pointer"
                                            >
                                                <div class="flex flex-col">
                                                    <span class="font-medium">{{ $account['label'] }}</span>
                                                    <span class="text-xs text-gray-500">
                                                        Balance: {{ number_format($account['balance'], 2) }} {{ $account['currency'] }}
                                                    </span>
                                                </div>
                                            </flux:menu.item>
                                        @endforeach
                                    </flux:menu>
                                </flux:dropdown>
                                @if($toAccount)
                                    <div class="mt-2 p-2 bg-gray-50 rounded-lg">
                                        <div class="flex justify-between text-xs">
                                            <span class="text-gray-600">Current Balance:</span>
                                            <span class="font-medium text-gray-900">
                                                {{ number_format($toAccount['balance'], 2) }} {{ $toAccount['currency'] }}
                                            </span>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Amount and Description -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <flux:input
                                    wire:model.live="amount"
                                    :label="__('Amount')"
                                    type="number"
                                    step="0.01"
                                    min="0.01"
                                    placeholder="0.00"
                                    class="w-full text-sm"
                                    icon:leading="dollar-sign"
                                />
                            </div>

                            <div>
                                <flux:input
                                    wire:model="description"
                                    :label="__('Description')"
                                    type="text"
                                    placeholder="Transfer purpose (optional)"
                                    class="w-full text-sm"
                                    icon:leading="file-text"
                                />
                            </div>
                        </div>

                        <!-- Exchange Rate Information -->
                        @if($showExchangeRate && $fromAccount && $toAccount && $fromAccount['currency'] !== $toAccount['currency'])
                            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                <div class="flex items-center mb-3">
                                    <flux:icon name="info" class="w-5 h-5 text-blue-600 mr-2" />
                                    <h3 class="text-sm font-medium text-blue-800">Exchange Rate Information</h3>
                                </div>
                                
                                @if($loading)
                                    <div class="flex items-center text-sm text-blue-700">
                                        <flux:icon name="loader" class="w-4 h-4 mr-2 animate-spin" />
                                        Calculating exchange rate...
                                    </div>
                                @else
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                                        <div>
                                            <span class="text-blue-600">Exchange Rate:</span>
                                            <div class="font-medium text-blue-800">
                                                1 {{ $fromAccount['currency'] }} = {{ number_format($exchangeRate, 6) }} {{ $toAccount['currency'] }}
                                            </div>
                                        </div>
                                        <div>
                                            <span class="text-blue-600">Amount to Transfer:</span>
                                            <div class="font-medium text-blue-800">
                                                {{ number_format($amount, 2) }} {{ $fromAccount['currency'] }}
                                            </div>
                                        </div>
                                        <div>
                                            <span class="text-blue-600">Amount to Receive:</span>
                                            <div class="font-medium text-blue-800">
                                                {{ number_format($convertedAmount, 2) }} {{ $toAccount['currency'] }}
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        @endif

                        <!-- Transfer Summary -->
                        @if($fromAccount && $toAccount && $amount && $amount > 0)
                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                <h3 class="text-sm font-medium text-gray-800 mb-3">Transfer Summary</h3>
                                <div class="space-y-2 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">From:</span>
                                        <span class="font-medium text-gray-900">
                                            {{ $fromAccount['label'] }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">To:</span>
                                        <span class="font-medium text-gray-900">
                                            {{ $toAccount['label'] }}
                                        </span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-600">Amount:</span>
                                        <span class="font-medium text-gray-900">
                                            {{ number_format($amount, 2) }} {{ $fromAccount['currency'] }}
                                        </span>
                                    </div>
                                    @if($fromAccount['currency'] !== $toAccount['currency'])
                                        <div class="flex justify-between">
                                            <span class="text-gray-600">You'll Receive:</span>
                                            <span class="font-medium text-gray-900">
                                                {{ number_format($convertedAmount, 2) }} {{ $toAccount['currency'] }}
                                            </span>
                                        </div>
                                    @endif
                                    @if($description)
                                        <div class="flex justify-between">
                                            <span class="text-gray-600">Description:</span>
                                            <span class="font-medium text-gray-900">{{ $description }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <!-- Action Buttons -->
                        <div class="flex items-center justify-end space-x-3 pt-4 border-t border-gray-200">
                            <flux:button
                                type="button"
                                wire:click="resetForm"
                                variant="primary"
                                class="px-6"
                            >
                                Reset
                            </flux:button>
                            
                            <flux:button
                                type="submit"
                                variant="filled"
                                class="px-6"
                                :disabled="$loading || !$fromAccountId || !$toAccountId || !$amount || $amount <= 0"
                                wire:loading.attr="disabled"
                            >
                                <flux:icon 
                                    name="loader" 
                                    class="w-4 h-4 mr-2" 
                                    wire:loading 
                                    wire:target="transfer"
                                />
                                {{ $loading ? 'Processing...' : 'Transfer Funds' }}
                            </flux:button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Right Column - Help Information -->
        <div class="lg:col-span-1 space-y-4">
            <!-- Help Information Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            How It Works
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3 text-sm text-gray-700">
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Same currency transfers are instant</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Cross-currency uses real-time rates</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Rates updated hourly from ExchangeRate</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>All transfers processed immediately</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Exchange Rate Status Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Exchange Rate Status
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Service Status</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                Active
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Update Frequency</span>
                            <span class="text-xs font-medium text-gray-900">Hourly</span>
                        </div>
                        <div class="flex justify-between items-center py-1.5">
                            <span class="text-gray-600 text-xs">Provider</span>
                            <span class="text-xs font-medium text-gray-900">ExchangeRate</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('livewire:navigated', () => {
    Livewire.on('$refresh', () => {
        window.location.reload();
    });
});
</script>