<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Local Transfer
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Transfer funds to domestic accounts within the same country</p>
        </div>
        <div class="flex items-center space-x-2 text-xs text-gray-500 mt-2 lg:mt-0">
            <flux:icon name="clock" class="w-4 h-4" />
            <span>Instant processing</span>
        </div>
    </div>

    <!-- Transfer Form -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Left Column - Transfer Form -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Transfer Details
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <form wire:submit="showTransferSummary" class="space-y-6">
    <!-- Form Header -->
    <div class="text-center border-b border-gray-200 pb-4">
        <h2 class="text-lg font-semibold text-gray-900">Money Transfer</h2>
        <p class="text-sm text-gray-600 mt-1">Send money securely to beneficiaries</p>
    </div>

    <!-- Section 1: Account Selection -->
    <div class="bg-white border border-gray-200 rounded-lg p-4">
        <h3 class="text-md font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">1</span>
            Account Selection
        </h3>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- From Account -->
            <div class="space-y-3">
                <label class="block text-sm font-medium text-gray-700">From Account *</label>
                <flux:dropdown class="w-full">
                    <flux:button 
                        variant="outline" 
                        class="w-full justify-between text-sm h-10"
                        icon:trailing="chevron-down"
                    >
                        @if($selectedAccount)
                            {{ $selectedAccount['label'] }}
                        @else
                            Select Source Account
                        @endif
                    </flux:button>
                    <flux:menu>
                        @foreach($this->userAccounts as $account)
                            <flux:menu.item 
                                wire:click="$set('fromAccountId', '{{ $account['id'] }}')"
                                class="cursor-pointer"
                            >
                                <div class="flex flex-col">
                                    <span class="font-medium">{{ $account['label'] }}</span>
                                    <span class="text-xs text-gray-500">
                                        Balance: {{ number_format($account['balance'], 2) }} {{ $account['currency'] }}
                                    </span>
                                </div>
                            </flux:menu.item>
                        @endforeach
                    </flux:menu>
                </flux:dropdown>
                
                @if($selectedAccount)
                    <div class="bg-gray-50 rounded-lg p-3 space-y-2">
                        <div class="flex justify-between text-xs">
                            <span class="text-gray-600">Available Balance:</span>
                            <span class="font-semibold text-green-600">
                                {{ number_format($selectedAccount['balance'], 2) }} {{ $selectedAccount['currency'] }}
                            </span>
                        </div>
                        <div class="flex justify-between text-xs">
                            <span class="text-gray-600">Daily Limit:</span>
                            <span class="font-medium text-gray-900">
                                {{ number_format($selectedAccount['daily_transfer_limit'], 2) }} {{ $selectedAccount['currency'] }}
                            </span>
                        </div>
                        <div class="flex justify-between text-xs">
                            <span class="text-gray-600">Monthly Limit:</span>
                            <span class="font-medium text-gray-900">
                                {{ number_format($selectedAccount['monthly_transfer_limit'], 2) }} {{ $selectedAccount['currency'] }}
                            </span>
                        </div>
                    </div>
                @endif
            </div>

            <!-- To Beneficiary -->
            <div class="space-y-3">
                <label class="block text-sm font-medium text-gray-700">Transfer To *</label>
                
                <!-- Transfer Type Toggle -->
                <div class="flex bg-gray-100 rounded-lg p-1">
                    <button 
                        type="button"
                        wire:click="$set('useManualDetails', false)"
                        class="flex-1 px-3 py-2 text-sm font-medium rounded-md transition-colors
                            {{ !$useManualDetails ? 'bg-white text-gray-900 shadow-sm' : 'text-gray-500 hover:text-gray-700' }}"
                    >
                        Saved Beneficiary
                    </button>
                    <button 
                        type="button"
                        wire:click="$set('useManualDetails', true)"
                        class="flex-1 px-3 py-2 text-sm font-medium rounded-md transition-colors
                            {{ $useManualDetails ? 'bg-white text-gray-900 shadow-sm' : 'text-gray-500 hover:text-gray-700' }}"
                    >
                        Manual Entry
                    </button>
                </div>

                @if(!$useManualDetails)
                    <!-- Saved Beneficiary Selection -->
                    <div class="flex gap-2">
                        <flux:dropdown class="flex-1">
                            <flux:button 
                                variant="outline" 
                                class="w-full justify-between text-sm h-10"
                                icon:trailing="chevron-down"
                            >
                                @if($selectedBeneficiary)
                                    {{ $selectedBeneficiary->name }}
                                @else
                                    Select Beneficiary
                                @endif
                            </flux:button>
                            <flux:menu>
                                @foreach($this->beneficiaries as $beneficiary)
                                    <flux:menu.item 
                                        wire:click="$set('beneficiaryId', '{{ $beneficiary->id }}')"
                                        class="cursor-pointer"
                                    >
                                        <div class="flex flex-col">
                                            <span class="font-medium">{{ $beneficiary->name }}</span>
                                            <span class="text-xs text-gray-500">{{ $beneficiary->bank_name }}</span>
                                        </div>
                                    </flux:menu.item>
                                @endforeach
                            </flux:menu>
                        </flux:dropdown>
                        <flux:button 
                            type="button" 
                            wire:navigate.hover
                            href="{{ route('user.beneficiaries') }}"
                            variant="outline"
                            class="px-3 h-10"
                            title="Add New Beneficiary"
                        >
                            <flux:icon name="plus" class="w-4 h-4" />
                        </flux:button>
                    </div>
                    
                    @if($selectedBeneficiary)
                        <div class="bg-gray-50 rounded-lg p-3">
                            <div class="flex justify-between text-xs">
                                <span class="text-gray-600">Bank:</span>
                                <span class="font-medium text-gray-900">{{ $selectedBeneficiary->bank_name }}</span>
                            </div>
                        </div>
                    @endif
                @endif
            </div>
        </div>
    </div>

    <!-- Section 2: Manual Entry (conditionally shown) -->
    @if($useManualDetails)
        <div class="bg-white border border-gray-200 rounded-lg p-4">
            <h3 class="text-md font-medium text-gray-800 mb-4 flex items-center">
                <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">2</span>
                Recipient Details
            </h3>
            
            <div class="space-y-4">
                <!-- Primary Details -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                    <flux:input
                        wire:model="recipientName"
                        label="Recipient Name *"
                        placeholder="Enter recipient name"
                        class="text-sm"
                        required
                    />
                    <flux:input
                        wire:model="recipientBankName"
                        label="Bank Name *"
                        placeholder="Enter bank name"
                        class="text-sm"
                        required
                    />
                </div>
                
                <flux:input
                    wire:model="recipientAccountNumber"
                    label="Account Number *"
                    placeholder="Enter account number"
                    class="text-sm"
                    required
                />
                
                <!-- Contact Information -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                    <flux:input
                        wire:model="recipientEmail"
                        label="Email (Optional)"
                        type="email"
                        placeholder="recipient@example.com"
                        class="text-sm"
                    />
                    <flux:input
                        wire:model="recipientPhone"
                        label="Phone (Optional)"
                        placeholder="+1 (555) 123-4567"
                        class="text-sm"
                    />
                </div>
                
                <!-- Address Information -->
                <div class="space-y-4">
                    <flux:input
                        wire:model="recipientAddress"
                        label="Address (Optional)"
                        placeholder="Enter address"
                        class="text-sm"
                    />
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <flux:input
                            wire:model="recipientCity"
                            label="City (Optional)"
                            placeholder="City"
                            class="text-sm"
                        />
                        <flux:input
                            wire:model="recipientState"
                            label="State (Optional)"
                            placeholder="State"
                            class="text-sm"
                        />
                        <flux:input
                            wire:model="recipientPostalCode"
                            label="Postal Code (Optional)"
                            placeholder="12345"
                            class="text-sm"
                        />
                    </div>
                    
                    <flux:input
                        wire:model="recipientCountry"
                        label="Country (Optional)"
                        placeholder="Country"
                        class="text-sm"
                    />
                </div>
            </div>
        </div>
    @endif

    <!-- Section 3: Transfer Details -->
    <div class="bg-white border border-gray-200 rounded-lg p-4">
        <h3 class="text-md font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">{{ $useManualDetails ? '3' : '2' }}</span>
            Transfer Details
        </h3>
        
        <div class="space-y-4">
            <!-- Amount and Description -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                <flux:input
                    wire:model.live="amount"
                    label="Amount *"
                    type="number"
                    step="0.01"
                    min="0.01"
                    placeholder="0.00"
                    class="text-sm"
                    icon:leading="dollar-sign"
                    required
                />
                <flux:input
                    wire:model="description"
                    label="Description"
                    type="text"
                    placeholder="Transfer purpose (optional)"
                    class="text-sm"
                    icon:leading="file-text"
                />
            </div>

            <!-- Transfer Options -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                <div>
                    <flux:select wire:model.live="transferType" label="Transfer Type *">
                        <option value="">Select transfer type</option>
                        <option value="instant">Instant Transfer</option>
                        <option value="scheduled">Scheduled Transfer</option>
                    </flux:select>
                </div>
                <div>
                    <flux:select wire:model.live="transferMethod" label="Transfer Method *">
                        <option value="">Select transfer method</option>
                        <option value="online">Online Banking</option>
                        <option value="mobile">Mobile App</option>
                    </flux:select>
                </div>
            </div>

            <!-- Scheduled Date/Time (conditional) -->
            @if($transferType === 'scheduled')
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="text-sm font-medium text-blue-800 mb-3">Schedule Details</h4>
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                        <flux:input
                            wire:model.live="scheduledDate"
                            label="Scheduled Date *"
                            type="date"
                            min="{{ date('Y-m-d', strtotime('+1 day')) }}"
                            class="text-sm"
                            required
                        />
                        <flux:input
                            wire:model.live="scheduledTime"
                            label="Scheduled Time *"
                            type="time"
                            class="text-sm"
                            required
                        />
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Section 4: Transfer Cost Summary -->
    @if($amount && $selectedAccount && ($selectedBeneficiary || $useManualDetails))
        <div class="bg-gradient-to-r from-green-50 to-blue-50 border border-green-200 rounded-lg p-4">
            <h3 class="text-md font-medium text-gray-800 mb-4 flex items-center">
                <span class="bg-green-100 text-green-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">💰</span>
                Transfer Cost Summary
            </h3>
            <div class="bg-white rounded-lg p-4">
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Transfer Amount:</span>
                        <span class="font-semibold text-gray-900">{{ $currency }} {{ number_format($amount, 2) }}</span>
                    </div>
                    <div class="border-t border-gray-200 pt-3">
                        <div class="flex justify-between">
                            <span class="font-semibold text-gray-900">Total Amount:</span>
                            <span class="font-bold text-lg text-green-600">{{ $currency }} {{ number_format($totalAmount, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Action Buttons -->
    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
        <div class="flex flex-col sm:flex-row items-center justify-between space-y-3 sm:space-y-0 sm:space-x-3">
            <div class="text-sm text-gray-600">
                <span class="font-medium">Note:</span> Please review all details before proceeding.
            </div>
            
            <div class="flex space-x-3">
                <flux:button
                    type="button"
                    wire:click="resetForm"
                    variant="outline"
                    class="px-6 py-2"
                    icon="refresh-cw"
                >
                    Reset Form
                </flux:button>
                
                <flux:button
                    type="submit"
                    wire:click="proceedToReview"
                    variant="filled"
                    class="px-6 py-2"
                    icon="arrow-right"
                >
                    Continue to Review
                </flux:button>
            </div>
        </div>
    </div>
</form>
                </div>
            </div>
        </div>

        <!-- Right Column - Help Information -->
        <div class="lg:col-span-1 space-y-4">
            <!-- Help Information Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            How It Works
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3 text-sm text-gray-700">
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Domestic transfers are instant</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Low fees for local transfers</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Same currency processing</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>All transfers processed immediately</span>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Transfer Summary Modal -->
    @if($showTransferSummary)
        <div class="fixed inset-0 bg-gray-600/50 flex items-center justify-center p-4 z-50">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Transfer Summary</h3>
                    <flux:button wire:click="hideTransferSummary" variant="subtle" size="sm" icon="x">
                    </flux:button>
                </div>

                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        <div>
                            <span class="text-gray-600">From:</span>
                            <p class="font-medium">{{ $selectedAccount['label'] ?? 'N/A' }}</p>
                            <p class="text-gray-500">{{ $selectedAccount['currency'] ?? 'N/A' }} {{ number_format($selectedAccount['balance'] ?? 0, 2) }}</p>
                        </div>
                        <div>
                            <span class="text-gray-600">To:</span>
                            @if($useManualDetails)
                                <p class="font-medium">{{ $recipientName ?? 'N/A' }}</p>
                                <p class="text-gray-500">{{ $recipientBankName ?? 'N/A' }}</p>
                                <p class="text-gray-500">{{ $recipientAccountNumber ?? 'N/A' }}</p>
                            @else
                                <p class="font-medium">{{ $selectedBeneficiary->name ?? 'N/A' }}</p>
                                <p class="text-gray-500">{{ $selectedBeneficiary->account_number ?? 'N/A' }}</p>
                            @endif
                        </div>
                    </div>

                    <div class="border-t pt-4">
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Amount:</span>
                                <span class="font-medium">{{ $currency }} {{ number_format($amount, 2) }}</span>
                            </div>
                            <div class="flex justify-between border-t pt-2">
                                <span class="text-gray-900 font-medium">Total:</span>
                                <span class="font-bold text-gray-900">{{ $currency }} {{ number_format($totalAmount, 2) }}</span>
                            </div>
                        </div>
                    </div>

                    @if($transferType === 'scheduled')
                        <div class="bg-blue-50 p-3 rounded-lg">
                            <p class="text-sm text-blue-800">
                                <flux:icon name="clock" class="w-4 h-4 inline mr-1" />
                                Scheduled for {{ \Carbon\Carbon::parse($scheduledDate . ' ' . $scheduledTime)->format('M j, Y g:i A') }}
                            </p>
                        </div>
                    @endif
                </div>

                <div class="pt-4 border-t">
                    <div class="flex gap-3">
                        <flux:button wire:click="hideTransferSummary" variant="subtle" class="flex-1" icon="x">
                            Cancel
                        </flux:button>
                        <flux:button 
                            wire:click="showPin" 
                            variant="primary" 
                            class="flex-1"
                            icon="arrow-right"
                        >
                            Confirm Transfer
                        </flux:button>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- PIN Verification Modal -->
    @if($showPinVerification)
        <div class="fixed inset-0 bg-gray-600/50 flex items-center justify-center p-4 z-[60]">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Enter Your PIN</h3>
                    <flux:button wire:click="hidePinVerification" variant="subtle" size="sm" icon="x">
                    </flux:button>
                </div>

                <div class="space-y-4">
                    <p class="text-sm text-gray-600">
                        Please enter your 6-digit PIN to confirm this transfer.
                    </p>
                    
                    <div>
                        <flux:input
                            wire:model="pin"
                            label="PIN"
                            type="password"
                            maxlength="6"
                            placeholder="••••••"
                            class="w-full text-center text-lg tracking-widest"
                            autocomplete="off"
                        />
                        <flux:error name="pin" />
                    </div>

                    <div class="flex gap-3 pt-4">
                        <flux:button 
                            wire:click="hidePinVerification" 
                            variant="subtle" 
                            class="flex-1"
                        >
                            Cancel
                        </flux:button>
                        <flux:button 
                            wire:click="verifyPin" 
                            variant="primary" 
                            class="flex-1"
                            icon="check"
                        >
                            Verify PIN
                        </flux:button>
                    </div>
                </div>
            </div>
        </div>
    @endif

</div>