<div class="min-h-screen bg-gray-50 p-2">
    <!-- Toast Notification for KYC Required -->
    @if(session('kyc_required'))
        <script>
            document.addEventListener('livewire:navigated', function() {
                setTimeout(() => {
                    if (window.Flux && window.Flux.toast) {
                        window.Flux.toast({
                            variant: '{{ session('kyc_variant') }}',
                            heading: '{{ session('kyc_heading') }}',
                            text: '{{ session('kyc_text') }}',
                            duration: 6000
                        });
                    }
                }, 100);
            });
        </script>
    @endif

    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                KYC Verification
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Complete your identity verification to access all banking features</p>
        </div>
        <div class="flex items-center gap-3 mt-2 lg:mt-0">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium {{ $this->getKycStatusColor() }}">
                {{ $this->getKycStatusLabel() }}
            </span>
            <div class="text-right">
            <div class="text-base font-semibold text-gray-800">{{ $kycProgress }}% <span class="text-sm text-gray-600 font-normal">Complete</span></div>
            </div>
        </div>
    </div>

    <!-- KYC Progress Card -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden mb-6">
        <div class="px-4 py-4">
            <div class="flex items-center justify-between mb-3">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Verification Progress
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <span class="text-xs text-gray-600">{{ $kycProgress }}% Complete</span>
            </div>
            
            <!-- Progress Bar -->
            <div class="w-full bg-gray-200 rounded-full h-2 mb-4">
                <div class="bg-gradient-to-r from-[#04327c] to-[#032a6a] h-2 rounded-full transition-all duration-300" 
                     style="width: {{ $kycProgress }}%"></div>
            </div>
            
            <!-- Progress Details -->
            <div class="grid grid-cols-2 gap-4 text-xs">
                <div class="flex justify-between">
                    <span class="text-gray-600">Required Documents:</span>
                    <span class="font-medium">{{ collect($requiredDocuments)->where('required', true)->count() }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Approved:</span>
                    <span class="font-medium text-green-600">{{ collect($requiredDocuments)->where('required', true)->where('approved', true)->count() }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Required Documents -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden mb-6">
        <div class="px-4 py-4">
            <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                Required Documents
                <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
            </h3>
            <p class="text-xs text-gray-600 mt-1.5 mb-4">Upload the following documents to complete your verification</p>
            
            <div class="space-y-3">
                @foreach($requiredDocuments as $type => $document)
                    <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg {{ $document['approved'] ? 'bg-green-50 border-green-200' : ($document['uploaded'] ? 'bg-amber-50 border-amber-200' : 'bg-gray-50') }}">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 rounded-lg flex items-center justify-center {{ $document['approved'] ? 'bg-green-100' : ($document['uploaded'] ? 'bg-amber-100' : 'bg-gray-100') }}">
                                @if($document['approved'])
                                    <flux:icon name="check-circle" class="w-4 h-4 text-green-600" />
                                @elseif($document['uploaded'])
                                    <flux:icon name="clock" class="w-4 h-4 text-amber-600" />
                                @else
                                    <flux:icon name="document-text" class="w-4 h-4 text-gray-600" />
                                @endif
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-900">{{ $document['name'] }}</div>
                                <div class="text-xs text-gray-600">{{ $document['description'] }}</div>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2">
                            @if($document['approved'])
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    Approved
                                </span>
                            @elseif($document['uploaded'])
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-amber-100 text-amber-800">
                                    Pending Review
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    Not Uploaded
                                </span>
                            @endif
                            
                            @if(!$document['approved'])
                                <flux:button 
                                    wire:click="openUploadModal('{{ $type }}')" 
                                    variant="outline" 
                                    size="sm" 
                                    class="text-xs"
                                >
                                    {{ $document['uploaded'] ? 'Re-upload' : 'Upload' }}
                                </flux:button>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Uploaded Documents -->
    @if(!empty($uploadedDocuments))
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden mb-6">
            <div class="px-4 py-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Uploaded Documents
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <p class="text-xs text-gray-600 mt-1.5 mb-4">Your submitted documents and their review status</p>
                
                <div class="space-y-3">
                    @foreach($uploadedDocuments as $document)
                        <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 rounded-lg flex items-center justify-center {{ $this->getDocumentStatusColor($document['status']) }}">
                                    <flux:icon name="{{ $this->getDocumentStatusIcon($document['status']) }}" class="w-4 h-4" />
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900">{{ $document['document_name'] }}</div>
                                    <div class="text-xs text-gray-600">{{ $document['document_type_label'] }} • {{ $document['file_size_human'] }}</div>
                                    <div class="text-xs text-gray-500">Uploaded: {{ \Carbon\Carbon::parse($document['created_at'])->format('M d, Y') }}</div>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $this->getDocumentStatusColor($document['status']) }}">
                                    {{ $document['status_label'] }}
                                </span>
                                
                                @if($document['status'] === 'pending')
                                    <flux:button 
                                        wire:click="deleteDocument({{ $document['id'] }})" 
                                        variant="ghost" 
                                        size="sm" 
                                        class="text-red-600 hover:text-red-800"
                                    >
                                        <flux:icon name="trash" class="w-3 h-3" />
                                    </flux:button>
                                @endif
                            </div>
                        </div>
                        
                        @if($document['status'] === 'rejected' && $document['rejection_reason'])
                            <div class="mt-2 p-2 bg-red-50 border border-red-200 rounded text-xs text-red-700">
                                <strong>Rejection Reason:</strong> {{ $document['rejection_reason'] }}
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Upload Form Modal -->
    @if($showUploadForm)
        <div class="fixed inset-0 bg-gray-600/50 flex items-center justify-center p-4 z-50">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm w-full max-w-md">
                <div class="px-4 py-4 border-b border-gray-200">
                    <div class="flex items-center justify-between">
                        <h3 class="text-sm font-semibold text-gray-900">Upload Document</h3>
                        <flux:button 
                            wire:click="hideUploadForm" 
                            variant="ghost" 
                            size="sm"
                            class="text-gray-400 hover:text-gray-600"
                        >
                            <flux:icon name="x-mark" class="w-4 h-4" />
                        </flux:button>
                    </div>
                </div>
                
                <div class="px-4 py-4">
                    <form wire:submit="uploadDocuments" class="space-y-4">
                        <!-- Document Type -->
                        <div>
                            <flux:select
                                wire:model="documentType"
                                :label="__('Document Type')"
                                required
                                class="w-full text-sm"
                            >
                                <option value="">Select document type</option>
                                <option value="id">Government ID</option>
                                <option value="passport">Passport</option>
                                <option value="utility_bill">Utility Bill</option>
                                <option value="bank_statement">Bank Statement</option>
                                <option value="proof_of_address">Proof of Address</option>
                            </flux:select>
                            @error('documentType')
                                <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Document Name -->
                        <div>
                            <flux:input
                                wire:model="documentName"
                                :label="__('Document Name')"
                                type="text"
                                required
                                placeholder="e.g., Driver's License"
                                class="w-full text-sm"
                            />
                            @error('documentName')
                                <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- File Upload -->
                        <div>
                            <flux:input
                                wire:model="documents"
                                :label="__('Upload Files')"
                                type="file"
                                multiple
                                accept=".pdf,.jpg,.jpeg,.png"
                                class="w-full text-sm"
                            />
                            <p class="text-xs text-gray-500 mt-1">PDF, JPG, JPEG, PNG files up to 10MB each</p>
                            @error('documents.*')
                                <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex space-x-3 pt-4 border-t border-gray-100">
                            <flux:button
                                wire:click="uploadDocuments" 
                                type="submit" 
                                variant="primary" 
                                class="flex-1 text-sm"
                            >
                            Upload Documents
                            </flux:button>
                            
                            <flux:button 
                                type="button"
                                wire:click="hideUploadForm" 
                                variant="filled" 
                                class="px-6 py-2 text-sm"
                            >
                                Cancel
                            </flux:button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- Help Section -->
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
        <div class="flex items-start space-x-3">
            <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mt-0.5" />
            <div>
                <h4 class="text-sm font-medium text-blue-800 mb-1">Document Requirements</h4>
                <ul class="text-xs text-blue-700 space-y-1">
                    <li>• Documents must be clear and readable</li>
                    <li>• All text and images must be visible</li>
                    <li>• Documents must be valid and not expired</li>
                    <li>• File size limit: 10MB per document</li>
                    <li>• Supported formats: PDF, JPG, JPEG, PNG</li>
                </ul>
            </div>
        </div>
    </div>
</div>
