<div class="min-h-screen bg-gray-50 p-4">
    <div class="max-w-2xl mx-auto">
        <!-- Header -->
        <div class="text-center mb-6">
            <h1 class="text-xl font-semibold text-gray-900 mb-1">Code Verification</h1>
            <p class="text-sm text-gray-600">Complete the verification steps to proceed with your transfer</p>
        </div>

        <!-- Transfer Summary -->
        @if($pendingTransfer)
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 mb-4">
            <h3 class="text-base font-semibold text-gray-900 mb-3">Transfer Summary</h3>
            <div class="space-y-2">
                <div class="flex justify-between">
                    <span class="text-sm text-gray-600">Amount:</span>
                    <span class="text-sm font-medium text-gray-900">{{ $pendingTransfer['currency'] }} {{ number_format($pendingTransfer['amount'], 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-sm text-gray-600">To:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($pendingTransfer['metadata']['manual_transfer'] ?? false)
                            {{ $pendingTransfer['metadata']['recipient_details']['name'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->name ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                @if($pendingTransfer['type'] === 'international')
                <div class="flex justify-between">
                    <span class="text-sm text-gray-600">Country:</span>
                    <span class="text-sm font-medium text-gray-900">
                        @if($pendingTransfer['metadata']['manual_transfer'] ?? false)
                            {{ $pendingTransfer['metadata']['recipient_details']['country'] ?? 'N/A' }}
                        @else
                            {{ $beneficiary?->country ?? 'N/A' }}
                        @endif
                    </span>
                </div>
                @endif
            </div>
        </div>
        @endif

        <!-- Current Step -->
        @if($currentStepIndex < count($availableSteps) && !$isLoading)
            @php $currentStepData = $availableSteps[$currentStepIndex]; @endphp
            <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 mb-4">
                <div class="text-center mb-4">
                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <flux:icon name="{{ $currentStepData['icon'] }}" class="w-6 h-6 text-blue-600" />
                    </div>
                    <h3 class="text-base font-semibold text-gray-900 mb-1">{{ $currentStepData['title'] }}</h3>
                    <p class="text-sm text-gray-600">{{ $currentStepData['description'] }}</p>
                </div>
                <!-- Code Input -->
                <div class="space-y-3">
                    @if($currentStepData['type'] === 'twofactor')
                        @if(!$twoFactorCodeSent)
                            <div class="text-center">
                                <p class="text-sm text-gray-600 mb-3">We'll send a 6-digit verification code to your email address.</p>
                                <flux:button 
                                    wire:click="sendTwoFactorCode" 
                                    variant="primary"
                                    class="w-full"
                                    :disabled="$isLoading"
                                >
                                    Send 2FA Code
                                </flux:button>
                            </div>
                        @else
                            <flux:input 
                                wire:model="twoFactorCode" 
                                placeholder="Enter 6-digit code"
                                class="w-full text-center text-lg font-mono"
                                maxlength="6"
                            />
                            
                            <div class="flex gap-2">
                                <flux:button 
                                    wire:click="submitCode" 
                                    variant="primary"
                                    class="flex-1"
                                    :disabled="$isLoading"
                                >
                                    Verify Code
                                </flux:button>
                                
                                <flux:button 
                                    wire:click="resendTwoFactorCode" 
                                    variant="outline"
                                    class="flex-1"
                                    :disabled="$twoFactorResendCooldown > 0 || $isLoading"
                                >
                                    @if($twoFactorResendCooldown > 0)
                                        Resend ({{ $twoFactorResendCooldown }}s)
                                    @else
                                        Resend
                                    @endif
                                </flux:button>
                            </div>
                        @endif
                    @else
                        <flux:input 
                            wire:model="{{ $currentStepData['type'] . 'Code' }}" 
                            placeholder="Enter {{ $currentStepData['type'] }} code"
                            class="w-full text-center text-lg font-mono"
                            maxlength="20"
                        />
                        
                        <flux:button 
                            wire:click="submitCode" 
                            variant="primary"
                            class="w-full"
                            :disabled="$isLoading"
                        >
                            Verify {{ ucfirst($currentStepData['type']) }} Code
                        </flux:button>
                    @endif
                </div>
            </div>
        @endif

        <!-- Completed Steps -->
        @if($currentStepIndex > 0)
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4 mb-4">
            <h3 class="text-base font-semibold text-gray-900 mb-3">Completed Steps</h3>
            <div class="space-y-2">
                @foreach($availableSteps as $index => $step)
                    @if($index < $currentStepIndex)
                    <div class="flex items-center justify-between py-2 px-3 bg-green-50 rounded-lg">
                        <div class="flex items-center">
                            <flux:icon name="{{ $step['icon'] }}" class="w-4 h-4 text-green-600 mr-2" />
                            <span class="text-sm font-medium text-green-800">{{ $step['title'] }}</span>
                        </div>
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600" />
                    </div>
                    @endif
                @endforeach
            </div>
        </div>
        @endif

        <!-- Complete Transfer Button -->
        @if($allCodesVerified)
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-4">
            <div class="text-center">
                <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                    <flux:icon name="check-circle" class="w-6 h-6 text-green-600" />
                </div>
                <h3 class="text-base font-semibold text-gray-900 mb-2">All Verifications Complete!</h3>
                <p class="text-sm text-gray-600 mb-4">You can now complete your transfer</p>
                
                <flux:button 
                    wire:click="completeTransfer" 
                    variant="primary"
                    class="w-full"
                >
                    Complete Transfer
                </flux:button>
            </div>
        </div>
        @endif

        <!-- Loading Overlay -->
        @if($isLoading)
        <div class="fixed inset-0 bg-gray-900/50 flex items-center justify-center z-[9999]">
            <div class="bg-white rounded-lg p-6 max-w-sm mx-4">
                <div class="text-center">
                    @if($showNextStep)
                        <flux:icon name="check-circle" class="w-8 h-8 text-green-600 mx-auto mb-3" />
                        <h3 class="text-base font-semibold text-gray-900 mb-1">Code Verified!</h3>
                        <p class="text-sm text-gray-600">Preparing next step...</p>
                    @else
                        <flux:icon name="arrow-path" class="w-8 h-8 text-blue-600 mx-auto mb-3 animate-spin" />
                        <h3 class="text-base font-semibold text-gray-900 mb-1">Verifying Code</h3>
                        <p class="text-sm text-gray-600">Please wait while we verify your code...</p>
                    @endif
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

<script>
document.addEventListener('livewire:navigated', () => {
    Livewire.on('show-next-step', () => {
        setTimeout(() => {
            @this.call('proceedToNextStep');
        }, 2000); // 2 second delay
    });

    Livewire.on('start-resend-countdown', () => {
        let countdown = 60;
        const interval = setInterval(() => {
            countdown--;
            @this.set('twoFactorResendCooldown', countdown);
            
            if (countdown <= 0) {
                clearInterval(interval);
            }
        }, 1000);
    });
});
</script>