<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Cheque Deposit
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Deposit cheques into your account for processing</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button icon="arrow-left" variant="ghost" size="sm" class="flex items-center gap-1 px-2.5 py-1 text-xs" href="{{ route('dashboard') }}" wire:navigate>
                Back to Dashboard
            </flux:button>
        </div>
    </div>

    <!-- Main Content -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Deposit Form -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                <h2 class="text-sm font-semibold text-gray-900 mb-4">Cheque Information</h2>
                
                <form class="space-y-4">
                    <!-- Account Selection -->
                    <div>
                        <flux:field>
                            <flux:label>Deposit to Account</flux:label>
                            <flux:select wire:model.live="accountId" placeholder="Select account">
                                @foreach($userAccounts as $account)
                                    <option value="{{ $account->id }}">
                                        {{ $account->account_name }} - {{ $account->account_number }} ({{ $account->currency_symbol }}{{ number_format((float)$account->balance, 2) }})
                                    </option>
                                @endforeach
                            </flux:select>
                            <flux:error name="accountId" />
                        </flux:field>
                    </div>

                    <!-- Amount -->
                    <div>
                        <flux:field>
                            <flux:label>Cheque Amount</flux:label>
                            <flux:input 
                                wire:model="amount" 
                                type="number" 
                                step="0.01" 
                                min="0.01" 
                                max="100000"
                                placeholder="0.00"
                            />
                            <flux:error name="amount" />
                        </flux:field>
                    </div>

                    <!-- Bank Information -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <flux:field>
                                <flux:label>Bank Name</flux:label>
                                <flux:input wire:model="bankName" placeholder="Enter bank name" />
                                <flux:error name="bankName" />
                            </flux:field>
                        </div>
                        <div>
                            <flux:field>
                                <flux:label>Cheque Number</flux:label>
                                <flux:input wire:model="chequeNumber" placeholder="Enter cheque number" />
                                <flux:error name="chequeNumber" />
                            </flux:field>
                        </div>
                    </div>

                    <!-- Optional Bank Details -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <flux:field>
                                <flux:label>Routing Number (Optional)</flux:label>
                                <flux:input wire:model="routingNumber" placeholder="Enter routing number" />
                                <flux:error name="routingNumber" />
                            </flux:field>
                        </div>
                        <div>
                            <flux:field>
                                <flux:label>Account Number (Optional)</flux:label>
                                <flux:input wire:model="accountNumber" placeholder="Enter account number" />
                                <flux:error name="accountNumber" />
                            </flux:field>
                        </div>
                    </div>

                    <!-- Description -->
                    <div>
                        <flux:field>
                            <flux:label>Description (Optional)</flux:label>
                            <flux:textarea wire:model="description" placeholder="Enter description for this deposit" rows="2" />
                            <flux:error name="description" />
                        </flux:field>
                    </div>

                    <!-- Notes -->
                    <div>
                        <flux:field>
                            <flux:label>Additional Notes (Optional)</flux:label>
                            <flux:textarea wire:model="notes" placeholder="Any additional notes or comments" rows="2" />
                            <flux:error name="notes" />
                        </flux:field>
                    </div>

                    <!-- File Uploads -->
                    <div class="space-y-4">
                        <h3 class="text-sm font-medium text-gray-900">Cheque Images</h3>
                        
                        <!-- Front Image -->
                        <div>
                            <flux:field>
                                <flux:label>Front of Cheque</flux:label>
                                <flux:input 
                                    wire:model="frontImage" 
                                    type="file" 
                                    accept="image/*,application/pdf"
                                />
                                <flux:error name="frontImage" />
                                <flux:description>Upload a clear image of the front of the cheque (JPG, PNG, or PDF, max 10MB)</flux:description>
                            </flux:field>
                        </div>

                        <!-- Back Image -->
                        <div>
                            <flux:field>
                                <flux:label>Back of Cheque</flux:label>
                                <flux:input 
                                    wire:model="backImage" 
                                    type="file" 
                                    accept="image/*,application/pdf"
                                />
                                <flux:error name="backImage" />
                                <flux:description>Upload a clear image of the back of the cheque (JPG, PNG, or PDF, max 10MB)</flux:description>
                            </flux:field>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-4">
                        <flux:modal.trigger name="cheque-deposit-preview">
                            <flux:button 
                                variant="primary" 
                                class="w-full"
                                wire:click="showPreview"
                            >
                                Review Deposit
                            </flux:button>
                        </flux:modal.trigger>
                    </div>
                </form>
            </div>
        </div>

        <!-- Information Panel -->
        <div class="space-y-4">
            <!-- Deposit Guidelines -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-3">Deposit Guidelines</h3>
                <div class="space-y-2 text-xs text-gray-600">
                    <div class="flex items-start gap-2">
                        <flux:icon name="check-circle" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                        <span>Ensure cheque is properly endorsed</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <flux:icon name="check-circle" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                        <span>Take clear, well-lit photos</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <flux:icon name="check-circle" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                        <span>Include all four corners of the cheque</span>
                    </div>
                    <div class="flex items-start gap-2">
                        <flux:icon name="check-circle" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                        <span>Deposits are processed within 1-2 business days</span>
                    </div>
                </div>
            </div>

            <!-- Processing Times -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-3">Processing Times</h3>
                <div class="space-y-2 text-xs text-gray-600">
                    <div class="flex justify-between">
                        <span>Same Day</span>
                        <span class="font-medium text-green-600">Before 2:00 PM</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Next Business Day</span>
                        <span class="font-medium text-amber-600">After 2:00 PM</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Weekend/Holiday</span>
                        <span class="font-medium text-gray-500">Next Business Day</span>
                    </div>
                </div>
            </div>

            <!-- Limits -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-3">Deposit Limits</h3>
                <div class="space-y-2 text-xs text-gray-600">
                    <div class="flex justify-between">
                        <span>Daily Limit</span>
                        <span class="font-medium">$100,000</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Monthly Limit</span>
                        <span class="font-medium">$500,000</span>
                    </div>
                    <div class="flex justify-between">
                        <span>File Size</span>
                        <span class="font-medium">10MB max</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Preview Modal -->
    <flux:modal name="cheque-deposit-preview" class="md:w-128">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">Review Cheque Deposit</flux:heading>
                <flux:text class="mt-2">Please review your deposit details before submitting.</flux:text>
            </div>

            <div class="space-y-4">
                <!-- Deposit Summary -->
                <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Account:</span>
                        <span class="text-sm font-medium text-gray-900">
                            {{ $selectedAccount->account_name ?? 'N/A' }} - {{ $selectedAccount->account_number ?? 'N/A' }}
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Amount:</span>
                        <span class="text-sm font-semibold text-gray-900">
                            {{ $selectedAccount->currency_symbol ?? '$' }}{{ number_format((float)$amount, 2) }}
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Bank:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $bankName }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600">Cheque Number:</span>
                        <span class="text-sm font-medium text-gray-900">{{ $chequeNumber }}</span>
                    </div>
                    @if($description)
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Description:</span>
                            <span class="text-sm font-medium text-gray-900">{{ $description }}</span>
                        </div>
                    @endif
                </div>

                <!-- Images Preview -->
                <div class="space-y-3">
                    <h4 class="text-sm font-medium text-gray-900">Cheque Images</h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <p class="text-xs text-gray-600 mb-2">Front Image</p>
                            @if($frontImage)
                                <div class="bg-gray-100 rounded-lg p-2 text-center">
                                    <flux:icon name="document" class="w-8 h-8 text-gray-400 mx-auto mb-1" />
                                    <p class="text-xs text-gray-600">{{ $frontImage->getClientOriginalName() }}</p>
                                </div>
                            @endif
                        </div>
                        <div>
                            <p class="text-xs text-gray-600 mb-2">Back Image</p>
                            @if($backImage)
                                <div class="bg-gray-100 rounded-lg p-2 text-center">
                                    <flux:icon name="document" class="w-8 h-8 text-gray-400 mx-auto mb-1" />
                                    <p class="text-xs text-gray-600">{{ $backImage->getClientOriginalName() }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex gap-3 pt-4">
                <flux:button 
                    variant="outline" 
                    class="flex-1"
                    x-on:click="$dispatch('modal-close', { name: 'cheque-deposit-preview' })"
                >
                    Edit Details
                </flux:button>
                <flux:button 
                    variant="primary" 
                    class="flex-1"
                    wire:click="submitDeposit"
                >
                    Submit Deposit
                </flux:button>
            </div>
        </div>
    </flux:modal>
</div>
