<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Beneficiary Management
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage your beneficiaries for fund transfers</p>
        </div>
        <flux:button icon="plus" wire:click="showAddForm" variant="filled" class="px-4 py-2 text-sm">
            Add Beneficiary
        </flux:button>
    </div>

    <!-- Beneficiaries List -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
        <!-- Left Column - Beneficiaries List -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Your Beneficiaries
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>
                    
                    @if($this->beneficiaries->count() > 0)
                        <div class="space-y-3">
                            @foreach($this->beneficiaries as $beneficiary)
                                <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                                        <div class="flex-1 min-w-0">
                                            <div class="flex items-start space-x-3">
                                                <div class="flex-shrink-0">
                                                    <div class="w-10 h-10 bg-[#04327c] rounded-full flex items-center justify-center">
                                                        <span class="text-white font-semibold text-sm">
                                                            {{ substr($beneficiary->name, 0, 2) }}
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="flex-1 min-w-0">
                                                    <h3 class="font-medium text-gray-900 truncate">{{ $beneficiary->name }}</h3>
                                                    <p class="text-sm text-gray-600 truncate">{{ $beneficiary->bank_name }} - {{ $beneficiary->account_number }}</p>
                                                    <p class="text-xs text-gray-500 truncate">{{ $beneficiary->country }} • {{ $beneficiary->currency }}</p>
                                                    
                                                    <!-- Badges moved below content for mobile -->
                                                    <div class="flex flex-wrap items-center gap-2 mt-2">
                                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                                            {{ $beneficiary->type === 'domestic' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800' }}">
                                                            {{ ucfirst($beneficiary->type) }}
                                                        </span>
                                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                                                            {{ $beneficiary->verification_status === 'verified' ? 'bg-green-100 text-green-800' : 
                                                               ($beneficiary->verification_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') }}">
                                                            {{ ucfirst($beneficiary->verification_status) }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Action buttons -->
                                        <div class="flex items-center justify-end sm:justify-start space-x-2">
                                            <flux:button 
                                                wire:click="showEditForm({{ $beneficiary->id }})" 
                                                variant="outline" 
                                                size="sm"
                                                class="px-3"
                                            >
                                                <flux:icon name="pencil" class="w-4 h-4" />
                                            </flux:button>
                                            <flux:button 
                                                wire:click="deleteBeneficiary({{ $beneficiary->id }})" 
                                                variant="danger" 
                                                size="sm"
                                                class="px-3"
                                                onclick="return confirm('Are you sure you want to delete this beneficiary?')"
                                            >
                                                <flux:icon name="trash" class="w-4 h-4" />
                                            </flux:button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12">
                            <flux:icon name="users" class="w-12 h-12 text-gray-400 mx-auto mb-4" />
                            <h3 class="text-lg font-medium text-gray-900 mb-2">No beneficiaries yet</h3>
                            <p class="text-gray-600 mb-4">Add your first beneficiary to start making transfers.</p>
                            <flux:button icon="plus" wire:click="showAddForm" variant="filled" class="px-4 py-2">
                                Add Your First Beneficiary
                            </flux:button>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column - Help Information -->
        <div class="lg:col-span-1 space-y-4">
            <!-- Help Information Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            How It Works
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3 text-sm text-gray-700">
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Add beneficiaries for quick transfers</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Verify beneficiary information</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Set transfer limits and preferences</span>
                        </div>
                        <div class="flex items-start space-x-2">
                            <flux:icon name="circle-check" class="w-4 h-4 text-green-600 mt-0.5 flex-shrink-0" />
                            <span>Manage domestic and international</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Verification Status Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Verification Status
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Verified</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                Ready
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Pending</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                Reviewing
                            </span>
                        </div>
                        <div class="flex justify-between items-center py-1.5">
                            <span class="text-gray-600 text-xs">Rejected</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                Needs Update
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transfer Types Card -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
                <div class="px-4 py-4">
                    <div class="text-left mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                            Transfer Types
                            <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                        </h3>
                    </div>

                    <div class="space-y-3">
                        <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                            <span class="text-gray-600 text-xs">Domestic</span>
                            <span class="text-xs font-medium text-gray-900">Same Country</span>
                        </div>
                        <div class="flex justify-between items-center py-1.5">
                            <span class="text-gray-600 text-xs">International</span>
                            <span class="text-xs font-medium text-gray-900">SWIFT Network</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add/Edit Form Modal -->
    @if($showForm)
        <div class="fixed inset-0 bg-gray-600/50 flex items-center justify-center p-4 z-[9999]">
            <div class="bg-white rounded-lg shadow-xl max-w-2xl w-full p-6 max-h-[90vh] overflow-y-auto">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">
                        {{ $editingBeneficiary ? 'Edit Beneficiary' : 'Add New Beneficiary' }}
                    </h3>
                    <flux:button wire:click="hideForm" variant="outline" size="sm">
                        <flux:icon name="x" class="w-4 h-4" />
                    </flux:button>
                </div>

                <form wire:submit="saveBeneficiary" wire:live>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Name -->
                        <div class="space-y-2">
                            <flux:label for="name">Beneficiary Name</flux:label>
                            <flux:input wire:model="name" placeholder="Enter beneficiary name" />
                            <flux:error name="name" />
                        </div>

                        <!-- Type -->
                        <div class="space-y-2">
                            <flux:label for="type">Type</flux:label>
                            <flux:select wire:model.live="type">
                                <option value="domestic">Domestic</option>
                                <option value="international">International</option>
                            </flux:select>
                            <flux:error name="type" />
                        </div>

                        <!-- Email -->
                        <div class="space-y-2">
                            <flux:label for="email">Email (Optional)</flux:label>
                            <flux:input wire:model="email" type="email" placeholder="beneficiary@example.com" />
                            <flux:error name="email" />
                        </div>

                        <!-- Phone -->
                        <div class="space-y-2">
                            <flux:label for="phone">Phone (Optional)</flux:label>
                            <flux:input wire:model="phone" placeholder="+1 (555) 123-4567" />
                            <flux:error name="phone" />
                        </div>

                        <!-- Bank Name -->
                        <div class="space-y-2">
                            <flux:label for="bank_name">Bank Name</flux:label>
                            <flux:input wire:model="bank_name" placeholder="Enter bank name" />
                            <flux:error name="bank_name" />
                        </div>

                        <!-- Account Number -->
                        <div class="space-y-2">
                            <flux:label for="account_number">Account Number</flux:label>
                            <flux:input wire:model="account_number" placeholder="Enter account number" />
                            <flux:error name="account_number" />
                        </div>

                        <!-- IBAN (for international transfers) -->
                        @if($type === 'international')
                        <div class="space-y-2" wire:key="iban-field">
                            <flux:label for="iban">IBAN</flux:label>
                            <flux:input wire:model="iban" placeholder="Enter IBAN (International Bank Account Number)" />
                            <flux:error name="iban" />
                        </div>
                        @endif

                        <!-- SWIFT Code (for international transfers) -->
                        @if($type === 'international')
                        <div class="space-y-2" wire:key="swift-field">
                            <flux:label for="swift_code">SWIFT Code</flux:label>
                            <flux:input wire:model="swift_code" placeholder="Enter SWIFT/BIC code" />
                            <flux:error name="swift_code" />
                        </div>
                        @endif

                        <!-- Bank Address (for international transfers) -->
                        @if($type === 'international')
                        <div class="space-y-2" wire:key="address-field">
                            <flux:label for="address">Bank Address</flux:label>
                            <flux:input wire:model="address" placeholder="Enter bank address" />
                            <flux:error name="address" />
                        </div>
                        @endif

                        <!-- Country -->
                        <div class="space-y-2">
                            <flux:label for="country_id">Country</flux:label>
                            <flux:dropdown class="w-full">
                                <flux:button 
                                    variant="outline" 
                                    class="w-full justify-between text-sm"
                                    icon:trailing="chevron-down"
                                >
                                    @if($country_id)
                                        @php $selectedCountry = $this->countries->firstWhere('id', $country_id); @endphp
                                        {{ $selectedCountry ? $selectedCountry->name : 'Select Country' }}
                                    @else
                                        Select Country
                                    @endif
                                </flux:button>
                                <flux:menu>
                                    @foreach($this->countries as $country)
                                        <flux:menu.item 
                                            wire:click="$set('country_id', '{{ $country->id }}')"
                                            class="cursor-pointer"
                                        >
                                            <div class="flex items-center justify-between w-full">
                                                <span>{{ $country->name }}</span>
                                                <span class="text-xs text-gray-500">{{ $country->iso }}</span>
                                            </div>
                                        </flux:menu.item>
                                    @endforeach
                                </flux:menu>
                            </flux:dropdown>
                            <flux:error name="country_id" />
                        </div>

                        <!-- Currency -->
                        <div class="space-y-2">
                            <flux:label for="currency">Currency</flux:label>
                            <flux:dropdown class="w-full">
                                <flux:button 
                                    variant="outline" 
                                    class="w-full justify-between text-sm"
                                    icon:trailing="chevron-down"
                                >
                                    @if($currency)
                                        @php $selectedCurrency = $this->currencies->firstWhere('currency', $currency); @endphp
                                        {{ $selectedCurrency ? $selectedCurrency->currency . ' - ' . $selectedCurrency->currency_name : 'Select Currency' }}
                                    @else
                                        Select Currency
                                    @endif
                                </flux:button>
                                <flux:menu>
                                    @foreach($this->currencies as $currencyOption)
                                        <flux:menu.item 
                                            wire:click="$set('currency', '{{ $currencyOption->currency }}')"
                                            class="cursor-pointer"
                                        >
                                            <div class="flex items-center justify-between w-full">
                                                <span>{{ $currencyOption->currency }} - {{ $currencyOption->currency_name }}</span>
                                                @if($currencyOption->currency_symbol)
                                                    <span class="text-xs text-gray-500">{{ $currencyOption->currency_symbol }}</span>
                                                @endif
                                            </div>
                                        </flux:menu.item>
                                    @endforeach
                                </flux:menu>
                            </flux:dropdown>
                            <flux:error name="currency" />
                        </div>
                    </div>
                    <!-- Form Actions -->
                    <div class="flex justify-end space-x-3 mt-6 pt-4 border-t">
                        <flux:button type="button" wire:click="hideForm" variant="outline">
                            Cancel
                        </flux:button>
                        <flux:button icon="check" type="submit" variant="filled">
                            {{ $editingBeneficiary ? 'Update Beneficiary' : 'Add Beneficiary' }}
                        </flux:button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>