<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Account Statement
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">View your master account statement and transaction details</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button icon="arrow-down-tray" variant="outline" size="sm" class="flex items-center gap-1 px-2.5 py-1 text-xs" wire:click="exportStatement">
                Export PDF
            </flux:button>
            <flux:button icon="arrow-left" variant="ghost" size="sm" class="flex items-center gap-1 px-2.5 py-1 text-xs" href="{{ route('dashboard') }}" wire:navigate>
                Back to Dashboard
            </flux:button>
        </div>
    </div>

    @if($masterAccount)
        <!-- Account Info Card -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $masterAccount->account_name }}</h3>
                    <p class="text-xs text-gray-600">Account: {{ $masterAccount->account_number }}</p>
                </div>
                <div class="text-right">
                    <p class="text-lg font-bold text-gray-900">{{ \App\Helpers\CurrencyHelper::format((float)$currentBalance, $currency) }}</p>
                    <p class="text-xs text-gray-600">Available: {{ \App\Helpers\CurrencyHelper::format((float)$availableBalance, $currency) }}</p>
                </div>
            </div>
        </div>

        <!-- Statement Summary -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Statement Summary
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
            </div>
            
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <div class="text-center">
                    <p class="text-xl font-bold text-gray-900">{{ $summary['total_transactions'] }}</p>
                    <p class="text-xs text-gray-600">Total Transactions</p>
                </div>
                <div class="text-center">
                    <p class="text-xl font-bold text-green-600">{{ \App\Helpers\CurrencyHelper::format((float)$summary['total_credits'], $currency) }}</p>
                    <p class="text-xs text-gray-600">Total Credits</p>
                </div>
                <div class="text-center">
                    <p class="text-xl font-bold text-red-600">{{ \App\Helpers\CurrencyHelper::format((float)$summary['total_debits'], $currency) }}</p>
                    <p class="text-xs text-gray-600">Total Debits</p>
                </div>
                <div class="text-center">
                    <p class="text-xl font-bold {{ $summary['net_amount'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ \App\Helpers\CurrencyHelper::format((float)$summary['net_amount'], $currency) }}
                    </p>
                    <p class="text-xs text-gray-600">Net Amount</p>
                </div>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Filter Statement
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <flux:button variant="ghost" size="sm" wire:click="clearFilters" class="text-xs">
                    Clear Filters
                </flux:button>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <!-- Transaction Type -->
                <flux:field>
                    <flux:label>Transaction Type</flux:label>
                    <flux:select wire:model.live="transactionType" placeholder="All Types">
                        <option value="">All Types</option>
                        <option value="deposit">Deposit</option>
                        <option value="withdrawal">Withdrawal</option>
                        <option value="transfer">Transfer</option>
                        <option value="payment">Payment</option>
                        <option value="fee">Fee</option>
                        <option value="interest">Interest</option>
                        <option value="refund">Refund</option>
                    </flux:select>
                </flux:field>

                <!-- Status -->
                <flux:field>
                    <flux:label>Status</flux:label>
                    <flux:select wire:model.live="status" placeholder="All Statuses">
                        <option value="">All Statuses</option>
                        <option value="completed">Completed</option>
                        <option value="pending">Pending</option>
                        <option value="failed">Failed</option>
                        <option value="cancelled">Cancelled</option>
                        <option value="processing">Processing</option>
                    </flux:select>
                </flux:field>

                <!-- Date Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:date-picker wire:model.live="dateFrom" placeholder="From Date" selectable-header />
                    </flux:field>
                    <flux:field>
                        <flux:date-picker wire:model.live="dateTo" placeholder="To Date" selectable-header />
                    </flux:field>
                </div>

                <!-- Amount Range -->
                <div class="flex gap-2">
                    <flux:field>
                        <flux:input wire:model.live="amountFrom" type="number" step="0.01" placeholder="Min Amount" />
                    </flux:field>
                    <flux:field>
                        <flux:input wire:model.live="amountTo" type="number" step="0.01" placeholder="Max Amount" />
                    </flux:field>
                </div>

                <!-- Statement Options -->
                <div class="flex gap-4">
                    <flux:field>
                        <flux:checkbox wire:model.live="includePending" />
                        <flux:label>Include Pending</flux:label>
                    </flux:field>
                </div>
            </div>
        </div>

        <!-- Statement Table -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-sm font-semibold text-gray-900 mb-0.5 relative">
                    Account Statement
                    <div class="absolute bottom-0 left-0 w-[20px] h-[1px] bg-[#04327c]"></div>
                </h3>
                <p class="text-xs text-gray-600 mt-1.5">Showing {{ $transactions ? $transactions->count() : 0 }} of {{ $transactions ? $transactions->total() : 0 }} transactions</p>
            </div>

            <!-- Desktop Table -->
            <div class="hidden md:block overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Debit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Credit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Balance</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($transactions ?? [] as $transaction)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $transaction->created_at->format('M j, Y') }}
                                    <div class="text-xs text-gray-500">{{ $transaction->created_at->format('h:i A') }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ $transaction->description ?: $this->getTransactionTypeLabel($transaction->type) }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm text-gray-900">{{ $this->getTransactionTypeLabel($transaction->type) }}</span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $transaction->transaction_id }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    @if($transaction->from_account_id === $this->masterAccount->id)
                                        {{ \App\Helpers\CurrencyHelper::format((float)$transaction->amount, $transaction->currency ?? $currency) }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    @if($transaction->to_account_id === $this->masterAccount->id)
                                        {{ \App\Helpers\CurrencyHelper::format((float)$transaction->amount, $transaction->currency ?? $currency) }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ \App\Helpers\CurrencyHelper::format((float)$currentBalance, $currency) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($transaction->status) }}">
                                        <flux:icon name="{{ $this->getStatusIcon($transaction->status) }}" class="w-3 h-3 mr-1" />
                                        {{ $this->getStatusLabel($transaction->status) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-6 py-12 text-center">
                                    <div class="flex flex-col items-center">
                                        <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mb-4" />
                                        <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions found</h3>
                                        <p class="text-sm text-gray-500">Your statement will appear here</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Mobile Cards -->
            <div class="md:hidden divide-y divide-gray-200">
                @forelse($transactions ?? [] as $transaction)
                    <div class="p-4">
                        <div class="flex items-center justify-between mb-3">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center">
                                    <flux:icon name="{{ $this->getTransactionTypeIcon($transaction->type) }}" class="w-5 h-5 {{ $this->getTransactionTypeColor($transaction->type) }}" />
                                </div>
                                <div class="ml-3 flex-1">
                                    <p class="text-sm font-medium text-gray-900">
                                        {{ $transaction->description ?: $this->getTransactionTypeLabel($transaction->type) }}
                                    </p>
                                    <p class="text-sm text-gray-500">{{ $transaction->transaction_id }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="text-sm font-semibold {{ $this->getTransactionAmountColor($transaction) }}">
                                    {{ $this->getTransactionAmount($transaction) }}
                                </p>
                                <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getStatusColor($transaction->status) }}">
                                    {{ $this->getStatusLabel($transaction->status) }}
                                </span>
                            </div>
                        </div>
                        <div class="flex items-center justify-between text-xs text-gray-500">
                            <span>{{ $transaction->created_at->format('M j, Y h:i A') }}</span>
                            <span>{{ $this->getTransactionTypeLabel($transaction->type) }}</span>
                        </div>
                    </div>
                @empty
                    <div class="p-8 text-center">
                        <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mb-4 mx-auto" />
                        <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions found</h3>
                        <p class="text-sm text-gray-500">Your statement will appear here</p>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            @if($transactions && $transactions->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $transactions->links() }}
                </div>
            @endif
        </div>

    @else
        <!-- No Master Account Info -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-8 text-center">
            <flux:icon name="exclamation-triangle" class="w-16 h-16 text-amber-500 mx-auto mb-4" />
            <h3 class="text-lg font-semibold text-gray-900 mb-2">No Master Account Found</h3>
            <p class="text-sm text-gray-600 mb-6">
                You don't have a master account set up. Please contact support to set up your master account.
            </p>
            <flux:button variant="primary" href="{{ route('user.account.settings') }}" wire:navigate>
                Go to Account Settings
            </flux:button>
        </div>
    @endif

    <!-- Switch Account Info -->
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-4 mt-6">
        <div class="flex items-start">
            <flux:icon name="information-circle" class="w-5 h-5 text-blue-600 mt-0.5 mr-3 flex-shrink-0" />
            <div class="flex-1">
                <h4 class="text-sm font-medium text-blue-900 mb-1">View Other Account Statements</h4>
                <p class="text-sm text-blue-700 mb-3">
                    This page shows only your master account statement. To view statements for other accounts, 
                    please switch to the desired account in your account settings.
                </p>
                <flux:button 
                    variant="primary" 
                    size="sm" 
                    href="{{ route('user.account.settings') }}" 
                    wire:navigate
                    class="text-xs"
                >
                    Go to Account Settings
                </flux:button>
            </div>
        </div>
    </div>
</div>
