<div>
    <!-- Notifications -->
    <flux:dropdown position="bottom" align="end">
        <button class="relative p-2 text-white hover:bg-[#032159] rounded-md transition-colors">
            <flux:icon name="bell" class="w-5 h-5" />
            @if($unreadCount > 0)
                <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
            @endif
        </button>

        <flux:menu class="w-80">
            <div class="px-3 py-2 border-b border-gray-200">
                <h3 class="text-sm font-semibold text-gray-900">Notifications</h3>
                <p class="text-xs text-gray-500">
                    @if($unreadCount > 0)
                        You have {{ $unreadCount }} unread notification{{ $unreadCount > 1 ? 's' : '' }}
                    @else
                        No unread notifications
                    @endif
                </p>
            </div>
            
            <div class="max-h-96 overflow-y-auto">
                @forelse($notifications as $notification)
                    <div class="relative group">
                        <flux:menu.item 
                            class="flex items-start gap-3 px-3 py-3 hover:bg-gray-50 {{ !$notification->is_read ? 'bg-blue-50' : '' }}"
                            wire:click="markAsRead({{ $notification->id }})"
                        >
                            <div class="flex-shrink-0 w-2 h-2 {{ $this->getNotificationColor($notification->type) }} rounded-full mt-2"></div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm text-gray-900 font-medium">{{ $notification->title }}</p>
                                <p class="text-xs text-gray-600 mt-1">{{ $notification->message }}</p>
                                <p class="text-xs text-gray-400 mt-1">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                            @if(!$notification->is_read)
                                <div class="flex-shrink-0">
                                    <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                                </div>
                            @endif
                        </flux:menu.item>
                        @if($notification->is_read)
                            <button 
                                class="absolute top-2 right-2 p-1 text-gray-400 hover:text-red-500 hover:bg-red-50 rounded transition-all duration-200"
                                wire:click.stop="deleteNotification({{ $notification->id }})"
                                title="Delete notification"
                            >
                                <flux:icon name="trash" class="w-3 h-3" />
                            </button>
                        @endif
                    </div>
                @empty
                    <div class="px-3 py-6 text-center">
                        <flux:icon name="bell" class="w-8 h-8 text-gray-400 mx-auto mb-2" />
                        <p class="text-sm text-gray-500">No notifications yet</p>
                    </div>
                @endforelse
            </div>

            @if($notifications->count() > 0)
                <div class="border-t border-gray-200 px-3 py-2">
                    <div class="grid grid-cols-2 gap-2">
                        <flux:button 
                            variant="ghost" 
                            size="sm" 
                            class="text-xs"
                            wire:click="markAllAsRead"
                        >
                            Mark All as Read
                        </flux:button>
                        <flux:button 
                            variant="ghost" 
                            size="sm" 
                            class="text-xs text-red-600 hover:text-red-700 hover:bg-red-50"
                            wire:click="deleteAllNotifications"
                        >
                            Delete All
                        </flux:button>
                    </div>
                </div>
            @endif
        </flux:menu>
    </flux:dropdown>
</div>
