<header class="bg-[#1e3a8a] text-white px-4 py-3">
    <!-- Desktop Layout -->
    <div class="hidden md:flex items-center justify-between">
        <!-- Left Section: Bank Info & Balance -->
        <div class="flex items-center space-x-4">
            <!-- Bank Info with Dropdown -->
            <flux:dropdown position="bottom" align="start">
                <button class="flex items-center text-white hover:bg-[#032159] px-3 py-2 rounded-md transition-colors bg-[#032159]">
                    <img src="/images/card.png" alt="Card Logo" class="h-6 w-auto">
                    <div class="text-left ml-3">
                        <p class="text-base font-semibold">{{ \App\Helpers\SettingsHelper::bankName() }}</p>
                        <p class="text-xs font-medium text-gray-200">Available Balance: <span style="color: #F6DB77;">{{ $currencySymbol }}{{ number_format($availableBalance, 2) }}</span></p>
                    </div>
                    <flux:icon name="chevron-down" class="w-4 h-4 ml-4" />
                </button>

                <flux:menu class="w-64">
                    <flux:menu.radio.group>
                        <div class="p-3 border-b border-gray-200">
                            <p class="text-sm font-medium text-gray-900">Account Information</p>
                            <p class="text-xs text-gray-500 mt-1">Available Balance</p>
                            <p class="text-lg font-bold text-[#04327c]">{{ $currencySymbol }}{{ number_format($availableBalance, 2) }}</p>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item icon="eye" href="{{ route('user.account.statements') }}" wire:navigate>
                            View Statement
                        </flux:menu.item>
                        <flux:menu.item icon="document-text" href="{{ route('user.transfer.international') }}" wire:navigate>
                            Transfer Fund
                        </flux:menu.item>
                    </flux:menu.radio.group>
                </flux:menu>
            </flux:dropdown>
        </div>

        <!-- Right Section: User & Actions -->
        <div class="flex items-center space-x-3 ml-auto">

            <!-- Impersonation Indicator -->
            @impersonating()
                <div class="flex items-center space-x-2">
                    <div class="flex items-center px-3 py-2 bg-red-600 text-white rounded-full text-sm font-medium">
                        <flux:icon name="exclamation-triangle" class="w-4 h-4 mr-1" />
                        Impersonating
                    </div>
                    <a href="{{ route('impersonate.leave') }}" class="bg-white text-red-600 hover:bg-red-50 px-3 py-2 rounded-full text-sm font-medium transition-colors">
                        Leave
                    </a>
                </div>
            @endImpersonating

            <!-- Welcome Text -->
            <div class="text-right bg-[#032159] px-3 py-2 rounded-full">
                <p class="text-sm font-medium text-gray-200">Welcome {{ $user->name }}</p>
            </div>

            <!-- Notifications -->
            @livewire('layout.notification-dropdown')


            <!-- User Profile -->
            <flux:dropdown position="bottom" align="end">
                <button class="flex items-center space-x-2 text-white hover:bg-[#032159] px-2 py-2 rounded-md transition-colors">
                    @if($user->profile && $user->profile->profile_image_url)
                        <img src="{{ $user->profile->profile_image_url }}" 
                             alt="{{ $user->name }}" 
                             class="w-8 h-8 rounded-full object-cover border-2 border-white">
                    @else
                        <div class="w-8 h-8 bg-white rounded-full flex items-center justify-center">
                            <span class="text-[#1e3a8a] font-semibold text-sm">{{ substr($user->name, 0, 2) }}</span>
                        </div>
                    @endif
                    <flux:icon name="chevron-down" class="w-4 h-4" />
                </button>

                <flux:menu class="w-56">
                    <flux:menu.radio.group>
                        <div class="p-3 border-b border-gray-200">
                            <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                            <p class="text-xs text-gray-500">{{ $user->email }}</p>
                            <p class="text-xs text-gray-500">Customer ID: {{ $user->customer_id ?? 'N/A' }}</p>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item :href="route('user.profile')" icon="user" wire:navigate>
                            Profile Settings
                        </flux:menu.item>
                        <flux:menu.item :href="route('user.account.settings')" icon="cog" wire:navigate>
                            Account Settings
                        </flux:menu.item>
                        <flux:menu.item :href="route('user.preferences')" icon="lock-closed" wire:navigate>
                            Security Settings
                        </flux:menu.item>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    @impersonating()
                        <flux:menu.radio.group>
                            <flux:menu.item :href="route('impersonate.leave')" icon="arrow-left-start-on-rectangle" class="w-full text-blue-600">
                                Leave Impersonation
                            </flux:menu.item>
                        </flux:menu.radio.group>
                        <flux:menu.separator />
                    @endImpersonating

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full text-red-600">
                            Logout
                        </flux:menu.item>
                    </form>
                </flux:menu>
            </flux:dropdown>
        </div>
    </div>

    <!-- Mobile Layout -->
    <div class="md:hidden">
        <!-- Top Row: Bank Info -->
        <div class="flex items-center justify-between mb-3">
            <!-- Mobile Menu Toggle -->
            <button id="toggleMobileSidebar" type="button"
                    class="p-2 text-white hover:bg-[#032159] rounded-md">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>

            <!-- Bank Info with Dropdown -->
            <flux:dropdown position="bottom" align="start">
                <button class="flex items-center text-white hover:bg-[#032159] px-3 py-2 rounded-md transition-colors bg-[#032159]">
                    <img src="/images/card.png" alt="Card Logo" class="h-6 w-auto">
                    <div class="text-left ml-3">
                        <p class="text-base font-semibold">{{ \App\Helpers\SettingsHelper::bankName() }}</p>
                        <p class="text-xs font-medium text-gray-200">Available Balance: <span style="color: #F6DB77;">{{ $currencySymbol }}{{ number_format($availableBalance, 2) }}</span></p>
                    </div>
                    <flux:icon name="chevron-down" class="w-4 h-4 ml-4" />
                </button>

                <flux:menu class="w-64">
                    <flux:menu.radio.group>
                        <div class="p-3 border-b border-gray-200">
                            <p class="text-sm font-medium text-gray-900">Account Information</p>
                            <p class="text-xs text-gray-500 mt-1">Available Balance</p>
                            <p class="text-lg font-bold text-[#04327c]">{{ $currencySymbol }}{{ number_format($availableBalance, 2) }}</p>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item icon="eye" href="{{ route('user.account.statements') }}" wire:navigate>
                            View Statement
                        </flux:menu.item>
                        <flux:menu.item icon="document-text" href="{{ route('user.transfer.international') }}" wire:navigate>
                            Transfer Fund
                        </flux:menu.item>
                    </flux:menu.radio.group>
                </flux:menu>
            </flux:dropdown>

            <!-- User Profile -->
            <flux:dropdown position="bottom" align="end">
                <button class="flex items-center space-x-2 text-white hover:bg-[#032159] px-2 py-2 rounded-md transition-colors">
                    @if($user->profile && $user->profile->profile_image_url)
                        <img src="{{ $user->profile->profile_image_url }}" 
                             alt="{{ $user->name }}" 
                             class="w-8 h-8 rounded-full object-cover border-2 border-white">
                    @else
                        <div class="w-8 h-8 bg-white rounded-full flex items-center justify-center">
                            <span class="text-[#1e3a8a] font-semibold text-sm">{{ substr($user->name, 0, 2) }}</span>
                        </div>
                    @endif
                </button>

                <flux:menu class="w-56">
                    <flux:menu.radio.group>
                        <div class="p-3 border-b border-gray-200">
                            <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                            <p class="text-xs text-gray-500">{{ $user->email }}</p>
                            <p class="text-xs text-gray-500">Customer ID: {{ $user->customer_id ?? 'N/A' }}</p>
                        </div>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    <flux:menu.radio.group>
                        <flux:menu.item :href="route('user.profile')" icon="user" wire:navigate>
                            Profile Settings
                        </flux:menu.item>
                        <flux:menu.item :href="route('user.account.settings')" icon="cog" wire:navigate>
                            Account Settings
                        </flux:menu.item>
                        <flux:menu.item :href="route('user.preferences')" icon="lock-closed" wire:navigate>
                            Security Settings
                        </flux:menu.item>
                    </flux:menu.radio.group>

                    <flux:menu.separator />

                    @impersonating()
                        <flux:menu.radio.group>
                            <flux:menu.item :href="route('impersonate.leave')" icon="arrow-left-start-on-rectangle" class="w-full text-blue-600">
                                Leave Impersonation
                            </flux:menu.item>
                        </flux:menu.radio.group>
                        <flux:menu.separator />
                    @endImpersonating

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full text-red-600">
                            Logout
                        </flux:menu.item>
                    </form>
                </flux:menu>
            </flux:dropdown>
        </div>

        <!-- Bottom Row: Welcome Text -->
        <div class="flex items-center justify-end space-x-3">
            <!-- Impersonation Indicator (Mobile) -->
            @impersonating()
                <div class="flex items-center space-x-2">
                    <div class="flex items-center px-2 py-1 bg-red-600 text-white rounded-full text-xs font-medium">
                        <flux:icon name="exclamation-triangle" class="w-3 h-3 mr-1" />
                        Impersonating
                    </div>
                    <a href="{{ route('impersonate.leave') }}" class="bg-white text-red-600 hover:bg-red-50 px-2 py-1 rounded-full text-xs font-medium transition-colors">
                        Leave
                    </a>
                </div>
            @endImpersonating

            <div class="bg-[#032159] px-3 py-2 rounded-full">
                <p class="text-sm font-medium text-gray-200">Welcome {{ $user->name }}</p>
            </div>

            <!-- Notifications -->
            @livewire('layout.notification-dropdown')

        </div>
    </div>
</header>
