<div class="min-h-screen bg-gray-50 p-2">
    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Financial Overview
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage your banking activities</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button variant="primary" href="{{ route('user.deposit.cheque') }}" wire:navigate class="flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="plus" class="w-3 h-3" />
                Add Deposit
            </flux:button>
            <flux:button variant="filled" href="{{ route('user.transfer.international') }}" wire:navigate class="bg-green-600 hover:bg-green-700 flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="arrow-right-left" class="w-3 h-3" />
                Transfer
            </flux:button>
        </div>
    </div>

    <!-- Balance Overview Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
        <!-- Total Balance -->
        <div class="bg-gradient-to-br from-[#04327c] to-[#032a6a] rounded-xl p-4 text-white relative overflow-hidden">
            <div class="absolute top-0 right-0 w-24 h-24 bg-white opacity-10 rounded-full -mr-12 -mt-12"></div>
            <div class="relative">
                <div class="flex items-center justify-between mb-3">
                    <flux:icon name="wallet" class="w-5 h-5 text-blue-200" />
                    <span class="text-xs font-medium bg-[#04327c] bg-opacity-50 px-2 py-0.5 rounded-full">PRIMARY</span>
                </div>
                <p class="text-xs opacity-90 mb-1">Total Balance</p>
                <p class="text-xl font-bold mb-2">{{ $currencySymbol }}{{ number_format($totalBalance, 2) }}</p>
                <div class="flex items-center text-xs">
                    @if($balanceChangeDirection === 'up')
                        <flux:icon name="trending-up" class="w-3 h-3 mr-1 text-green-300" />
                        <span class="text-green-300">+{{ $balanceChangePercentage }}% from last month</span>
                    @else
                        <flux:icon name="trending-down" class="w-3 h-3 mr-1 text-red-300" />
                        <span class="text-red-300">{{ $balanceChangePercentage }}% from last month</span>
                    @endif
                </div>
            </div>
        </div>

        <!-- Available Balance -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="check-circle" class="w-4 h-4 text-green-600" />
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">Available Balance</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ $currencySymbol }}{{ number_format($availableBalance, 2) }}</p>
            <p class="text-xs text-gray-500">Ready for transactions</p>
        </div>

        <!-- Pending Balance -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <div class="flex items-center justify-between mb-3">
                <div class="w-8 h-8 bg-amber-100 rounded-lg flex items-center justify-center">
                    <flux:icon name="clock" class="w-4 h-4 text-amber-600" />
                </div>
            </div>
            <p class="text-gray-600 text-xs mb-1">Pending Balance</p>
            <p class="text-lg font-bold text-gray-900 mb-1">{{ $currencySymbol }}{{ number_format($pendingBalance, 2) }}</p>
            <p class="text-xs text-gray-500">Processing transactions</p>
        </div>
    </div>

    <!-- Right Column Sections - Horizontal Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 mb-6">
        <!-- Your Card (1/3) -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Your Card</h3>
            <div class="bg-gradient-to-br from-slate-800 via-slate-900 to-black rounded-xl p-4 text-white relative overflow-hidden">
                <!-- Card Background Pattern -->
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-5 transform -skew-x-12"></div>

                <div class="relative z-10">
                    <!-- Card Header -->
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-2">
                            <div class="w-6 h-6 bg-gradient-to-r from-yellow-400 to-yellow-500 rounded-md flex items-center justify-center">
                                <flux:icon name="credit-card" class="w-3 h-3 text-yellow-900" />
                            </div>
                            <span class="text-xs font-medium">{{ strtoupper(($virtualCard->card_brand ?? '') . ' DEBIT') }}</span>
                        </div>
                        <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="Bank Logo" class="h-6 w-auto filter brightness-0 invert">
                    </div>

                    <!-- Balance Display -->
                    <div class="mb-4">
                        <p class="text-xs opacity-70 mb-1">Available Balance</p>
                        <p class="text-lg font-bold">
                            @if($virtualCard)
                                {{ \App\Helpers\CurrencyHelper::getSymbol($virtualCard->currency) }}{{ number_format($virtualCard->current_balance, 2) }}
                            @else
                                0.00
                            @endif
                        </p>
                    </div>

                    <!-- Card Details -->
                    <div class="grid grid-cols-2 gap-4 mb-4">
                        <div>
                            <p class="text-xs opacity-60 mb-1">CARDHOLDER NAME</p>
                            <p class="text-xs font-medium">{{ strtoupper($user->name ?? 'JOHN CUSTOMER') }}</p>
                        </div>
                        <div>
                            <p class="text-xs opacity-60 mb-1">EXPIRES</p>
                            <p class="text-xs font-medium">
                                @if($virtualCard)
                                    {{ $virtualCard->expiry_date->format('m/y') }}
                                @else
                                    XX/XX
                                @endif
                            </p>
                        </div>
                    </div>

                    <!-- Card Number -->
                    <div class="flex items-center justify-between">
                        <p class="font-mono text-sm tracking-wider">
                            @if($virtualCard)
                                {{ $virtualCard->masked_card_number }}
                            @else
                                •••• •••• •••• XXXX
                            @endif
                        </p>
                        <div class="flex space-x-1">
                            @if($virtualCard && $virtualCard->card_brand)
                                <img 
                                    src="{{ asset('images/' . strtolower($virtualCard->card_brand) . '.svg') }}" 
                                    alt="{{ ucfirst($virtualCard->card_brand) }}" 
                                    class="w-12 object-contain"
                                />
                            @else
                            <div class="w-6 h-4 bg-red-500 rounded-sm"></div>
                            <div class="w-6 h-4 bg-yellow-400 rounded-sm opacity-80"></div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Account Information (2/3) -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <h3 class="text-sm font-semibold text-gray-900 mb-3">Account Information</h3>
            <div class="space-y-3">
                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                    <span class="text-gray-600 text-xs">Account Name</span>
                    <span class="text-xs font-medium">{{ $primaryAccount->account_name ?? $user->name }}</span>
                </div>
                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                    <span class="text-gray-600 text-xs">Account Type</span>
                    <span class="text-xs font-medium">{{ ucfirst($primaryAccount->account_type ?? 'Savings') }}</span>
                </div>
                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                    <span class="text-gray-600 text-xs">Account Number</span>
                    <span class="font-mono text-xs">{{ $primaryAccount->account_number ?? '****1234' }}</span>
                </div>
                <div class="flex justify-between items-center py-1.5 border-b border-gray-100">
                    <span class="text-gray-600 text-xs">Swift Code</span>
                    <span class="text-xs font-medium">{{ $swiftCode }}</span>
                </div>
                <div class="flex justify-between items-center py-1.5">
                    @if($virtualCard)
                        <span class="text-gray-600 text-xs">Card Actions</span>
                        <div class="flex gap-1">
                            <flux:modal.trigger name="card-funding">
                                <flux:button variant="outline" size="sm" class="px-2 py-1 text-xs">
                                    Fund
                                </flux:button>
                            </flux:modal.trigger>
                            <flux:button variant="danger" size="sm" class="px-2 py-1 text-xs" wire:click="deleteCard">
                                Delete
                            </flux:button>
                        </div>
                    @else
                        <span class="text-gray-600 text-xs">Need a Card?</span>
                        <flux:modal.trigger name="card-application">
                            <flux:button variant="danger" size="sm" class="px-2 py-1 text-xs">Apply Now</flux:button>
                        </flux:modal.trigger>
                    @endif
                </div>
            </div>
        </div>

        <!-- Quick Actions (3/3) -->
        <div class="bg-white rounded-xl p-4 border border-gray-200 shadow-sm">
            <h3 class="text-sm font-semibold text-gray-900 mb-3">Quick Actions</h3>
            <div class="grid grid-cols-2 gap-3">
                <!-- Send Money -->
                <a href="{{ route('user.transfer.international') }}" wire:navigate class="flex flex-col items-center p-3 bg-[#04327c] rounded-xl text-white cursor-pointer hover:bg-[#032a6a] transition-colors">
                    <div class="w-8 h-8 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mb-2">
                        <flux:icon name="arrow-right-left" class="w-4 h-4 text-[#04327c]" />
                    </div>
                    <p class="text-xs font-medium text-center">Send Money</p>
                    <p class="text-xs opacity-80 text-center">Wire Transfer</p>
                </a>

                <!-- Add Deposit -->
                <a href="{{ route('user.deposit.cheque') }}" wire:navigate class="flex flex-col items-center p-3 bg-gray-50 rounded-xl cursor-pointer hover:bg-gray-100 transition-colors">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mb-2">
                        <flux:icon name="plus" class="w-4 h-4 text-green-600" />
                    </div>
                    <p class="text-xs font-medium text-gray-900 text-center">Add Deposit</p>
                    <p class="text-xs text-gray-600 text-center">Fund account</p>
                </a>

                <!-- Pay Bills -->
                <a href="{{ route('user.account.settings') }}" wire:navigate class="flex flex-col items-center p-3 bg-gray-50 rounded-xl cursor-pointer hover:bg-gray-100 transition-colors">
                    <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mb-2">
                        <flux:icon name="credit-card" class="w-4 h-4 text-purple-600" />
                    </div>
                    <p class="text-xs font-medium text-gray-900 text-center">Settings</p>
                    <p class="text-xs text-gray-600 text-center">Account Settings</p>
                </a>

                <!-- Statements -->
                <a href="{{ route('user.account.statements') }}" wire:navigate class="flex flex-col items-center p-3 bg-gray-50 rounded-xl cursor-pointer hover:bg-gray-100 transition-colors">
                    <div class="w-8 h-8 bg-gray-200 rounded-lg flex items-center justify-center mb-2">
                        <flux:icon name="document-text" class="w-4 h-4 text-gray-600" />
                    </div>
                    <p class="text-xs font-medium text-gray-900 text-center">Statements</p>
                    <p class="text-xs text-gray-600 text-center">Reports</p>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="bg-white rounded-2xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
            <h3 class="text-base font-semibold text-gray-900">Recent Transactions</h3>
            <flux:button variant="ghost" size="sm" class="text-blue-600" href="{{ route('user.account.history') }}" wire:navigate>
                View All
                <flux:icon name="arrow-right" class="w-4 h-4 ml-1" />
            </flux:button>
        </div>

        <!-- Desktop Table -->
        <div class="hidden md:block overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($recentTransactions as $transaction)
                        <tr class="hover:bg-gray-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 rounded-xl flex items-center justify-center {{ $this->getTransactionIconColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                                        <flux:icon name="{{ $this->getTransactionIcon($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" class="w-5 h-5 {{ $this->getTransactionIconTextColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" />
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-xs font-medium text-gray-900">
                                            {{ $this->getTransactionDescription($transaction) }}
                                        </div>
                                        <div class="text-xs text-gray-500">
                                            {{ substr($transaction['reference'], 0, 12) }}***
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-xs font-semibold {{ $this->getTransactionAmountColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                                    {{ $this->getTransactionAmountPrefix($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}{{ $transaction['currency_symbol'] }}{{ number_format($transaction['amount'], 2) }}
                                </div>
                                <div class="text-xs text-gray-500">{{ $this->getTransactionTypeLabel($transaction['type']) }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getTransactionStatusColor($transaction['status']) }}">
                                    {{ $this->getTransactionStatusLabel($transaction['status']) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                {{ $transaction['created_at']->format('M j, Y') }}
                                <div class="text-xs">{{ $transaction['created_at']->format('h:i A') }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <flux:modal.trigger name="transaction-details-{{ $transaction['id'] }}">
                                    <flux:button
                                        variant="outline"
                                        size="sm"
                                        class="text-xs"
                                    >
                                        View Details
                                    </flux:button>
                                </flux:modal.trigger>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mb-4" />
                                    <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions yet</h3>
                                    <p class="text-sm text-gray-500">Your recent transactions will appear here</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Mobile Cards -->
        <div class="md:hidden divide-y divide-gray-200">
            @forelse($recentTransactions as $transaction)
                <div class="p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-xl flex items-center justify-center {{ $this->getTransactionIconColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                                <flux:icon name="{{ $this->getTransactionIcon($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" class="w-5 h-5 {{ $this->getTransactionIconTextColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" />
                            </div>
                            <div class="ml-3 flex-1">
                                <p class="text-xs font-medium text-gray-900">
                                    {{ $this->getTransactionDescription($transaction) }}
                                </p>
                                <p class="text-xs text-gray-500">{{ $transaction['created_at']->format('M j, h:i A') }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-xs font-semibold {{ $this->getTransactionAmountColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                                {{ $this->getTransactionAmountPrefix($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}{{ $transaction['currency_symbol'] }}{{ number_format($transaction['amount'], 2) }}
                            </p>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getTransactionStatusColor($transaction['status']) }}">
                                {{ $this->getTransactionStatusLabel($transaction['status']) }}
                            </span>
                        </div>
                    </div>
                </div>
            @empty
                <div class="p-8 text-center">
                    <flux:icon name="document-text" class="w-12 h-12 text-gray-300 mb-4 mx-auto" />
                    <h3 class="text-sm font-medium text-gray-900 mb-1">No transactions yet</h3>
                    <p class="text-sm text-gray-500">Your recent transactions will appear here</p>
                </div>
            @endforelse
        </div>
    </div>

    <!-- Transaction Details Modals -->
    @foreach($recentTransactions as $transaction)
        <flux:modal name="transaction-details-{{ $transaction['id'] }}" class="md:w-128">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">Transaction Details</flux:heading>
                    <flux:text class="mt-2">View complete information about this transaction.</flux:text>
                </div>

                <div class="space-y-4">
                    <!-- Transaction Icon and Type -->
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 rounded-xl flex items-center justify-center {{ $this->getTransactionIconColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                            <flux:icon name="{{ $this->getTransactionIcon($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" class="w-6 h-6 {{ $this->getTransactionIconTextColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}" />
                        </div>
                        <div>
                            <div class="font-medium text-gray-900">{{ $this->getTransactionTypeLabel($transaction['type']) }}</div>
                            <div class="text-sm text-gray-500">{{ $this->getTransactionDescription($transaction) }}</div>
                        </div>
                    </div>

                    <!-- Transaction Details -->
                    <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Transaction ID:</span>
                            <span class="text-sm font-medium text-gray-900">{{ $transaction['transaction_id'] ?? 'N/A' }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Amount:</span>
                            <span class="text-sm font-semibold {{ $this->getTransactionAmountColor($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}">
                                {{ $this->getTransactionAmountPrefix($transaction['type'], $transaction['from_account_id'], $transaction['to_account_id']) }}{{ $transaction['currency_symbol'] }}{{ number_format($transaction['amount'], 2) }}
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Currency:</span>
                            <span class="text-sm font-medium text-gray-900">{{ $transaction['currency'] }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Status:</span>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getTransactionStatusColor($transaction['status']) }}">
                                {{ $this->getTransactionStatusLabel($transaction['status']) }}
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-600">Date:</span>
                            <span class="text-sm font-medium text-gray-900">{{ $transaction['created_at']->format('M d, Y h:i A') }}</span>
                        </div>
                        @if(!empty($transaction['description']))
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Description:</span>
                                <span class="text-sm font-medium text-gray-900">{{ $transaction['description'] }}</span>
                            </div>
                        @endif
                        @if(!empty($transaction['exchange_rate']) && $transaction['exchange_rate'] != 1)
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Exchange Rate:</span>
                                <span class="text-sm font-medium text-gray-900">{{ number_format($transaction['exchange_rate'], 6) }}</span>
                            </div>
                        @endif
                        @if(!empty($transaction['converted_amount']) && $transaction['converted_amount'] != $transaction['amount'])
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Converted Amount:</span>
                                <span class="text-sm font-medium text-gray-900">{{ number_format($transaction['converted_amount'], 2) }}</span>
                            </div>
                        @endif
                    </div>

                    <!-- Account Information -->
                    <div class="bg-blue-50 rounded-lg p-4 space-y-3">
                        <div class="text-sm font-medium text-blue-800">Account Information</div>
                        @if(!empty($transaction['from_account_id']))
                            <div class="flex justify-between">
                                <span class="text-sm text-blue-600">From Account:</span>
                                <span class="text-sm font-medium text-blue-800">{{ $transaction['from_account'] ?? 'N/A' }}</span>
                            </div>
                        @endif
                        @if(!empty($transaction['to_account_id']))
                            <div class="flex justify-between">
                                <span class="text-sm text-blue-600">To Account:</span>
                                <span class="text-sm font-medium text-blue-800">{{ $transaction['to_account'] ?? 'N/A' }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </flux:modal>
    @endforeach

    <!-- Card Application Modal -->
    <flux:modal name="card-application" class="w-96">
        <div class="p-6">
            <flux:heading size="lg" class="mb-4">Apply for Credit Card</flux:heading>
            
            <form wire:submit.prevent="processCardApplication">
                <div class="space-y-4">
                    <flux:field>
                        <flux:label>Card Name</flux:label>
                        <flux:input wire:model="cardName" placeholder="My Debit Card" />
                    </flux:field>
                    
                    <flux:field>
                        <flux:label>Card Type</flux:label>
                        <flux:select wire:model="cardType">
                            <option value="credit">Credit Card</option>
                            <option value="prepaid">Prepaid Card</option>
                        </flux:select>
                    </flux:field>
                    
                    <flux:field>
                        <flux:label>Card Brand</flux:label>
                        <flux:select wire:model="cardBrand">
                            <option value="visa">Visa</option>
                            <option value="mastercard">Mastercard</option>
                            <option value="amex">American Express</option>
                        </flux:select>
                    </flux:field>
                    
                    <flux:field>
                        <flux:label>Currency</flux:label>
                        <flux:select wire:model="cardCurrency">
                            <option value="USD">USD</option>
                            <option value="EUR">EUR</option>
                            <option value="GBP">GBP</option>
                        </flux:select>
                    </flux:field>
                </div>
                
                <div class="flex gap-3 mt-6">
                    <flux:button wire:click="processCardApplication" variant="primary" class="flex-1">
                        Apply for Card
                    </flux:button>
                    <flux:button type="button" variant="outline" x-on:click="$dispatch('modal-close', { name: 'card-application' })">
                        Cancel
                    </flux:button>
                </div>
            </form>
        </div>
    </flux:modal>

    <!-- Card Funding Modal -->
    <flux:modal name="card-funding" class="w-96">
        <div class="p-6">
            <flux:heading size="lg" class="mb-4">Fund Debit Card</flux:heading>
            
            <form wire:submit.prevent="processCardFunding">
                <div class="space-y-4">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="text-sm text-gray-600 mb-2">Current Card Balance</div>
                        <div class="text-lg font-semibold">
                            @if($virtualCard)
                                {{ \App\Helpers\CurrencyHelper::getSymbol($virtualCard->currency) }}{{ number_format($virtualCard->current_balance, 2) }}
                            @else
                                {{ $currencySymbol }}0.00
                            @endif
                        </div>
                    </div>
                    
                    <flux:field>
                        <flux:label>Amount to Fund</flux:label>
                        <flux:input wire:model.live="fundAmount" type="number" step="0.01" placeholder="0.00" />
                    </flux:field>
                    
                    <div class="bg-blue-50 rounded-lg p-4">
                        <div class="text-sm text-blue-600 mb-1">Exchange Rate</div>
                        <div class="text-sm font-medium text-blue-800">
                            @if($exchangeRate && $virtualCard)
                                1 {{ $currency }} = {{ number_format($exchangeRate, 4) }} {{ $virtualCard->currency }}
                            @else
                                Loading...
                            @endif
                        </div>
                    </div>
                    
                    @if($fundAmount && $exchangeRate && $virtualCard)
                        <div class="bg-green-50 rounded-lg p-4">
                            <div class="text-sm text-green-600 mb-1">You will receive</div>
                            <div class="text-lg font-semibold text-green-800">
                                {{ \App\Helpers\CurrencyHelper::getSymbol($virtualCard->currency) }}{{ number_format($fundAmount * $exchangeRate, 2) }}
                            </div>
                        </div>
                    @endif
                </div>
                
                <div class="flex gap-3 mt-6">
                    <flux:button type="submit" variant="primary" class="flex-1">
                        Fund Card
                    </flux:button>
                    <flux:button type="button" variant="outline" x-on:click="$dispatch('modal-close', { name: 'card-funding' })">
                        Cancel
                    </flux:button>
                </div>
            </form>
        </div>
    </flux:modal>
</div>
