<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-8 w-auto">
        </div>
    </div>

    <!-- Reset Password Form -->
    <div class="px-4 py-4">
        <div class="text-left mb-4">
            <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Reset Password
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-1.5">Please enter your new password below</p>
        </div>

        <!-- Session Status -->
        @if(session('status'))
            <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                <div class="flex items-center">
                    <flux:icon name="check-circle" class="w-5 h-5 text-green-600 mr-3" />
                    <p class="text-sm text-green-700">{{ session('status') }}</p>
                </div>
            </div>
        @endif

        <form method="POST" wire:submit="updatePassword" class="space-y-3">
            <!-- Email Address -->
            <div>
                <flux:input
                    wire:model="email"
                    :label="__('Email')"
                    type="email"
                    required
                    autocomplete="email"
                    placeholder="Enter your email address"
                    class="w-full text-sm"
                    icon:leading="envelope"
                />
            </div>

            <!-- Password -->
            <div>
                <flux:input
                    wire:model="password"
                    :label="__('New Password')"
                    type="password"
                    required
                    autocomplete="new-password"
                    placeholder="Enter your new password"
                    viewable
                    class="w-full text-sm"
                    icon:leading="lock-closed"
                />
            </div>

            <!-- Confirm Password -->
            <div>
                <flux:input
                    wire:model="password_confirmation"
                    :label="__('Confirm New Password')"
                    type="password"
                    required
                    autocomplete="new-password"
                    placeholder="Confirm your new password"
                    viewable
                    class="w-full text-sm"
                    icon:leading="lock-closed"
                />
            </div>

            <!-- Password Requirements -->
            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                <div class="flex items-start">
                    <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                    <div>
                        <h4 class="text-xs font-medium text-blue-800 mb-1">
                            Password Requirements
                        </h4>
                        <ul class="text-xs text-blue-700 space-y-0.5">
                            <li>• At least 12 characters long</li>
                            <li>• Mix of uppercase and lowercase letters</li>
                            <li>• Include numbers and special characters</li>
                            <li>• Not commonly used or compromised</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="pt-3">
                <flux:button type="submit" variant="primary" class="w-full py-2 text-sm">
                    {{ __('Reset Password') }}
                </flux:button>
            </div>
        </form>

        <!-- Back to Login -->
        <div class="mt-4 text-center pt-3 border-t border-gray-100">
            <span class="text-xs text-gray-600">{{ __('Remember your password?') }}</span>
            <flux:link :href="route('login')" class="text-[#04327c] hover:text-[#032a6a] font-medium ml-1" wire:navigate>
                {{ __('Log in') }}
            </flux:link>
        </div>
    </div>
</div>
