<div class="min-h-screen bg-gray-50">
    @if(!$profileCompleted)
        <!-- Form Card -->
        <flux:card class="max-w-2xl mx-auto p-4">
            <div class="text-center mb-6">
                <h1 class="text-xl font-bold text-gray-900">Complete Your Profile</h1>
                <p class="text-sm text-gray-600 mt-1">Please fill in your details to complete your banking profile</p>
                
                <!-- Progress Bar -->
                <div class="mt-4">
                    <div class="flex justify-between text-xs text-gray-500 mb-2">
                        <span>Step {{ $currentStep }} of {{ $totalSteps }}</span>
                        <span>{{ $completionPercentage }}% Complete</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full mb-4 h-2">
                        <div class="bg-[#04327c] h-2 rounded-full transition-all duration-300" 
                             style="width: {{ ($currentStep / $totalSteps) * 100 }}%"></div>
                    </div>
                </div>

                <!-- Step 1: Personal Information -->
                @if ($currentStep === 1)
                    <div class="space-y-4">
                        <div class="mb-4">
                            <h2 class="text-sm font-semibold text-gray-900">Personal Information</h2>
                            <p class="text-xs text-gray-600 mt-0.5">Tell us about yourself</p>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field class="mb-4">
                                <flux:label>First Name *</flux:label>
                                <flux:input wire:model="first_name" placeholder="Enter your first name" />
                                <flux:error name="first_name" />
                            </flux:field>

                            <flux:field class="mb-4">
                                <flux:label>Last Name *</flux:label>
                                <flux:input wire:model="last_name" placeholder="Enter your last name" />
                                <flux:error name="last_name" />
                            </flux:field>
                        </div>

                        <flux:field class="mb-4">
                            <flux:label>Middle Name</flux:label>
                            <flux:input wire:model="middle_name" placeholder="Enter your middle name (optional)" />
                            <flux:error name="middle_name" />
                        </flux:field>

                        <flux:field class="mb-4">
                            <flux:label>Date of Birth *</flux:label>
                            <flux:input type="date" wire:model="date_of_birth" />
                            <flux:error name="date_of_birth" />
                        </flux:field>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field class="mb-4">
                                <flux:label>Gender *</flux:label>
                                <flux:select wire:model="gender" placeholder="Select your gender">
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                    <option value="prefer_not_to_say">Prefer not to say</option>
                                </flux:select>
                                <flux:error name="gender" />
                            </flux:field>

                            <flux:field class="mb-4">
                                <flux:label>Marital Status</flux:label>
                                <flux:select wire:model="marital_status" placeholder="Select marital status">
                                    <option value="single">Single</option>
                                    <option value="married">Married</option>
                                    <option value="divorced">Divorced</option>
                                    <option value="widowed">Widowed</option>
                                    <option value="separated">Separated</option>
                                </flux:select>
                                <flux:error name="marital_status" />
                            </flux:field>
                        </div>
                    </div>
                @endif

                <!-- Step 2: Contact Information -->
                @if ($currentStep === 2)
                    <div class="space-y-4">
                        <div class="mb-4">
                            <h2 class="text-sm font-semibold text-gray-900">Contact Information</h2>
                            <p class="text-xs text-gray-600 mt-0.5">Where can we reach you?</p>
                        </div>

                        <flux:field class="mb-4">
                            <flux:label>Address Line 1 *</flux:label>
                            <flux:input wire:model="address_line_1" placeholder="Enter your street address" />
                            <flux:error name="address_line_1" />
                        </flux:field>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field class="mb-4">
                                <flux:label>City *</flux:label>
                                <flux:input wire:model="city" placeholder="Enter your city" />
                                <flux:error name="city" />
                            </flux:field>

                            <flux:field class="mb-4">
                                <flux:label>State/Province</flux:label>
                                <flux:input wire:model="state_province" placeholder="Enter state or province" />
                                <flux:error name="state_province" />
                            </flux:field>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <flux:field class="mb-4">
                                <flux:label>Postal Code *</flux:label>
                                <flux:input wire:model="postal_code" placeholder="Enter postal code" />
                                <flux:error name="postal_code" />
                            </flux:field>

                            <flux:field class="mb-4">
                                <flux:label>Country *</flux:label>
                                <flux:select wire:model="country" placeholder="Select your country">
                                    @foreach ($countries as $countryCode => $countryName)
                                        <option value="{{ $countryName }}">{{ $countryName }}</option>
                                    @endforeach
                                </flux:select>
                                <flux:error name="country" />
                            </flux:field>
                        </div>

                        <flux:field class="mb-4">
                            <flux:label>Phone Number *</flux:label>
                            <flux:input wire:model="phone_number" placeholder="Enter your phone number" />
                            <flux:error name="phone_number" />
                        </flux:field>
                    </div>
                @endif

                <!-- Step 3: Employment Information -->
                @if ($currentStep === 3)
                    <div class="space-y-4">
                        <div class="mb-4">
                            <h2 class="text-sm font-semibold text-gray-900">Employment Information</h2>
                            <p class="text-xs text-gray-600 mt-0.5">Help us understand your financial situation</p>
                        </div>

                        <flux:field class="mb-4">
                            <flux:label>Occupation *</flux:label>
                            <flux:input wire:model="occupation" placeholder="Enter your occupation" />
                            <flux:error name="occupation" />
                        </flux:field>

                        <flux:field class="mb-4">
                            <flux:label>Annual Income</flux:label>
                            <flux:input type="number" step="0.01" wire:model="annual_income" placeholder="Enter your annual income (optional)" />
                            <flux:error name="annual_income" />
                        </flux:field>
                    </div>
                @endif

                <!-- Step 4: Emergency Contact -->
                @if ($currentStep === 4)
                    <div class="space-y-4">
                        <div class="mb-4">
                            <h2 class="text-sm font-semibold text-gray-900">Emergency Contact</h2>
                            <p class="text-xs text-gray-600 mt-0.5">Someone we can contact in case of emergency</p>
                        </div>

                        <flux:field class="mb-4">
                            <flux:label>Emergency Contact Name</flux:label>
                            <flux:input wire:model="emergency_contact_name" placeholder="Enter emergency contact name" />
                            <flux:error name="emergency_contact_name" />
                        </flux:field>

                        <flux:field class="mb-4">
                            <flux:label>Emergency Contact Phone</flux:label>
                            <flux:input wire:model="emergency_contact_phone" placeholder="Enter emergency contact phone" />
                            <flux:error name="emergency_contact_phone" />
                        </flux:field>

                        <flux:field class="mb-4">
                            <flux:label>Relationship</flux:label>
                            <flux:input wire:model="emergency_contact_relationship" placeholder="e.g., Spouse, Parent, Sibling" />
                            <flux:error name="emergency_contact_relationship" />
                        </flux:field>
                    </div>
                @endif

                <!-- Navigation Buttons -->
                <div class="flex justify-between items-center mt-6 pt-4 border-t border-gray-200">
                    <div>
                        @if ($currentStep > 1)
                            <flux:button variant="outline" wire:click="previousStep" type="button" class="px-2.5 py-1 text-xs">
                                <div class="flex items-center">
                                    <flux:icon.arrow-left class="w-3 h-3 mr-1" />
                                    Previous
                                </div>
                            </flux:button>
                        @endif
                    </div>

                    <div class="flex space-x-2">
                        @if ($currentStep < $totalSteps)
                            <flux:button wire:click="nextStep" type="button" class="px-2.5 py-1 text-xs">
                                <div class="flex items-center">
                                    Next
                                    <flux:icon.arrow-right class="w-3 h-3 ml-1" />
                                </div>
                            </flux:button>
                        @else
                            <flux:button icon="check" wire:click="completeProfile" class="px-2.5 py-1 text-xs">
                                    Complete Profile
                            </flux:button>
                        @endif
                    </div>
                </div>
            </div>
        </flux:card>
    @else
        <!-- Success Section -->
        <div class="max-w-2xl mx-auto">
            <flux:card class="text-center py-8">
                <div class="mx-auto h-16 w-16 bg-green-100 rounded-full flex items-center justify-center mb-4">
                    <flux:icon name="check-circle" class="h-8 w-8 text-green-600" />
                </div>
                <h3 class="text-lg font-bold text-gray-900 mb-2">
                    Profile Completed Successfully!
                </h3>
                <p class="text-sm text-gray-600 mb-6">
                    Your profile has been completed. Now let's set up your banking account to get started.
                </p>
                <flux:button wire:click="proceedToAccountCreation" class="px-6 py-2">
                    <div class="flex items-center">
                        Create Banking Account
                        <flux:icon.arrow-right class="w-4 h-4 ml-2" />
                    </div>
                </flux:button>
            </flux:card>
        </div>
    @endif
</div>