<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
        </div>
    </div>
    <!-- Login Form -->
    <div class="px-4 py-4">
    @if(!$showTwoFactor)
        <div class="text-left mb-4">
            <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Login Form
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-1.5">Access your banking account</p>
        </div>
        @endif
        @if($isLockedOut)
            <!-- Account Lockout Warning -->
            <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-4">
                <div class="flex items-center">
                    <flux:icon name="exclamation-triangle" class="w-5 h-5 text-red-600 mr-3" />
                    <div>
                        <h4 class="text-sm font-medium text-red-800">Account Temporarily Locked</h4>
                        <p class="text-sm text-red-700 mt-1">Too many failed attempts. Please try again in {{ ceil($lockoutTime / 60) }} minutes.</p>
                    </div>
                </div>
            </div>
        @endif

        @if(!$showTwoFactor)
            <form wire:submit="authenticate" class="space-y-3">
                <!-- Username/Email -->
                <div>
                    <flux:input
                        wire:model="login"
                        :label="__('Username')"
                        type="text"
                        required
                        autofocus
                        autocomplete="username"
                        placeholder="Enter your username or email"
                        class="w-full text-sm"
                        icon:leading="user"
                    />
                    @error('login')
                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div class="relative">
                    <flux:input
                        wire:model="password"
                        :label="__('Password')"
                        type="password"
                        required
                        autocomplete="current-password"
                        placeholder="Enter your password"
                        viewable
                        class="w-full text-sm"
                        icon:leading="finger-print"
                    />
                    @error('password')
                        <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                    @enderror

                    @if (Route::has('password.request'))
                        <flux:link class="absolute end-0 top-0 text-xs text-[#04327c] hover:text-[#032a6a]" :href="route('password.request')" wire:navigate>
                            {{ __('Forgot Password?') }}
                        </flux:link>
                    @endif
                </div>

                <!-- Remember Me -->
                <div class="flex items-center justify-between">
                    <flux:checkbox wire:model="remember" :label="__('Remember me')" class="text-sm" />
                </div>

                <!-- Action Buttons -->
                <div class="flex space-x-2 pt-3">
                    <flux:button variant="primary" wire:click="login" type="submit" class="flex-1 cursor-pointer px-4 py-2 text-sm" :disabled="$isLockedOut" wire:loading.attr="disabled">
                        {{ __('Login') }}
                    </flux:button>
                    @if (Route::has('register'))
                        <flux:link :href="route('register')" class="flex-1" wire:navigate>
                            <flux:button variant="filled" type="button" class="w-full cursor-pointer px-4 py-2 text-sm">
                                {{ __('Register') }}
                            </flux:button>
                        </flux:link>
                    @endif
                </div>
            </form>

            <!-- Passkey Authentication Option -->
            <div class="mt-4 pt-3 border-t border-gray-100">
                <div class="text-center">
                    <p class="text-xs text-gray-600 mb-2">Or continue with</p>
                    <x-authenticate-passkey>
                        <flux:button variant="filled" class="w-full cursor-pointer text-sm py-2">
                            <flux:icon name="key" class="w-3 h-3 mr-1" />
                            Authenticate with Passkey
                        </flux:button>
                    </x-authenticate-passkey>
                </div>
            </div>
        @else
            <!-- Two-Factor Authentication Form -->
            <div class="space-y-3">
                <div class="text-left">
                    <h3 class="text-base font-bold text-gray-900 mb-0.5 relative">
                        Two-Factor Authentication
                        <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
                    </h3>
                    <p class="text-xs text-gray-600 mt-1.5">
                        Please enter the {{ $twoFactorMethod === 'totp' ? 'authentication code' : 'verification code' }} from your {{ $twoFactorMethod === 'totp' ? 'authenticator app' : 'email' }}.
                    </p>
                    
                    <!-- Session Timeout Warning -->
                    <div class="mt-2 p-2 bg-blue-50 border border-blue-200 rounded text-xs text-blue-700">
                        <flux:icon name="clock" class="w-3 h-3 inline mr-1" />
                        Session expires in 10 minutes. Please complete authentication soon.
                    </div>
                </div>

                <form wire:submit="verifyTwoFactor" class="space-y-3">
                    <div>
                        <flux:input
                            wire:model="twoFactorCode"
                            :label="__('Authentication Code')"
                            type="text"
                            required
                            autofocus
                            maxlength="6"
                            placeholder="Enter 6-digit code"
                            class="w-full text-sm"
                            icon:leading="shield-check"
                        />
                        @error('twoFactorCode')
                            <p class="text-xs text-red-600 mt-0.5">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex space-x-2">
                        <flux:button type="submit" variant="primary" class="flex-1 px-4 py-2 text-sm" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="verifyTwoFactor">Verify & Sign in</span>
                            <span wire:loading wire:target="verifyTwoFactor">Verifying...</span>
                        </flux:button>
                        <flux:button variant="ghost" type="button" wire:click="resetLogin" class="px-4 py-2 text-sm">
                            {{ __('Cancel') }}
                        </flux:button>
                    </div>
                </form>
                
                <!-- Additional Help -->
                <div class="text-center space-y-2">
                    @if($twoFactorMethod === 'email')
                        <p class="text-xs text-gray-500">
                            Didn't receive the code? 
                            <button wire:click="resendEmailCode" class="text-[#04327c] hover:text-[#032a6a] underline">
                                Resend code
                            </button>
                        </p>
                    @endif
                    <p class="text-xs text-gray-500">
                        Having trouble? 
                        <button wire:click="resetLogin" class="text-[#04327c] hover:text-[#032a6a] underline">
                            Try logging in again
                        </button>
                    </p>
                </div>
            </div>
        @endif

        <!-- Success Message Display -->
        @if (session()->has('message'))
            <div class="mt-4">
                <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                    <div class="flex items-center">
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600 mr-2" />
                        <p class="text-sm text-green-700">{{ session('message') }}</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Error Display -->
        @if ($errors->any())
            <div class="mt-4">
                @foreach ($errors->all() as $error)
                    <div class="bg-red-50 border border-red-200 rounded-lg p-3 mb-2">
                        <div class="flex items-center">
                            <flux:icon name="exclamation-circle" class="w-5 h-5 text-red-600 mr-2" />
                            <p class="text-sm text-red-700">{{ $error }}</p>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>

