<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
        </div>
    </div>

    <!-- Forgot Password Form -->
    <div class="px-4 py-4">
        <div class="text-left mb-4">
            <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Forgot Password
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-1.5">
                @if($codeSent)
                    Enter the 6-digit reset code sent to your email address.
                @else
                    Enter your email to receive a password reset code
                @endif
            </p>
        </div>

        @if(!$codeSent)
            <!-- Email Form -->
            <form wire:submit="sendPasswordResetCode" class="space-y-3">
                <!-- Email Address -->
                <div>
                    <flux:input
                        wire:model="email"
                        :label="__('Email Address')"
                        type="email"
                        required
                        autofocus
                        placeholder="Enter your email address"
                        class="w-full text-sm"
                        icon:leading="envelope"
                    />
                    <flux:error name="email" />
                </div>

                <!-- Submit Button -->
                <flux:button variant="primary" type="submit" class="w-full py-2 text-sm">
                    <flux:icon name="envelope" class="w-4 h-4 mr-2" />
                    Send Reset Code
                </flux:button>
            </form>

            <!-- Security Information -->
            <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                <div class="flex items-start">
                    <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                    <div>
                        <h4 class="text-xs font-medium text-blue-800">
                            Security Notice
                        </h4>
                        <p class="text-xs text-blue-700 mt-0.5">
                            For security reasons, we limit password reset requests. If you don't receive an email within a few minutes, please check your spam folder or contact support.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Back to Login -->
            <div class="mt-4 text-center">
                <span class="text-xs text-gray-600">{{ __('Remember your password?') }}</span>
                <flux:link :href="route('login')" class="text-[#04327c] hover:text-[#032a6a] font-medium ml-1" wire:navigate>
                    {{ __('Log in') }}
                </flux:link>
            </div>
        @else
            <!-- Verification Code Form -->
            <form wire:submit="verifyResetCode" class="space-y-4">
                <div>
                    <flux:input
                        wire:model="resetCode"
                        label="Reset Code"
                        type="text"
                        maxlength="6"
                        placeholder="000000"
                        class="text-center text-lg tracking-widest"
                        :disabled="$isLoading"
                        autofocus
                    />
                    <flux:error name="resetCode" />
                </div>

                <!-- Attempts Counter -->
                @if($attempts > 0)
                    <div class="text-center">
                        <p class="text-xs text-amber-600">
                            Failed attempts: {{ $attempts }}/{{ $maxAttempts }}
                        </p>
                    </div>
                @endif

                <!-- Verify Button -->
                <flux:button 
                    type="submit" 
                    variant="primary" 
                    class="w-full py-2 text-sm"
                    :disabled="$isLoading || $attempts >= $maxAttempts"
                >
                    @if($isLoading)
                        <flux:icon name="arrow-path" class="w-4 h-4 mr-2 animate-spin" />
                        Verifying...
                    @else
                        Verify Code
                    @endif
                </flux:button>
            </form>

            <!-- Resend Code -->
            <div class="mt-4 text-center">
                <p class="text-xs text-gray-600 mb-2">Didn't receive the code?</p>
                <flux:button 
                    wire:click="resendCode" 
                    variant="outline" 
                    size="sm"
                    :disabled="$resendCooldown > 0"
                    class="text-xs"
                >
                    @if($resendCooldown > 0)
                        Resend in {{ $resendCooldown }}s
                    @else
                        Resend Code
                    @endif
                </flux:button>
            </div>

            <!-- Back to Email -->
            <div class="mt-4 text-center">
                <flux:button 
                    wire:click="resetForm" 
                    variant="outline" 
                    size="sm"
                    class="text-xs"
                >
                    Use Different Email
                </flux:button>
            </div>

            <!-- Security Information -->
            <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                <div class="flex items-start">
                    <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                    <div>
                        <h4 class="text-xs font-medium text-blue-800">
                            Didn't receive the code?
                        </h4>
                        <ul class="text-xs text-blue-700 space-y-0.5">
                            <li>• Check your spam or junk folder</li>
                            <li>• Make sure the email address is correct</li>
                            <li>• Wait a few minutes for delivery</li>
                            <li>• Click "Resend Code" above</li>
                        </ul>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('start-resend-countdown', () => {
        let cooldown = 60;
        const interval = setInterval(() => {
            cooldown--;
            @this.set('resendCooldown', cooldown);
            
            if (cooldown <= 0) {
                clearInterval(interval);
            }
        }, 1000);
    });
});
</script>
