<div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
    <!-- Logo -->
    <div class="px-4 py-3 text-center border-b border-gray-100">
        <div class="flex items-center justify-center">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-12 w-auto">
        </div>
    </div>

    <!-- Confirm Password Form -->
    <div class="px-4 py-4">
        <div class="text-left mb-4">
            <h2 class="text-base font-bold text-gray-900 mb-0.5 relative">
                Confirm Password
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h2>
            <p class="text-xs text-gray-600 mt-1.5">This is a secure area of the application. Please confirm your password before continuing.</p>
        </div>

        <!-- Security Notice -->
        <div class="mb-6 p-4 bg-amber-50 border border-amber-200 rounded-lg">
            <div class="flex items-start">
                <flux:icon name="exclamation-triangle" class="w-5 h-5 text-amber-600 mt-0.5 mr-3 flex-shrink-0" />
                <div>
                    <h4 class="text-sm font-medium text-amber-800">
                        Security Required
                    </h4>
                    <p class="text-sm text-amber-700 mt-1">
                        You're accessing a sensitive area. Please confirm your identity by entering your password.
                    </p>
                </div>
            </div>
        </div>

        <form method="POST" wire:submit="verifyPassword" class="space-y-3">
            <!-- Password -->
            <div>
                <flux:input
                    wire:model="password"
                    :label="__('Password')"
                    type="password"
                    required
                    autocomplete="current-password"
                    placeholder="Enter your password"
                    viewable
                    class="w-full text-sm"
                    icon:leading="lock-closed"
                />
            </div>

            <!-- Submit Button -->
            <div class="pt-3">
                <flux:button variant="primary" type="submit" class="w-full py-2 text-sm">
                    {{ __('Confirm Password') }}
                </flux:button>
            </div>
        </form>

        <!-- Help Text -->
        <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
            <div class="flex items-start">
                <flux:icon name="information-circle" class="w-4 h-4 text-blue-600 mt-0.5 mr-2 flex-shrink-0" />
                <div>
                    <h4 class="text-xs font-medium text-blue-800">
                        Why is this required?
                    </h4>
                    <p class="text-xs text-blue-700 mt-0.5">
                        This additional security step helps protect your account when accessing sensitive information or performing important actions.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
