<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Error') - {{ \App\Helpers\SettingsHelper::bankName() }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Favicon -->
    <link rel="icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}" sizes="any">
    <link rel="icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}" type="image/svg+xml">
    <link rel="apple-touch-icon" href="{{ \App\Helpers\SettingsHelper::bankFavicon() }}">
</head>
<body class="font-sans antialiased bg-gray-50">
    <div class="min-h-screen flex flex-col">

        <!-- Main Content -->
        <div class="flex-1 flex items-center justify-center px-4 sm:px-6 lg:px-8 py-12">
            <div class="max-w-2xl w-full">
                @yield('content')
            </div>
        </div>

    </div>
</body>
</html>
