@extends('errors.layout')

@section('title', 'Service Unavailable')

@section('content')
<div class="space-y-6">
    <!-- Error Header -->
    <div class="text-center">
        <div class="mx-auto h-20 w-20 bg-purple-100 rounded-full flex items-center justify-center mb-4">
            <svg class="h-10 w-10 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
            </svg>
        </div>
        <h1 class="text-5xl font-bold text-gray-900 mb-2">503</h1>
        <h2 class="text-xl font-semibold text-gray-800 mb-2">Service Unavailable</h2>
        <p class="text-gray-600">We're performing scheduled maintenance to improve our services.</p>
    </div>

    <!-- Maintenance Info Card -->
    <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-blue-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">🔧</span>
            Scheduled Maintenance
        </h3>
        <div class="space-y-3 text-sm text-blue-700">
            <p>• We're working hard to bring you an improved experience</p>
            <p>• Expected completion: <span class="font-semibold">Within 30 minutes</span></p>
            <p>• Your data and account remain safe and secure</p>
        </div>
    </div>

    <!-- Action Card -->
    <div class="bg-white border border-gray-200 rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-800 mb-4 flex items-center">
            <span class="bg-blue-100 text-blue-600 rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold mr-2">🔄</span>
            What can you do?
        </h3>
        <div class="space-y-4">
            <button onclick="window.location.reload()" 
                    class="w-full inline-flex items-center justify-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                Check Again
            </button>
        </div>
    </div>

    <!-- Status Updates -->
    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
        <div class="flex items-start">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-gray-800">Stay Updated</h3>
                <div class="mt-2 text-sm text-gray-700">
                    <p>Get notified when our services are back online.</p>
                    <div class="mt-3 flex space-x-4">
                        <a href="#" class="font-medium text-blue-600 hover:text-blue-500 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
                                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                            </svg>
                            Email Updates
                        </a>
                        <a href="#" class="font-medium text-blue-600 hover:text-blue-500 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                            </svg>
                            Status Page
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
