@component('mail::message')
# Two-Factor Authentication

Hello {{ $user->name }},

You are attempting to complete a **{{ ucfirst($transfer['type']) }}** transfer for **{{ $transfer['currency'] }} {{ number_format($transfer['amount'], 2) }}**.

Please use the following verification code to complete your transaction:

@component('mail::panel')
## Your 2FA Verification Code

<div style="text-align: center; margin: 30px 0;">
    <div style="background: #f1f5f9; border: 2px dashed #04327c; border-radius: 12px; padding: 30px; margin: 20px 0;">
        <p style="margin: 0 0 15px; font-weight: 600; color: #374151;">Your 2FA code is:</p>
        <div style="font-size: 36px; font-weight: bold; color: #04327c; letter-spacing: 8px; font-family: 'Courier New', monospace;">{{ $code }}</div>
        <p style="margin: 15px 0 0; font-size: 14px; color: #6b7280;">Enter this code to complete your transaction</p>
    </div>
</div>
@endcomponent

## ⚠️ Security Notice:

- This code expires in **5 minutes**
- Never share this code with anyone
- {{ $bankName }} will never ask for this code via phone or email
- If you didn't request this transaction, please contact support immediately

## 📋 Transaction Details:

- **Type:** {{ ucfirst($transfer['type']) }} Transfer
- **Amount:** {{ $transfer['currency'] }} {{ number_format($transfer['amount'], 2) }}
- **Recipient:** {{ $transfer['recipient_name'] ?? 'N/A' }}

If you did not request this code, please contact our support team immediately.

Thanks,<br>
{{ $bankName }} Team
@endcomponent
