<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>New Contact Form Submission</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #1e3a8a;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 5px 5px 0 0;
        }
        .content {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 0 0 5px 5px;
        }
        .field {
            margin-bottom: 15px;
        }
        .label {
            font-weight: bold;
            color: #1e3a8a;
        }
        .value {
            margin-top: 5px;
            padding: 10px;
            background-color: white;
            border-radius: 3px;
            border-left: 3px solid #1e3a8a;
        }
        .message-content {
            white-space: pre-wrap;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>New Contact Form Submission</h1>
        <p>{{ $bank_name }}</p>
    </div>
    
    <div class="content">
        <div class="field">
            <div class="label">Name:</div>
            <div class="value">{{ $first_name }} {{ $last_name }}</div>
        </div>
        
        <div class="field">
            <div class="label">Email:</div>
            <div class="value">{{ $email }}</div>
        </div>
        
        @if($phone)
        <div class="field">
            <div class="label">Phone:</div>
            <div class="value">{{ $phone }}</div>
        </div>
        @endif
        
        <div class="field">
            <div class="label">Subject:</div>
            <div class="value">{{ $subject }}</div>
        </div>
        
        <div class="field">
            <div class="label">Message:</div>
            <div class="value message-content">{{ $message }}</div>
        </div>
        
        <div class="field">
            <div class="label">Submitted:</div>
            <div class="value">{{ now()->format('F d, Y \a\t g:i A') }}</div>
        </div>
    </div>
</body>
</html>
