@php
    $user = Auth::user();
    $currentRoute = request()->route()->getName() ?? '';
    
    function isActive($route, $currentRoute) {
        return $currentRoute === $route || str_starts_with($currentRoute, $route . '.');
    }
@endphp

<aside id="sidebar" class="bg-white flex-shrink-0 transition-all duration-300 w-64 overflow-hidden fixed left-0 top-0 h-[100dvh] flex flex-col z-[60] md:translate-x-0 -translate-x-full">
    <!-- Sidebar Header -->
    <div class="md:bg-[#1e3a8a] p-4 border-b border-gray-200">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-2">
                <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }} Logo" class="h-[48px] w-auto md:filter md:brightness-0 md:invert">
            </div>
            <!-- Mobile Close Button -->
            <button id="closeMobileSidebar" type="button" class="md:hidden p-1 text-gray-500 hover:text-gray-700 hover:bg-gray-100 rounded-md">
                <flux:icon name="x-mark" class="w-5 h-5" />
            </button>
        </div>
    </div>

    <!-- User Profile Section -->
    <div class="p-4 border-b border-r border-gray-200">
        <div class="flex items-center space-x-3">
            @if($user->profile && $user->profile->profile_image_url)
                <img src="{{ $user->profile->profile_image_url }}" 
                     alt="{{ $user->name }}" 
                     class="w-10 h-10 rounded-full object-cover border-2 border-gray-200">
            @else
                <div class="w-10 h-10 bg-[#04327c] rounded-full flex items-center justify-center">
                    <span class="text-white font-semibold text-sm">{{ substr($user->name, 0, 2) }}</span>
                </div>
            @endif
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium text-gray-900 truncate">{{ $user->name }}</p>
                <p class="text-xs text-gray-500 truncate">{{ $user->customer_id ?? 'N/A' }}</p>
            </div>
        </div>
        
        <div class="mt-3 text-xs text-gray-500">
            <div>{{ now()->format('d M Y') }}</div>
            <div>{{ now()->format('h:i A T') }}</div>
        </div>
    </div>

    <!-- Navigation Menu -->
    <nav class="flex-1 overflow-y-auto py-4 border-r border-gray-200 scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-gray-100">
        <!-- Dashboard -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Dashboard</h3>
            <a href="{{ route('dashboard') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('dashboard', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="home" class="w-5 h-5 mr-3 {{ isActive('dashboard', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Overview
            </a>
        </div>

        <!-- Account Management -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Account</h3>
            <a href="{{ route('user.account.history') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.account.history', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="clock" class="w-5 h-5 mr-3 {{ isActive('user.account.history', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Account History
            </a>
            <a href="{{ route('user.account.statements') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.account.statements', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="document-text" class="w-5 h-5 mr-3 {{ isActive('user.account.statements', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Statements
            </a>
        </div>

        <!-- Fund Transfer -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Fund Transfer</h3>
            <a href="{{ route('user.transfer.local') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.transfer.local', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="paper-airplane" class="w-5 h-5 mr-3 {{ isActive('user.transfer.local', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Local Transfer
            </a>
            <a href="{{ route('user.transfer.international') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.transfer.international', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="globe-alt" class="w-5 h-5 mr-3 {{ isActive('user.transfer.international', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                International Transfer
            </a>
            <a href="{{ route('user.transfer.inter-account') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.transfer.inter-account', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="arrows-right-left" class="w-5 h-5 mr-3 {{ isActive('user.transfer.inter-account', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Inter-Account Transfer
            </a>
        </div>

        <!-- Deposits -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Deposits</h3>
            <a href="{{ route('user.deposit.cheque') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.deposit.cheque', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="document" class="w-5 h-5 mr-3 {{ isActive('user.deposit.cheque', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Cheque Deposit
            </a>
            <a href="{{ route('user.deposit.history') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.deposit.history', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="clock" class="w-5 h-5 mr-3 {{ isActive('user.deposit.history', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Deposit History
            </a>
        </div>

        <!-- User Management -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">User</h3>
            <a href="{{ route('user.beneficiaries') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.beneficiaries', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="users" class="w-5 h-5 mr-3 {{ isActive('user.beneficiaries', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Beneficiaries
            </a>
            <a href="{{ route('user.profile') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.profile', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="user" class="w-5 h-5 mr-3 {{ isActive('user.profile', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Profile Settings
            </a>
            @if(\App\Helpers\SettingsHelper::isKycRequired())
                <a href="{{ route('user.kyc-verification') }}" wire:navigate
                   class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.kyc-verification', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                    <flux:icon name="shield-check" class="w-5 h-5 mr-3 {{ isActive('user.kyc-verification', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                    KYC Verification
                </a>
            @endif
        </div>

        <!-- Security & Settings -->
        <div class="px-3 mb-4">
            <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Security</h3>
            <a href="{{ route('user.preferences') }}" wire:navigate
               class="sidebar-link flex items-center px-3 py-2 text-sm font-medium rounded-md transition-colors {{ isActive('user.preferences', $currentRoute) ? 'bg-[#04327c] text-white' : 'text-gray-700 hover:bg-gray-100' }}">
                <flux:icon name="lock-closed" class="w-5 h-5 mr-3 {{ isActive('user.preferences', $currentRoute) ? 'text-white' : 'text-[#04327c]' }}" />
                Security Settings
            </a>
        </div>
    </nav>

    <!-- Logout Section -->
    <div class="mt-auto p-4 border-t border-r border-gray-200">
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button type="submit" 
                    class="flex items-center w-full px-3 py-2 text-sm font-medium text-red-600 rounded-md hover:bg-red-50 transition-colors">
                <flux:icon name="arrow-right-start-on-rectangle" class="w-5 h-5 mr-3 text-red-600" />
                Logout
            </button>
        </form>
    </div>
</aside>

<!-- Mobile Overlay -->
<div id="mobileOverlay" class="fixed inset-0 bg-gray-900/20 z-40 md:hidden hidden"></div>
