<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        @include('partials.head')
    </head>
    <body class="min-h-screen bg-gradient-to-br from-[#04327c] via-[#032a6a] to-[#04327c] antialiased relative">
        <!-- Preloader -->
        <x-preloader />
        
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-40">
            <div class="w-full h-full" style="background-image: url('/images/bg-pattern.png'); background-repeat: repeat;"></div>
        </div>
        <div class="relative z-10 flex min-h-screen flex-col items-center justify-center py-4 md:py-6 px-6 md:px-10 overflow-y-auto">
            <div class="w-full {{ request()->routeIs('register') ? 'max-w-5xl' : 'max-w-md' }}">
                {{ $slot }}
            </div>
        </div>
        
        <!-- LiveChat Component -->
        <x-live-chat />
        
        @livewireScripts
        @fluxScripts
    </body>
</html>