@php
    $counts = \App\Services\SidebarCountService::getCachedCounts();
@endphp

<!-- Mobile Sidebar -->
<div id="mobile-sidebar" class="fixed inset-y-0 left-0 z-50 w-64 bg-white overflow-y-auto scrollbar-hide shadow-lg transform -translate-x-full transition-transform duration-300 ease-in-out md:hidden hidden">
    <!-- Mobile Sidebar Header -->
    <div class="flex items-center justify-between h-16 px-6 border-b border-gray-200">
        <div class="flex items-center space-x-3">
            <img src="{{ \App\Helpers\SettingsHelper::bankLogo() }}" alt="{{ \App\Helpers\SettingsHelper::bankName() }}" class="w-[150px]">
        </div>
        <button onclick="toggleMobileSidebar()" class="p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100">
            <flux:icon name="x-mark" class="w-6 h-6" />
        </button>
    </div>
    
    <!-- Mobile Navigation -->
    <nav class="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
        <!-- Dashboard -->
        <a href="{{ route('admin.dashboard') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.dashboard') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="squares-2x2" class="w-5 h-5 mr-3" />
            Dashboard
        </a>

        <!-- Users -->
        <a href="{{ route('admin.users.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.users.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="users" class="w-5 h-5 mr-3" />
                Users
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800" title="Pending Verification">
                {{ number_format($counts['users']) }}
            </span>
        </a>

        <!-- Accounts -->
        <a href="{{ route('admin.accounts.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.accounts.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="credit-card" class="w-5 h-5 mr-3" />
                Accounts
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800" title="Pending Accounts">
                {{ number_format($counts['accounts']) }}
            </span>
        </a>

        <!-- Transactions -->
        <a href="{{ route('admin.transactions.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.transactions.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="arrow-right-left" class="w-5 h-5 mr-3" />
                Transactions
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800" title="Pending Transactions">
                {{ number_format($counts['transactions']) }}
            </span>
        </a>

        <!-- Transfers -->
        <a href="{{ route('admin.transfers.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.transfers.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="arrow-up-down" class="w-5 h-5 mr-3" />
                Transfers
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800" title="Pending Transfers">
                {{ number_format($counts['transfers']) }}
            </span>
        </a>

        <!-- Credit/Debit -->
        <a href="{{ route('admin.credit-debit.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.credit-debit.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="currency-dollar" class="w-5 h-5 mr-3" />
            Credit/Debit
        </a>
         <!-- Transaction Generator -->
         <a href="{{ route('admin.transaction-generator.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.transaction-generator.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
                <flux:icon name="plus-circle" class="w-5 h-5 mr-3" />
                Transaction Generator
            </a>
        <!-- Deposits -->
        <a href="{{ route('admin.deposits.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.deposits.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="arrow-down" class="w-5 h-5 mr-3" />
                Deposits
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800" title="Pending Deposits">
                {{ number_format($counts['deposits']) }}
            </span>
        </a>
        <!-- Virtual Cards -->
        <a href="{{ route('admin.virtual-cards.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.virtual-cards.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="credit-card" class="w-5 h-5 mr-3" />
                Virtual Cards
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800" title="Active Virtual Cards">
                {{ number_format($counts['virtual_cards']) }}
            </span>
        </a>
        <!-- KYC -->
        <a href="{{ route('admin.kyc.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.kyc.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="identification" class="w-5 h-5 mr-3" />
                KYC Verification
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800" title="Pending KYC">
                {{ number_format($counts['kyc']) }}
            </span>
        </a>
        
        <!-- Compliance -->
        <a href="{{ route('admin.compliance.index') }}" class="flex items-center justify-between px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.compliance.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <div class="flex items-center">
                <flux:icon name="exclamation-triangle" class="w-5 h-5 mr-3" />
                Compliance
            </div>
            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800" title="Pending Compliance">
                {{ number_format($counts['compliance']) }}
            </span>
        </a>

        <!-- Reports -->
        <a href="{{ route('admin.reports.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.reports.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="document-text" class="w-5 h-5 mr-3" />
            Reports
        </a>

        <!-- Analytics -->
        <a href="{{ route('admin.analytics.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.analytics.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="chart-line" class="w-5 h-5 mr-3" />
            Analytics
        </a>

        <!-- Settings -->
        <a href="{{ route('admin.settings.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.settings.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="cog-6-tooth" class="w-5 h-5 mr-3" />
            Settings
        </a>

        @can('manage-roles')
        <!-- Roles & Permissions (Super Admin Only) -->
      <!--  <a href="{{ route('admin.roles.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.roles.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="shield-check" class="w-5 h-5 mr-3" />
            Roles & Permissions
        </a> -->

        <!-- System Logs (Super Admin Only) -->
        <a href="{{ route('admin.logs.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.logs.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
            <flux:icon name="document-text" class="w-5 h-5 mr-3" />
            System Logs
        </a>
         <!-- Transaction Generator (Super Admin Only) -->
            <a href="{{ route('admin.transaction-generator.index') }}" class="flex items-center px-3 py-2 text-sm font-medium rounded-lg {{ request()->routeIs('admin.transaction-generator.*') ? 'bg-blue-50 text-[#04327c] border-l-4 border-[#04327c]' : 'text-gray-700 hover:bg-gray-50' }}">
                <flux:icon name="plus-circle" class="w-5 h-5 mr-3" />
                Transaction Generator
            </a>
        @endcan
    </nav>
</div>

<script>
    function toggleMobileSidebar() {
        const sidebar = document.getElementById('mobile-sidebar');
        const overlay = document.getElementById('mobile-overlay');
        
        if (sidebar.classList.contains('hidden')) {
            sidebar.classList.remove('hidden');
            sidebar.classList.remove('-translate-x-full');
            sidebar.classList.add('translate-x-0');
            if (overlay) overlay.classList.remove('hidden');
        } else {
            sidebar.classList.add('hidden');
            sidebar.classList.add('-translate-x-full');
            sidebar.classList.remove('translate-x-0');
            if (overlay) overlay.classList.add('hidden');
        }
    }

    // Close mobile sidebar when clicking outside
    document.addEventListener('click', function(event) {
        const sidebar = document.getElementById('mobile-sidebar');
        const overlay = document.getElementById('mobile-overlay');
        const button = event.target.closest('button');
        
        // Close mobile sidebar
        if (!sidebar.contains(event.target) && !event.target.closest('[onclick="toggleMobileSidebar()"]')) {
            sidebar.classList.add('hidden');
            sidebar.classList.add('-translate-x-full');
            sidebar.classList.remove('translate-x-0');
            if (overlay) overlay.classList.add('hidden');
        }
    });

    // Close dropdowns when pressing Escape key
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            const sidebar = document.getElementById('mobile-sidebar');
            const overlay = document.getElementById('mobile-overlay');
            sidebar.classList.add('hidden');
            sidebar.classList.add('-translate-x-full');
            sidebar.classList.remove('translate-x-0');
            if (overlay) overlay.classList.add('hidden');
        }
    });
</script>
