@props(['type' => 'success', 'dismissible' => true])

@php
$alertClasses = match($type) {
    'success' => 'bg-green-50 border-green-200',
    'error' => 'bg-red-50 border-red-200',
    'warning' => 'bg-yellow-50 border-yellow-200',
    'info' => 'bg-blue-50 border-blue-200',
    default => 'bg-gray-50 border-gray-200'
};

$textClasses = match($type) {
    'success' => 'text-green-800',
    'error' => 'text-red-800',
    'warning' => 'text-yellow-800',
    'info' => 'text-blue-800',
    default => 'text-gray-800'
};

$iconName = match($type) {
    'success' => 'check-circle',
    'error' => 'exclamation-triangle',
    'warning' => 'exclamation-triangle',
    'info' => 'information-circle',
    default => 'information-circle'
};

$iconClasses = match($type) {
    'success' => 'text-green-600',
    'error' => 'text-red-600',
    'warning' => 'text-yellow-600',
    'info' => 'text-blue-600',
    default => 'text-gray-600'
};
@endphp

<div {{ $attributes->merge(['class' => "rounded-lg border p-4 {$alertClasses}"]) }}>
    <div class="flex items-start">
        <div class="flex-shrink-0">
            <flux:icon name="{{ $iconName }}" class="w-5 h-5 {{ $iconClasses }}" />
        </div>
        <div class="ml-3 flex-1">
            <div class="text-sm {{ $textClasses }}">
                {{ $slot }}
            </div>
        </div>
        @if($dismissible)
            <div class="ml-auto pl-3">
                <button type="button" 
                        class="inline-flex rounded-md p-1.5 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-50 focus:ring-gray-600"
                        onclick="this.closest('.rounded-lg').remove()">
                    <span class="sr-only">Dismiss</span>
                    <flux:icon name="x-mark" class="w-4 h-4 text-gray-400" />
                </button>
            </div>
        @endif
    </div>
</div>
