@extends('components.layouts.admin')

@section('title', 'Virtual Card Statistics')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Virtual Card Statistics</h1>
            <p class="text-gray-600">Overview of virtual card usage and performance</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.virtual-cards.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Cards
            </flux:button>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="credit-card" class="w-5 h-5 text-blue-600" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Cards</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['total_cards']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Active Cards</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['active_cards']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="no-symbol" class="w-5 h-5 text-red-600" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Blocked Cards</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['blocked_cards']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-yellow-600" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Expired Cards</p>
                    <p class="text-2xl font-bold text-gray-900">{{ number_format($stats['expired_cards']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Financial Overview -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <flux:card>
            <flux:heading size="lg" class="mb-4">Financial Overview</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm font-medium text-gray-500">Total Credit Limit</span>
                    <span class="text-lg font-bold text-gray-900">${{ number_format($stats['total_credit_limit'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm font-medium text-gray-500">Total Current Balance</span>
                    <span class="text-lg font-bold text-gray-900">${{ number_format($stats['total_current_balance'], 2) }}</span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm font-medium text-gray-500">Total Spent</span>
                    <span class="text-lg font-bold text-gray-900">${{ number_format($stats['total_spent'], 2) }}</span>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <flux:heading size="lg" class="mb-4">Card Types</flux:heading>
            <div class="space-y-3">
                @foreach($stats['cards_by_type'] as $type => $count)
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">{{ ucfirst($type) }}</span>
                        <div class="flex items-center space-x-2">
                            <div class="w-20 bg-gray-200 rounded-full h-2">
                                <div class="bg-blue-600 h-2 rounded-full" style="width: {{ $stats['total_cards'] > 0 ? ($count / $stats['total_cards']) * 100 : 0 }}%"></div>
                            </div>
                            <span class="text-sm font-bold text-gray-900">{{ $count }}</span>
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>

        <flux:card>
            <flux:heading size="lg" class="mb-4">Card Brands</flux:heading>
            <div class="space-y-3">
                @foreach($stats['cards_by_brand'] as $brand => $count)
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">{{ ucfirst($brand) }}</span>
                        <div class="flex items-center space-x-2">
                            <div class="w-20 bg-gray-200 rounded-full h-2">
                                <div class="bg-purple-600 h-2 rounded-full" style="width: {{ $stats['total_cards'] > 0 ? ($count / $stats['total_cards']) * 100 : 0 }}%"></div>
                            </div>
                            <span class="text-sm font-bold text-gray-900">{{ $count }}</span>
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>
    </div>

    <!-- Currency Distribution -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Currency Distribution</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($stats['cards_by_currency'] as $currency => $count)
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                            <span class="text-white font-bold text-sm">{{ $currency }}</span>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-gray-900">{{ $currency }}</p>
                            <p class="text-xs text-gray-500">{{ $count }} cards</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-lg font-bold text-gray-900">{{ $count }}</p>
                        <p class="text-xs text-gray-500">{{ $stats['total_cards'] > 0 ? round(($count / $stats['total_cards']) * 100, 1) : 0 }}%</p>
                    </div>
                </div>
            @endforeach
        </div>
    </flux:card>

    <!-- Status Distribution Chart -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Status Distribution</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <div class="w-24 h-24 mx-auto mb-4 relative">
                    <svg class="w-24 h-24 transform -rotate-90" viewBox="0 0 36 36">
                        <path class="text-gray-200" stroke="currentColor" stroke-width="3" fill="none" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                        <path class="text-green-500" stroke="currentColor" stroke-width="3" fill="none" stroke-dasharray="{{ $stats['total_cards'] > 0 ? ($stats['active_cards'] / $stats['total_cards']) * 100 : 0 }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                    </svg>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <span class="text-lg font-bold text-gray-900">{{ $stats['total_cards'] > 0 ? round(($stats['active_cards'] / $stats['total_cards']) * 100, 1) : 0 }}%</span>
                    </div>
                </div>
                <p class="text-sm font-medium text-gray-500">Active</p>
                <p class="text-lg font-bold text-green-600">{{ $stats['active_cards'] }}</p>
            </div>

            <div class="text-center">
                <div class="w-24 h-24 mx-auto mb-4 relative">
                    <svg class="w-24 h-24 transform -rotate-90" viewBox="0 0 36 36">
                        <path class="text-gray-200" stroke="currentColor" stroke-width="3" fill="none" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                        <path class="text-red-500" stroke="currentColor" stroke-width="3" fill="none" stroke-dasharray="{{ $stats['total_cards'] > 0 ? ($stats['blocked_cards'] / $stats['total_cards']) * 100 : 0 }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                    </svg>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <span class="text-lg font-bold text-gray-900">{{ $stats['total_cards'] > 0 ? round(($stats['blocked_cards'] / $stats['total_cards']) * 100, 1) : 0 }}%</span>
                    </div>
                </div>
                <p class="text-sm font-medium text-gray-500">Blocked</p>
                <p class="text-lg font-bold text-red-600">{{ $stats['blocked_cards'] }}</p>
            </div>

            <div class="text-center">
                <div class="w-24 h-24 mx-auto mb-4 relative">
                    <svg class="w-24 h-24 transform -rotate-90" viewBox="0 0 36 36">
                        <path class="text-gray-200" stroke="currentColor" stroke-width="3" fill="none" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                        <path class="text-gray-500" stroke="currentColor" stroke-width="3" fill="none" stroke-dasharray="{{ $stats['total_cards'] > 0 ? ($stats['inactive_cards'] / $stats['total_cards']) * 100 : 0 }}, 100" d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" />
                    </svg>
                    <div class="absolute inset-0 flex items-center justify-center">
                        <span class="text-lg font-bold text-gray-900">{{ $stats['total_cards'] > 0 ? round(($stats['inactive_cards'] / $stats['total_cards']) * 100, 1) : 0 }}%</span>
                    </div>
                </div>
                <p class="text-sm font-medium text-gray-500">Inactive</p>
                <p class="text-lg font-bold text-gray-600">{{ $stats['inactive_cards'] }}</p>
            </div>
        </div>
    </flux:card>
</div>
@endsection
