@extends('components.layouts.admin')

@section('title', 'Virtual Cards Management')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Virtual Cards Management</h1>
            <p class="text-gray-600">Manage virtual cards, view statistics, and control card features</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.virtual-cards.statistics') }}" variant="outline" class="text-xs">
                <flux:icon name="chart-bar" class="w-4 h-4 mr-2" />
                Statistics
            </flux:button>
            <flux:button href="{{ route('admin.virtual-cards.create') }}" class="text-xs">
                <flux:icon name="plus" class="w-4 h-4 mr-2" />
                Create Card
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <flux:field>
                    <flux:label>Search</flux:label>
                    <flux:input 
                        name="search" 
                        value="{{ request('search') }}"
                        placeholder="Search by card number, name, or user..."
                    />
                </flux:field>

                <flux:field>
                    <flux:label>Status</flux:label>
                    <flux:select name="status">
                        <option value="">All Statuses</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="blocked" {{ request('status') === 'blocked' ? 'selected' : '' }}>Blocked</option>
                    </flux:select>
                </flux:field>

                <flux:field>
                    <flux:label>Card Type</flux:label>
                    <flux:select name="card_type">
                        <option value="">All Types</option>
                        <option value="debit" {{ request('card_type') === 'debit' ? 'selected' : '' }}>Debit</option>
                        <option value="credit" {{ request('card_type') === 'credit' ? 'selected' : '' }}>Credit</option>
                        <option value="prepaid" {{ request('card_type') === 'prepaid' ? 'selected' : '' }}>Prepaid</option>
                    </flux:select>
                </flux:field>

                <flux:field>
                    <flux:label>Card Brand</flux:label>
                    <flux:select name="card_brand">
                        <option value="">All Brands</option>
                        <option value="visa" {{ request('card_brand') === 'visa' ? 'selected' : '' }}>Visa</option>
                        <option value="mastercard" {{ request('card_brand') === 'mastercard' ? 'selected' : '' }}>Mastercard</option>
                        <option value="amex" {{ request('card_brand') === 'amex' ? 'selected' : '' }}>American Express</option>
                    </flux:select>
                </flux:field>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <flux:field>
                    <flux:label>Currency</flux:label>
                    <flux:select name="currency">
                        <option value="">All Currencies</option>
                        <option value="USD" {{ request('currency') === 'USD' ? 'selected' : '' }}>USD</option>
                        <option value="EUR" {{ request('currency') === 'EUR' ? 'selected' : '' }}>EUR</option>
                        <option value="GBP" {{ request('currency') === 'GBP' ? 'selected' : '' }}>GBP</option>
                    </flux:select>
                </flux:field>

                <flux:field>
                    <flux:label>Date From</flux:label>
                    <flux:date-picker name="date_from" value="{{ request('date_from') }}" />
                </flux:field>

                <flux:field>
                    <flux:label>Date To</flux:label>
                    <flux:date-picker name="date_to" value="{{ request('date_to') }}" />
                </flux:field>
            </div>

            <div class="flex justify-between items-center">
                <flux:button icon="magnifying-glass" type="submit" variant="outline" class="text-xs">
                    Apply Filters
                </flux:button>
                <flux:button href="{{ route('admin.virtual-cards.index') }}" variant="outline" class="text-xs">
                    <flux:icon name="x-mark" class="w-4 h-4 mr-2" />
                    Clear Filters
                </flux:button>
            </div>
        </form>
    </flux:card>

    <!-- Cards Table -->
    <flux:card>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'card_number', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Card Details
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'user_id', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                User
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'status', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Status
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'current_balance', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Balance
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'expiry_date', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Expiry
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <a href="{{ request()->fullUrlWithQuery(['sort_by' => 'created_at', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']) }}" class="flex items-center space-x-1">
                                Created
                                <flux:icon name="chevron-up-down" class="w-4 h-4" />
                            </a>
                        </th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($cards as $card)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-lg bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                            <flux:icon name="credit-card" class="w-6 h-6 text-white" />
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ $card->masked_card_number }}
                                        </div>
                                        <div class="text-sm text-gray-500">
                                            {{ ucfirst($card->card_brand) }} {{ ucfirst($card->card_type) }}
                                        </div>
                                        @if($card->card_name)
                                            <div class="text-xs text-gray-400">{{ $card->card_name }}</div>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $card->user->name }}</div>
                                <div class="text-sm text-gray-500">{{ $card->user->email }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($card->status === 'active')
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        Active
                                    </span>
                                @elseif($card->status === 'blocked')
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                        Blocked
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                        Inactive
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <div class="font-medium">{{ $card->formatted_current_balance }}</div>
                                @if($card->credit_limit)
                                    <div class="text-xs text-gray-500">Limit: {{ $card->formatted_credit_limit }}</div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <div>{{ $card->expiry_date->format('M Y') }}</div>
                                @if($card->is_expired)
                                    <div class="text-xs text-red-500">Expired</div>
                                @elseif($card->days_until_expiry <= 30)
                                    <div class="text-xs text-yellow-500">{{ $card->days_until_expiry }} days left</div>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ $card->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <div class="flex items-center justify-end space-x-2">
                                    <flux:button href="{{ route('admin.virtual-cards.show', $card) }}" variant="outline" size="sm">
                                        <flux:icon name="eye" class="w-4 h-4" />
                                    </flux:button>
                                    <flux:button href="{{ route('admin.virtual-cards.edit', $card) }}" variant="outline" size="sm">
                                        <flux:icon name="pencil" class="w-4 h-4" />
                                    </flux:button>
                                    
                                    @if($card->status === 'active')
                                        <form method="POST" action="{{ route('admin.virtual-cards.block', $card) }}" class="inline">
                                            @csrf
                                            <flux:button type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                                <flux:icon name="no-symbol" class="w-4 h-4" />
                                            </flux:button>
                                        </form>
                                    @elseif($card->status === 'blocked')
                                        <form method="POST" action="{{ route('admin.virtual-cards.unblock', $card) }}" class="inline">
                                            @csrf
                                            <flux:button type="submit" variant="outline" size="sm" class="text-green-600 hover:text-green-700">
                                                <flux:icon name="check" class="w-4 h-4" />
                                            </flux:button>
                                        </form>
                                    @else
                                        <form method="POST" action="{{ route('admin.virtual-cards.activate', $card) }}" class="inline">
                                            @csrf
                                            <flux:button type="submit" variant="outline" size="sm" class="text-green-600 hover:text-green-700">
                                                <flux:icon name="play" class="w-4 h-4" />
                                            </flux:button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                                <flux:icon name="credit-card" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                                <p class="text-lg font-medium">No virtual cards found</p>
                                <p class="text-sm">Get started by creating a new virtual card.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($cards->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $cards->links() }}
            </div>
        @endif
    </flux:card>
</div>
@endsection
