@extends('components.layouts.admin')

@section('title', 'User Details - ' . $user->name)

@section('content')
<div class="min-h-screen bg-gray-50 p-2">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                User Details
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">{{ $user->name }} - {{ $user->customer_id }}</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            @if($user->customer_status === 'suspended')
                <form method="POST" action="{{ route('admin.users.activate', $user) }}" class="inline">
                    @csrf
                    <flux:button type="submit" variant="filled" class="bg-green-600 hover:bg-green-700 flex items-center gap-1 px-2.5 py-1 text-xs">
                        <flux:icon name="check-circle" class="w-3 h-3" />
                        Activate
                    </flux:button>
                </form>
            @elseif($user->customer_status === 'active')
                <button onclick="openSuspendModal()" class="bg-red-600 hover:bg-red-700 text-white px-2.5 py-1 text-xs rounded-lg flex items-center gap-1">
                    <flux:icon name="x-circle" class="w-3 h-3" />
                    Suspend
                </button>
            @endif
            
            <button onclick="openPasswordModal()" class="bg-yellow-600 hover:bg-yellow-700 text-white px-2.5 py-1 text-xs rounded-lg flex items-center gap-1">
                <flux:icon name="key" class="w-3 h-3" />
                Reset Password
            </button>
            
            @canImpersonate()
                @canBeImpersonated($user)
                    <flux:button variant="outline" href="{{ route('impersonate', $user->id) }}" class="flex items-center gap-1 px-2.5 py-1 text-xs text-blue-600 hover:text-blue-800">
                        <flux:icon name="user" class="w-3 h-3" />
                        Impersonate
                    </flux:button>
                @endCanBeImpersonated
            @endCanImpersonate
            
            <flux:button variant="outline" href="{{ route('admin.users.edit', $user) }}" class="flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="pencil" class="w-3 h-3" />
                Edit
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- User Information -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">User Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs text-gray-500">Full Name</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Email</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->email }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Username</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->username ?? 'Not set' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Customer ID</label>
                        <p class="text-sm font-medium text-gray-900 font-mono">{{ $user->customer_id }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Customer Type</label>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            {{ $user->customer_type === 'premium' ? 'bg-purple-100 text-purple-800' : 
                               ($user->customer_type === 'business' ? 'bg-green-100 text-green-800' : 
                               ($user->customer_type === 'corporate' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ ucfirst($user->customer_type) }}
                        </span>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Status</label>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            {{ $user->customer_status === 'active' ? 'bg-green-100 text-green-800' : 
                               ($user->customer_status === 'suspended' ? 'bg-red-100 text-red-800' : 
                               ($user->customer_status === 'transaction_declined' ? 'bg-red-100 text-red-800' :
                               ($user->customer_status === 'blocked' ? 'bg-red-100 text-red-800' :
                               ($user->customer_status === 'pending_verification' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')))) }}">
                            {{ $user->customer_status_label }}
                        </span>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Role</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->roles->first()->name ?? 'No Role' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Registration Date</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->created_at->format('M j, Y g:i A') }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Last Login</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->last_login_at ? $user->last_login_at->format('M j, Y g:i A') : 'Never' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Account Activated</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->account_activated_at ? $user->account_activated_at->format('M j, Y g:i A') : 'Not activated' }}</p>
                    </div>
                </div>
            </div>

            <!-- Profile Information -->
            @if($user->profile)
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">Profile Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs text-gray-500">Full Name</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->full_name }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Date of Birth</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->date_of_birth ? $user->profile->date_of_birth->format('M j, Y') : 'Not provided' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Age</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->age ?? 'Not provided' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Gender</label>
                        <p class="text-sm font-medium text-gray-900">{{ ucfirst($user->profile->gender ?? 'Not provided') }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Phone Number</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->phone_number ?? 'Not provided' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Occupation</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->occupation ?? 'Not provided' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Annual Income</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->annual_income ? '$' . number_format($user->profile->annual_income, 2) : 'Not provided' }}</p>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Country</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->country ?? 'Not provided' }}</p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="text-xs text-gray-500">Full Address</label>
                        <p class="text-sm font-medium text-gray-900">{{ $user->profile->full_address ?? 'Not provided' }}</p>
                    </div>
                </div>
            </div>
            @endif

            <!-- KYC & Compliance Status -->
            @if($user->profile)
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">KYC & Compliance</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-xs text-gray-500">KYC Status</label>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            {{ $user->profile->kyc_status === 'verified' ? 'bg-green-100 text-green-800' : 
                               ($user->profile->kyc_status === 'rejected' ? 'bg-red-100 text-red-800' : 
                               ($user->profile->kyc_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ $user->profile->kyc_status_label }}
                        </span>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">AML Status</label>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            {{ $user->profile->aml_status === 'clear' ? 'bg-green-100 text-green-800' : 
                               ($user->profile->aml_status === 'flagged' ? 'bg-red-100 text-red-800' : 
                               ($user->profile->aml_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ $user->profile->aml_status_label }}
                        </span>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Compliance Status</label>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            {{ $user->profile->compliance_status === 'compliant' ? 'bg-green-100 text-green-800' : 
                               ($user->profile->compliance_status === 'non_compliant' ? 'bg-red-100 text-red-800' : 
                               ($user->profile->compliance_status === 'pending_review' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ $user->profile->compliance_status_label }}
                        </span>
                    </div>
                </div>
            </div>
            @endif

            <!-- Banking Codes -->
            @if($user->code)
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">Banking Codes</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="text-xs text-gray-500">COT Code</label>
                        <div class="flex items-center gap-2">
                            <span class="text-sm font-medium text-gray-900">{{ $user->code->cot_code ?? 'Not set' }}</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->code->cot_status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $user->code->cot_status ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Tax Code</label>
                        <div class="flex items-center gap-2">
                            <span class="text-sm font-medium text-gray-900">{{ $user->code->tax_code ?? 'Not set' }}</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->code->tax_status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $user->code->tax_status ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">IMF Code</label>
                        <div class="flex items-center gap-2">
                            <span class="text-sm font-medium text-gray-900">{{ $user->code->imf_code ?? 'Not set' }}</span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->code->imf_status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $user->code->imf_status ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">Transfer Codes</label>
                        <div class="flex gap-2">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->code->allow_local ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                Local Transfers Code
                            </span>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->code->allow_international ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                International Transfers Code
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Recent Activity -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">Recent Activity</h2>
                <div class="space-y-3">
                    @forelse($recentActivity as $activity)
                    <div class="flex items-center p-3 bg-gray-50 rounded-lg">
                        <div class="w-8 h-8 bg-{{ $activity['icon_color'] }}-100 rounded-full flex items-center justify-center mr-3">
                            <flux:icon name="{{ $activity['icon'] }}" class="w-4 h-4 text-{{ $activity['icon_color'] }}-600" />
                        </div>
                        <div class="flex-1">
                            <p class="text-sm font-medium text-gray-900">{{ $activity['title'] }}</p>
                            <p class="text-xs text-gray-500">{{ $activity['description'] }}</p>
                        </div>
                        <div class="text-xs text-gray-500">{{ $activity['time']->diffForHumans() }}</div>
                    </div>
                    @empty
                    <div class="flex items-center justify-center p-8 text-gray-500">
                        <div class="text-center">
                            <flux:icon name="inbox" class="w-8 h-8 mx-auto mb-2 text-gray-400" />
                            <p class="text-sm">No recent activity</p>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- User Statistics -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">Statistics</h2>
                <div class="space-y-3">
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Total Accounts</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['total_accounts'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Active Accounts</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['active_accounts'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Total Transactions</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['total_transactions'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Pending Transactions</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['pending_transactions'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">KYC Documents</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['kyc_documents'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Compliance Flags</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['compliance_flags'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Beneficiaries</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['beneficiaries'] }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs text-gray-500">Virtual Cards</span>
                        <span class="text-sm font-medium text-gray-900">{{ $userStats['virtual_cards'] }}</span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
                <h2 class="text-sm font-semibold text-gray-900 mb-3">Quick Actions</h2>
                <div class="space-y-2">
                    <flux:button variant="outline" href="{{ route('admin.accounts.index', ['user' => $user->id]) }}" class="w-full text-xs justify-start">
                        <flux:icon name="credit-card" class="w-3 h-3 mr-2" />
                        View Accounts
                    </flux:button>
                    <flux:button variant="outline" href="{{ route('admin.transactions.index', ['user' => $user->id]) }}" class="w-full text-xs justify-start">
                        <flux:icon name="arrow-right-left" class="w-3 h-3 mr-2" />
                        View Transactions
                    </flux:button>
                    <flux:button variant="outline" href="{{ route('admin.kyc.index', ['user' => $user->id]) }}" class="w-full text-xs justify-start">
                        <flux:icon name="identification" class="w-3 h-3 mr-2" />
                        Review KYC
                    </flux:button>
                    <flux:button variant="outline" href="{{ route('admin.compliance.index', ['user' => $user->id]) }}" class="w-full text-xs justify-start">
                        <flux:icon name="exclamation-triangle" class="w-3 h-3 mr-2" />
                        Compliance Review
                    </flux:button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Suspend Modal -->
<div id="suspendModal" class="fixed inset-0 bg-gray-900/20 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-xl shadow-lg max-w-md w-full p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Suspend User Account</h3>
            <form method="POST" action="{{ route('admin.users.suspend', $user) }}">
                @csrf
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Reason for suspension</label>
                    <flux:textarea name="reason" placeholder="Enter reason for suspension..." rows="3" required></flux:textarea>
                </div>
                <div class="flex gap-2 justify-end">
                    <flux:button type="button" variant="outline" onclick="closeSuspendModal()">Cancel</flux:button>
                    <flux:button type="submit" variant="filled" class="bg-red-600 hover:bg-red-700">Suspend User</flux:button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Password Reset Modal -->
<div id="passwordModal" class="fixed inset-0 bg-gray-900/20 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-xl shadow-lg max-w-md w-full p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Reset User Password</h3>
            <form method="POST" action="{{ route('admin.users.reset-password', $user) }}">
                @csrf
                <div class="mb-4">
                    <flux:input name="password" type="password" placeholder="New password" required />
                </div>
                <div class="mb-4">
                    <flux:input name="password_confirmation" type="password" placeholder="Confirm new password" required />
                </div>
                <div class="flex gap-2 justify-end">
                    <flux:button type="button" variant="outline" onclick="closePasswordModal()">Cancel</flux:button>
                    <flux:button type="submit" variant="primary">Reset Password</flux:button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openSuspendModal() {
    document.getElementById('suspendModal').classList.remove('hidden');
}

function closeSuspendModal() {
    document.getElementById('suspendModal').classList.add('hidden');
}

function openPasswordModal() {
    document.getElementById('passwordModal').classList.remove('hidden');
}

function closePasswordModal() {
    document.getElementById('passwordModal').classList.add('hidden');
}

// Close modals when clicking outside
document.addEventListener('click', function(event) {
    const suspendModal = document.getElementById('suspendModal');
    const passwordModal = document.getElementById('passwordModal');
    
    if (event.target === suspendModal) {
        closeSuspendModal();
    }
    if (event.target === passwordModal) {
        closePasswordModal();
    }
});
</script>
@endsection
