@extends('components.layouts.admin')

@section('title', 'User Management')

@section('content')
<div class="min-h-screen bg-gray-50 p-2">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header Section -->
    <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-3">
        <div>
            <h1 class="text-base font-bold text-gray-900 mb-0.5 relative">
                User Management
                <div class="absolute bottom-0 left-0 w-[30px] h-[2px] bg-[#04327c]"></div>
            </h1>
            <p class="text-xs text-gray-600 mt-1.5">Manage user accounts and profiles</p>
        </div>
        <div class="flex gap-2 mt-2 lg:mt-0">
            <flux:button variant="outline" href="{{ route('admin.users.export', request()->query()) }}" class="flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="arrow-down-tray" class="w-3 h-3" />
                Export CSV
            </flux:button>
            <flux:button variant="primary" href="{{ route('admin.users.create') }}" class="flex items-center gap-1 px-2.5 py-1 text-xs">
                <flux:icon name="plus" class="w-3 h-3" />
                Add User
            </flux:button>
        </div>
    </div>

    <!-- Filters Section -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4 mb-6">
        <form method="GET" action="{{ route('admin.users.index') }}" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
            <!-- Search -->
            <div class="lg:col-span-2">
                <flux:input 
                    name="search" 
                    placeholder="Search users..." 
                    value="{{ request('search') }}"
                    class="text-xs"
                />
            </div>

            <!-- Status Filter -->
            <div>
                <flux:select name="status" placeholder="All Statuses" class="text-xs">
                    <option value="">All Statuses</option>
                    @foreach($filterOptions['statuses'] as $status)
                        <option value="{{ $status }}" {{ request('status') === $status ? 'selected' : '' }}>
                            {{ ucfirst(str_replace('_', ' ', $status)) }}
                        </option>
                    @endforeach
                </flux:select>
            </div>

            <!-- Type Filter -->
            <div>
                <flux:select name="type" placeholder="All Types" class="text-xs">
                    <option value="">All Types</option>
                    @foreach($filterOptions['types'] as $type)
                        <option value="{{ $type }}" {{ request('type') === $type ? 'selected' : '' }}>
                            {{ ucfirst($type) }}
                        </option>
                    @endforeach
                </flux:select>
            </div>

            <!-- Role Filter -->
            <div>
                <flux:select name="role" placeholder="All Roles" class="text-xs">
                    <option value="">All Roles</option>
                    @foreach($filterOptions['roles'] as $roleName => $roleDisplay)
                        <option value="{{ $roleName }}" {{ request('role') === $roleName ? 'selected' : '' }}>
                            {{ ucfirst($roleName) }}
                        </option>
                    @endforeach
                </flux:select>
            </div>

            <!-- KYC Status Filter -->
            <div>
                <flux:select name="kyc_status" placeholder="All KYC" class="text-xs">
                    <option value="">All KYC</option>
                    @foreach($filterOptions['kyc_statuses'] as $status)
                        <option value="{{ $status }}" {{ request('kyc_status') === $status ? 'selected' : '' }}>
                            {{ ucfirst(str_replace('_', ' ', $status)) }}
                        </option>
                    @endforeach
                </flux:select>
            </div>

            <!-- Date Filters -->
            <div class="lg:col-span-2">
                <div class="grid grid-cols-2 gap-2">
                    <flux:date-picker 
                        name="date_from" 
                        placeholder="From Date"
                        value="{{ request('date_from') }}"
                        selectable-header
                        class="text-xs"
                    />
                    <flux:date-picker 
                        name="date_to" 
                        placeholder="To Date"
                        value="{{ request('date_to') }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>
            </div>

            <!-- Sort Options -->
            <div class="lg:col-span-2">
                <div class="grid grid-cols-2 gap-2">
                    <flux:select name="sort_by" class="text-xs">
                        <option value="created_at" {{ request('sort_by', 'created_at') === 'created_at' ? 'selected' : '' }}>Registration Date</option>
                        <option value="name" {{ request('sort_by') === 'name' ? 'selected' : '' }}>Name</option>
                        <option value="email" {{ request('sort_by') === 'email' ? 'selected' : '' }}>Email</option>
                        <option value="customer_status" {{ request('sort_by') === 'customer_status' ? 'selected' : '' }}>Status</option>
                        <option value="last_login_at" {{ request('sort_by') === 'last_login_at' ? 'selected' : '' }}>Last Login</option>
                    </flux:select>
                    <flux:select name="sort_direction" class="text-xs">
                        <option value="desc" {{ request('sort_direction', 'desc') === 'desc' ? 'selected' : '' }}>Descending</option>
                        <option value="asc" {{ request('sort_direction') === 'asc' ? 'selected' : '' }}>Ascending</option>
                    </flux:select>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="lg:col-span-2 flex gap-2">
                <flux:button type="submit" variant="primary" class="flex-1 text-xs">
                    Apply Filters
                </flux:button>
                <flux:button type="button" variant="outline" onclick="window.location.href='{{ route('admin.users.index') }}'" class="text-xs">
                    Clear
                </flux:button>
            </div>
        </form>
    </div>

    <!-- Users Table -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer ID</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">KYC</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Account(s)</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Login</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($users as $user)
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3">
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                                    <span class="text-xs font-medium text-blue-600">{{ $user->initials() }}</span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                    <div class="text-xs text-gray-500">{{ $user->email }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-4 py-3 text-sm text-gray-900 font-mono">{{ $user->customer_id }}</td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->customer_type === 'premium' ? 'bg-purple-100 text-purple-800' : 
                                   ($user->customer_type === 'business' ? 'bg-green-100 text-green-800' : 
                                   ($user->customer_type === 'corporate' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-800')) }}">
                                {{ ucfirst($user->customer_type) }}
                            </span>
                        </td>
                        <td class="px-4 py-3">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                {{ $user->customer_status === 'active' ? 'bg-green-100 text-green-800' : 
                                   ($user->customer_status === 'suspended' ? 'bg-red-100 text-red-800' :
                                   ($user->customer_status === 'transaction_declined' ? 'bg-red-100 text-red-800' :
                                   ($user->customer_status === 'blocked' ? 'bg-red-100 text-red-800' :
                                   ($user->customer_status === 'pending_verification' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')))) }}">
                                {{ $user->customer_status_label }}
                            </span>
                        </td>
                        <td class="px-4 py-3 text-sm text-gray-900">{{ $user->roles->first()->name ?? 'No Role' }}</td>
                        <td class="px-4 py-3">
                            @if($user->profile)
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    {{ $user->profile->kyc_status === 'verified' ? 'bg-green-100 text-green-800' : 
                                       ($user->profile->kyc_status === 'rejected' ? 'bg-red-100 text-red-800' : 
                                       ($user->profile->kyc_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')) }}">
                                    {{ $user->profile->kyc_status_label }}
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    No Profile
                                </span>
                            @endif
                        </td>
                        <td class="px-4 py-3 text-sm text-gray-900 font-medium">{{ $user->accounts->count() }}</td>
                        <td class="px-4 py-3 text-sm text-gray-500">
                            {{ $user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never' }}
                        </td>
                        <td class="px-4 py-3">
                            <div class="flex items-center space-x-2">
                                <flux:button variant="ghost" size="sm" href="{{ route('admin.users.show', $user) }}" class="text-xs">
                                    <flux:icon name="eye" class="w-3 h-3" />
                                </flux:button>
                                <flux:button variant="ghost" size="sm" href="{{ route('admin.users.edit', $user) }}" class="text-xs">
                                    <flux:icon name="pencil" class="w-3 h-3" />
                                </flux:button>
                                
                                @canImpersonate()
                                    @canBeImpersonated($user)
                                        <flux:button icon="user" variant="ghost" size="sm" href="{{ route('impersonate', $user->id) }}" class="text-xs text-blue-600 hover:text-blue-800" title="Impersonate User">
                                        </flux:button>
                                    @endCanBeImpersonated
                                @endCanImpersonate
                                
                                @if(!$user->isSuperAdmin())
                                <form method="POST" action="{{ route('admin.users.destroy', $user) }}" class="inline" onsubmit="return confirm('Are you sure you want to delete this user?')">
                                    @csrf
                                    @method('DELETE')
                                    <flux:button type="submit" variant="ghost" size="sm" class="text-xs text-red-600 hover:text-red-800">
                                        <flux:icon name="trash" class="w-3 h-3" />
                                    </flux:button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="px-4 py-8 text-center text-gray-500">
                            <div class="flex flex-col items-center">
                                <flux:icon name="users" class="w-8 h-8 text-gray-400 mb-2" />
                                <p class="text-sm">No users found</p>
                                <p class="text-xs text-gray-400">Try adjusting your search criteria</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($users->hasPages())
        <div class="px-4 py-3 border-t border-gray-200">
            {{ $users->links() }}
        </div>
        @endif
    </div>

    <!-- Summary Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mt-6">
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-500">Total Users</p>
                    <p class="text-lg font-bold text-gray-900">{{ $users->total() }}</p>
                </div>
                <flux:icon name="users" class="w-6 h-6 text-blue-600" />
            </div>
        </div>
        
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-500">Active Users</p>
                    <p class="text-lg font-bold text-gray-900">{{ $users->where('customer_status', 'active')->count() }}</p>
                </div>
                <flux:icon name="check-circle" class="w-6 h-6 text-green-600" />
            </div>
        </div>
        
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-500">Pending KYC</p>
                    <p class="text-lg font-bold text-gray-900">{{ $users->filter(fn($user) => $user->profile && $user->profile->kyc_status === 'pending')->count() }}</p>
                </div>
                <flux:icon name="clock" class="w-6 h-6 text-yellow-600" />
            </div>
        </div>
        
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-xs text-gray-500">Suspended</p>
                    <p class="text-lg font-bold text-gray-900">{{ $users->where('customer_status', 'suspended')->count() }}</p>
                </div>
                <flux:icon name="exclamation-triangle" class="w-6 h-6 text-red-600" />
            </div>
        </div>
    </div>
</div>
@endsection
