@extends('components.layouts.admin')

@section('title', 'Edit User')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit User</h1>
            <p class="text-sm text-gray-600 mt-1">Update user information and settings</p>
        </div>
        <div class="flex items-center gap-3">
            <flux:button href="{{ route('admin.users.show', $user) }}" variant="ghost" class="text-xs">
                <flux:icon name="eye" class="w-4 h-4 mr-1" />
                View User
            </flux:button>
            <flux:button href="{{ route('admin.users.index') }}" variant="ghost" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-1" />
                Back to Users
            </flux:button>
        </div>
    </div>

    <!-- User Info Card -->
    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
        <div class="flex items-center gap-4 mb-6">
            <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full flex items-center justify-center">
                <span class="text-white font-semibold text-lg">{{ substr($user->name, 0, 2) }}</span>
            </div>
            <div>
                <h2 class="text-lg font-semibold text-gray-900">{{ $user->name }}</h2>
                <p class="text-sm text-gray-600">{{ $user->email }}</p>
                <div class="flex items-center gap-2 mt-1">
                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $user->customer_status === 'active' ? 'bg-green-100 text-green-800' : ($user->customer_status === 'suspended' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') }}">
                        {{ ucfirst($user->customer_status) }}
                    </span>
                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                        {{ ucfirst($user->customer_type) }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Form -->
    <form method="POST" action="{{ route('admin.users.update', $user) }}" class="space-y-6">
        @csrf
        @method('PUT')

        <!-- Basic Information -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Basic Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Name -->
                <flux:field>
                    <flux:label>Full Name</flux:label>
                    <flux:input 
                        name="name" 
                        value="{{ old('name', $user->name) }}" 
                        placeholder="Enter full name"
                        required
                    />
                    <flux:error name="name" />
                </flux:field>

                <!-- Email -->
                <flux:field>
                    <flux:label>Email Address</flux:label>
                    <flux:input 
                        name="email" 
                        type="email" 
                        value="{{ old('email', $user->email) }}" 
                        placeholder="Enter email address"
                        required
                    />
                    <flux:error name="email" />
                </flux:field>

                <!-- Username -->
                <flux:field>
                    <flux:label>Username</flux:label>
                    <flux:input 
                        name="username" 
                        value="{{ old('username', $user->username) }}" 
                        placeholder="Enter username"
                    />
                    <flux:error name="username" />
                </flux:field>

                <!-- Customer ID -->
                <flux:field>
                    <flux:label>Customer ID</flux:label>
                    <flux:input 
                        name="customer_id" 
                        value="{{ old('customer_id', $user->customer_id) }}" 
                        placeholder="Enter customer ID"
                        readonly
                        class="bg-gray-50"
                    />
                    <flux:error name="customer_id" />
                </flux:field>

                <!-- Customer Type -->
                <flux:field>
                    <flux:label>Customer Type</flux:label>
                    <flux:select name="customer_type">
                        <option value="individual" {{ old('customer_type', $user->customer_type) === 'individual' ? 'selected' : '' }}>Individual</option>
                     </flux:select>
                    <flux:error name="customer_type" />
                </flux:field>

                <!-- Customer Status -->
                <flux:field>
                    <flux:label>Account Status</flux:label>
                    <flux:select name="customer_status">
                        <option value="active" {{ old('customer_status', $user->customer_status) === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="pending_verification" {{ old('customer_status', $user->customer_status) === 'pending_verification' ? 'selected' : '' }}>Pending Verification</option>
                        <option value="suspended" {{ old('customer_status', $user->customer_status) === 'suspended' ? 'selected' : '' }}>Suspended</option>
                        <option value="inactive" {{ old('customer_status', $user->customer_status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="transaction_declined" {{ old('customer_status', $user->customer_status) === 'transaction_declined' ? 'selected' : '' }}>Transaction Declined</option>
                        <option value="blocked" {{ old('customer_status', $user->customer_status) === 'blocked' ? 'selected' : '' }}>Blocked</option>
                    </flux:select>
                    <flux:error name="customer_status" />
                </flux:field>

                <!-- Role -->
                <flux:field>
                    <flux:label>User Role</flux:label>
                    <flux:select name="role">
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}" {{ old('role', $user->roles->first()?->name) === $role->name ? 'selected' : '' }}>
                                {{ ucfirst($role->name) }}
                            </option>
                        @endforeach
                    </flux:select>
                    <flux:error name="role" />
                </flux:field>
            </div>
        </div>

        <!-- Security Information -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Security Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Password -->
                <flux:field>
                    <flux:label>New Password</flux:label>
                    <flux:input 
                        name="password" 
                        type="password" 
                        placeholder="Leave blank to keep current password"
                    />
                    <flux:error name="password" />
                </flux:field>

                <!-- Password Confirmation -->
                <flux:field>
                    <flux:label>Confirm New Password</flux:label>
                    <flux:input 
                        name="password_confirmation" 
                        type="password" 
                        placeholder="Confirm new password"
                    />
                    <flux:error name="password_confirmation" />
                </flux:field>

                <!-- PIN -->
                <flux:field>
                    <flux:label>New PIN</flux:label>
                    <flux:input 
                        name="pin" 
                        type="password" 
                        placeholder="Leave blank to keep current PIN"
                        maxlength="6"
                    />
                    <flux:error name="pin" />
                </flux:field>
            </div>
        </div>

        <!-- Profile Information -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Profile Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- First Name -->
                <flux:field>
                    <flux:label>First Name</flux:label>
                    <flux:input 
                        name="first_name" 
                        value="{{ old('first_name', $user->profile?->first_name) }}" 
                        placeholder="Enter first name"
                    />
                    <flux:error name="first_name" />
                </flux:field>

                <!-- Last Name -->
                <flux:field>
                    <flux:label>Last Name</flux:label>
                    <flux:input 
                        name="last_name" 
                        value="{{ old('last_name', $user->profile?->last_name) }}" 
                        placeholder="Enter last name"
                    />
                    <flux:error name="last_name" />
                </flux:field>

                <!-- Middle Name -->
                <flux:field>
                    <flux:label>Middle Name</flux:label>
                    <flux:input 
                        name="middle_name" 
                        value="{{ old('middle_name', $user->profile?->middle_name) }}" 
                        placeholder="Enter middle name"
                    />
                    <flux:error name="middle_name" />
                </flux:field>

                <!-- Date of Birth -->
                <flux:field>
                    <flux:label>Date of Birth</flux:label>
                    <flux:date-picker 
                        name="date_of_birth" 
                        value="{{ old('date_of_birth', $user->profile?->date_of_birth ? $user->profile->date_of_birth->format('Y-m-d') : '') }}" 
                        placeholder="Select date of birth"
                        selectable-header
                    />
                    <flux:error name="date_of_birth" />
                </flux:field>

                <!-- Gender -->
                <flux:field>
                    <flux:label>Gender</flux:label>
                    <flux:select name="gender">
                        <option value="" {{ old('gender', $user->profile?->gender) === '' ? 'selected' : '' }}>Select gender</option>
                        <option value="male" {{ old('gender', $user->profile?->gender) === 'male' ? 'selected' : '' }}>Male</option>
                        <option value="female" {{ old('gender', $user->profile?->gender) === 'female' ? 'selected' : '' }}>Female</option>
                        <option value="other" {{ old('gender', $user->profile?->gender) === 'other' ? 'selected' : '' }}>Other</option>
                        <option value="prefer_not_to_say" {{ old('gender', $user->profile?->gender) === 'prefer_not_to_say' ? 'selected' : '' }}>Prefer not to say</option>
                    </flux:select>
                    <flux:error name="gender" />
                </flux:field>

                <!-- Marital Status -->
                <flux:field>
                    <flux:label>Marital Status</flux:label>
                    <flux:select name="marital_status">
                        <option value="" {{ old('marital_status', $user->profile?->marital_status) === '' ? 'selected' : '' }}>Select marital status</option>
                        <option value="single" {{ old('marital_status', $user->profile?->marital_status) === 'single' ? 'selected' : '' }}>Single</option>
                        <option value="married" {{ old('marital_status', $user->profile?->marital_status) === 'married' ? 'selected' : '' }}>Married</option>
                        <option value="divorced" {{ old('marital_status', $user->profile?->marital_status) === 'divorced' ? 'selected' : '' }}>Divorced</option>
                        <option value="widowed" {{ old('marital_status', $user->profile?->marital_status) === 'widowed' ? 'selected' : '' }}>Widowed</option>
                        <option value="separated" {{ old('marital_status', $user->profile?->marital_status) === 'separated' ? 'selected' : '' }}>Separated</option>
                    </flux:select>
                    <flux:error name="marital_status" />
                </flux:field>

                <!-- Phone Number -->
                <flux:field>
                    <flux:label>Phone Number</flux:label>
                    <flux:input 
                        name="phone_number" 
                        value="{{ old('phone_number', $user->profile?->phone_number) }}" 
                        placeholder="Enter phone number"
                    />
                    <flux:error name="phone_number" />
                </flux:field>

                <!-- Occupation -->
                <flux:field>
                    <flux:label>Occupation</flux:label>
                    <flux:input 
                        name="occupation" 
                        value="{{ old('occupation', $user->profile?->occupation) }}" 
                        placeholder="Enter occupation"
                    />
                    <flux:error name="occupation" />
                </flux:field>

                <!-- Annual Income -->
                <flux:field>
                    <flux:label>Annual Income</flux:label>
                    <flux:input 
                        name="annual_income" 
                        type="number" 
                        value="{{ old('annual_income', $user->profile?->annual_income) }}" 
                        placeholder="Enter annual income"
                    />
                    <flux:error name="annual_income" />
                </flux:field>
            </div>
        </div>

        <!-- Address Information -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Address Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Address Line 1 -->
                <flux:field class="md:col-span-2">
                    <flux:label>Address Line 1</flux:label>
                    <flux:input 
                        name="address_line_1" 
                        value="{{ old('address_line_1', $user->profile?->address_line_1) }}" 
                        placeholder="Enter address line 1"
                    />
                    <flux:error name="address_line_1" />
                </flux:field>

                <!-- City -->
                <flux:field>
                    <flux:label>City</flux:label>
                    <flux:input 
                        name="city" 
                        value="{{ old('city', $user->profile?->city) }}" 
                        placeholder="Enter city"
                    />
                    <flux:error name="city" />
                </flux:field>

                <!-- State/Province -->
                <flux:field>
                    <flux:label>State/Province</flux:label>
                    <flux:input 
                        name="state_province" 
                        value="{{ old('state_province', $user->profile?->state_province) }}" 
                        placeholder="Enter state/province"
                    />
                    <flux:error name="state_province" />
                </flux:field>

                <!-- Postal Code -->
                <flux:field>
                    <flux:label>Postal Code</flux:label>
                    <flux:input 
                        name="postal_code" 
                        value="{{ old('postal_code', $user->profile?->postal_code) }}" 
                        placeholder="Enter postal code"
                    />
                    <flux:error name="postal_code" />
                </flux:field>

                <!-- Country -->
                <flux:field>
                    <flux:label>Country</flux:label>
                    <flux:select 
                        name="country" 
                        placeholder="Select country"
                    >
                        <option value="">Select a country</option>
                        @foreach(\App\Models\Country::orderBy('name')->get() as $country)
                            <option value="{{ $country->name }}" {{ old('country', $user->profile?->country) == $country->name ? 'selected' : '' }}>
                                {{ $country->name }}
                            </option>
                        @endforeach
                    </flux:select>
                    <flux:error name="country" />
                </flux:field>
            </div>
        </div>

        <!-- Emergency Contact -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Emergency Contact</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Emergency Contact Name -->
                <flux:field>
                    <flux:label>Emergency Contact Name</flux:label>
                    <flux:input 
                        name="emergency_contact_name" 
                        value="{{ old('emergency_contact_name', $user->profile?->emergency_contact_name) }}" 
                        placeholder="Enter emergency contact name"
                    />
                    <flux:error name="emergency_contact_name" />
                </flux:field>

                <!-- Emergency Contact Phone -->
                <flux:field>
                    <flux:label>Emergency Contact Phone</flux:label>
                    <flux:input 
                        name="emergency_contact_phone" 
                        value="{{ old('emergency_contact_phone', $user->profile?->emergency_contact_phone) }}" 
                        placeholder="Enter emergency contact phone"
                    />
                    <flux:error name="emergency_contact_phone" />
                </flux:field>

                <!-- Emergency Contact Relationship -->
                <flux:field class="md:col-span-2">
                    <flux:label>Relationship</flux:label>
                    <flux:input 
                        name="emergency_contact_relationship" 
                        value="{{ old('emergency_contact_relationship', $user->profile?->emergency_contact_relationship) }}" 
                        placeholder="Enter relationship (e.g., Spouse, Parent, Sibling)"
                    />
                    <flux:error name="emergency_contact_relationship" />
                </flux:field>
            </div>
        </div>

        <!-- Banking Codes -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Banking Codes</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- COT Code -->
                <flux:field>
                    <flux:label>COT Code</flux:label>
                    <flux:input 
                        name="cot_code" 
                        value="{{ old('cot_code', $user->code?->cot_code) }}" 
                        placeholder="Enter COT code"
                    />
                    <flux:error name="cot_code" />
                </flux:field>

                <!-- COT Status -->
                <flux:field>
                    <flux:label>COT Status</flux:label>
                    <flux:select name="cot_status">
                        <option value="0" {{ old('cot_status', $user->code?->cot_status ? '1' : '0') == '0' ? 'selected' : '' }}>Inactive</option>
                        <option value="1" {{ old('cot_status', $user->code?->cot_status ? '1' : '0') == '1' ? 'selected' : '' }}>Active</option>
                    </flux:select>
                    <flux:error name="cot_status" />
                </flux:field>

                <!-- COT Message -->
                <flux:field class="md:col-span-2">
                    <flux:label>COT Message</flux:label>
                    <flux:textarea 
                        name="cot_msg" 
                        placeholder="Enter COT message or notes..."
                        rows="2"
                    >{{ old('cot_msg', $user->code?->cot_msg) }}</flux:textarea>
                    <flux:error name="cot_msg" />
                </flux:field>

                <!-- Tax Code -->
                <flux:field>
                    <flux:label>Tax Code</flux:label>
                    <flux:input 
                        name="tax_code" 
                        value="{{ old('tax_code', $user->code?->tax_code) }}" 
                        placeholder="Enter tax code"
                    />
                    <flux:error name="tax_code" />
                </flux:field>

                <!-- Tax Status -->
                <flux:field>
                    <flux:label>Tax Status</flux:label>
                    <flux:select name="tax_status">
                        <option value="0" {{ old('tax_status', $user->code?->tax_status ? '1' : '0') == '0' ? 'selected' : '' }}>Inactive</option>
                        <option value="1" {{ old('tax_status', $user->code?->tax_status ? '1' : '0') == '1' ? 'selected' : '' }}>Active</option>
                    </flux:select>
                    <flux:error name="tax_status" />
                </flux:field>

                <!-- Tax Message -->
                <flux:field class="md:col-span-2">
                    <flux:label>Tax Message</flux:label>
                    <flux:textarea 
                        name="tax_msg" 
                        placeholder="Enter tax message or notes..."
                        rows="2"
                    >{{ old('tax_msg', $user->code?->tax_msg) }}</flux:textarea>
                    <flux:error name="tax_msg" />
                </flux:field>

                <!-- IMF Code -->
                <flux:field>
                    <flux:label>IMF Code</flux:label>
                    <flux:input 
                        name="imf_code" 
                        value="{{ old('imf_code', $user->code?->imf_code) }}" 
                        placeholder="Enter IMF code"
                    />
                    <flux:error name="imf_code" />
                </flux:field>

                <!-- IMF Status -->
                <flux:field>
                    <flux:label>IMF Status</flux:label>
                    <flux:select name="imf_status">
                        <option value="0" {{ old('imf_status', $user->code?->imf_status ? '1' : '0') == '0' ? 'selected' : '' }}>Inactive</option>
                        <option value="1" {{ old('imf_status', $user->code?->imf_status ? '1' : '0') == '1' ? 'selected' : '' }}>Active</option>
                    </flux:select>
                    <flux:error name="imf_status" />
                </flux:field>

                <!-- IMF Message -->
                <flux:field class="md:col-span-2">
                    <flux:label>IMF Message</flux:label>
                    <flux:textarea 
                        name="imf_msg" 
                        placeholder="Enter IMF message or notes..."
                        rows="2"
                    >{{ old('imf_msg', $user->code?->imf_msg) }}</flux:textarea>
                    <flux:error name="imf_msg" />
                </flux:field>

                <!-- Transfer Permissions -->
                <flux:field>
                    <flux:label>Local Transfers Code</flux:label>
                    <flux:select name="allow_local">
                        <option value="0" {{ old('allow_local', $user->code?->allow_local ? '1' : '0') == '0' ? 'selected' : '' }}>Disabled</option>
                        <option value="1" {{ old('allow_local', $user->code?->allow_local ? '1' : '0') == '1' ? 'selected' : '' }}>Enabled</option>
                    </flux:select>
                    <flux:error name="allow_local" />
                </flux:field>

                <flux:field>
                    <flux:label>International Transfers Code</flux:label>
                    <flux:select name="allow_international">
                        <option value="0" {{ old('allow_international', $user->code?->allow_international ? '1' : '0') == '0' ? 'selected' : '' }}>Disabled</option>
                        <option value="1" {{ old('allow_international', $user->code?->allow_international ? '1' : '0') == '1' ? 'selected' : '' }}>Enabled</option>
                    </flux:select>
                    <flux:error name="allow_international" />
                </flux:field>
            </div>
        </div>

        <!-- KYC & Compliance Status -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">KYC & Compliance Status</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- KYC Status -->
                <flux:field>
                    <flux:label>KYC Status</flux:label>
                    <flux:select name="kyc_status">
                        <option value="pending" {{ old('kyc_status', $user->profile?->kyc_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="verified" {{ old('kyc_status', $user->profile?->kyc_status) === 'verified' ? 'selected' : '' }}>Verified</option>
                        <option value="rejected" {{ old('kyc_status', $user->profile?->kyc_status) === 'rejected' ? 'selected' : '' }}>Rejected</option>
                        <option value="expired" {{ old('kyc_status', $user->profile?->kyc_status) === 'expired' ? 'selected' : '' }}>Expired</option>
                    </flux:select>
                    <flux:error name="kyc_status" />
                </flux:field>

                <!-- AML Status -->
                <flux:field>
                    <flux:label>AML Status</flux:label>
                    <flux:select name="aml_status">
                        <option value="pending" {{ old('aml_status', $user->profile?->aml_status) === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="clear" {{ old('aml_status', $user->profile?->aml_status) === 'clear' ? 'selected' : '' }}>Cleared</option>
                        <option value="flagged" {{ old('aml_status', $user->profile?->aml_status) === 'flagged' ? 'selected' : '' }}>Flagged</option>
                        <option value="blocked" {{ old('aml_status', $user->profile?->aml_status) === 'blocked' ? 'selected' : '' }}>Blocked</option>
                    </flux:select>
                    <flux:error name="aml_status" />
                </flux:field>

                <!-- Compliance Status -->
                <flux:field>
                    <flux:label>Compliance Status</flux:label>
                    <flux:select name="compliance_status">
                        <option value="pending_review" {{ old('compliance_status', $user->profile?->compliance_status) === 'pending_review' ? 'selected' : '' }}>Pending Review</option>
                        <option value="compliant" {{ old('compliance_status', $user->profile?->compliance_status) === 'compliant' ? 'selected' : '' }}>Compliant</option>
                        <option value="non_compliant" {{ old('compliance_status', $user->profile?->compliance_status) === 'non_compliant' ? 'selected' : '' }}>Non-Compliant</option>
                        <option value="under_investigation" {{ old('compliance_status', $user->profile?->compliance_status) === 'under_investigation' ? 'selected' : '' }}>Under Investigation</option>
                    </flux:select>
                    <flux:error name="compliance_status" />
                </flux:field>
            </div>
        </div>

        <!-- Notes -->
        <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Additional Notes</h3>
            <flux:field>
                <flux:label>Notes</flux:label>
                <flux:textarea 
                    name="notes" 
                    placeholder="Enter any additional notes about this user..."
                    rows="4"
                >{{ old('notes', $user->profile?->notes) }}</flux:textarea>
                <flux:error name="notes" />
            </flux:field>
        </div>

        <!-- Form Actions -->
        <div class="flex items-center justify-end gap-3 pt-6 border-t border-gray-200">
            <flux:button href="{{ route('admin.users.show', $user) }}" variant="ghost">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" variant="primary">
                Update User
            </flux:button>
        </div>
    </form>
</div>
@endsection
