@extends('components.layouts.admin')

@section('title', 'Transfer Details')

@section('content')
    <div class="space-y-6">
        <!-- Success Message -->
        @if (session('success'))
            <x-admin.message type="success">
                {{ session('success') }}
            </x-admin.message>
        @endif

        <!-- Error Message -->
        @if (session('error'))
            <x-admin.message type="error">
                {{ session('error') }}
            </x-admin.message>
        @endif

        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Transfer Details</h1>
                <p class="text-gray-600">View and manage transfer information</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="pencil" href="{{ route('admin.transfers.edit', $transfer) }}" variant="outline">
                    Edit Transfer
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.transfers.index') }}" variant="outline">
                    Back to Transfers
                </flux:button>
            </div>
        </div>

        <!-- Transfer Actions -->
        @if($transfer->status === 'pending')
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-yellow-600 mr-2" />
                        <span class="text-yellow-800 font-medium">This transfer is pending approval</span>
                    </div>
                    <div class="flex space-x-2">
                        <form method="POST" action="{{ route('admin.transfers.approve', $transfer) }}" class="inline">
                            @csrf
                            <flux:button icon="check" type="submit" variant="primary" size="sm">
                                Approve
                            </flux:button>
                        </form>
                        <form method="POST" action="{{ route('admin.transfers.reject', $transfer) }}" class="inline">
                            @csrf
                            <flux:button icon="x-mark" type="submit" variant="outline" size="sm" class="text-red-600 hover:text-red-700">
                                Reject
                            </flux:button>
                        </form>
                    </div>
                </div>
            </div>
        @endif

        @if($transfer->status === 'processing')
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <flux:icon name="clock" class="w-5 h-5 text-blue-600 mr-2" />
                        <span class="text-blue-800 font-medium">This transfer is being processed</span>
                    </div>
                    <form method="POST" action="{{ route('admin.transfers.mark-arrived', $transfer) }}" class="inline">
                        @csrf
                        <flux:button icon="check-circle" type="submit" variant="primary" size="sm">
                            Mark as Arrived
                        </flux:button>
                    </form>
                </div>
            </div>
        @endif

        @if($transfer->status === 'completed')
            <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <flux:icon name="check-circle" class="w-5 h-5 text-green-600 mr-2" />
                        <span class="text-green-800 font-medium">This transfer has been completed</span>
                    </div>
                    <form method="POST" action="{{ route('admin.transfers.reverse', $transfer) }}" class="inline">
                        @csrf
                        <flux:button icon="arrow-uturn-left" type="submit" variant="outline" size="sm" class="text-purple-600 hover:text-purple-700">
                            Reverse Transfer
                        </flux:button>
                    </form>
                </div>
            </div>
        @endif

        <!-- Transfer Information -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Transfer Details -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Basic Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Transfer Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Transaction ID</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $transfer->transaction_id }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Reference Number</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $transfer->reference_number }}</dd>
                        </div>
                        @if($transfer->external_reference)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">External Reference</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $transfer->external_reference }}</dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Type</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    Transfer
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Category</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($transfer->category) }}</dd>
                        </div>
                        @if($transfer->subcategory)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Subcategory</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ ucfirst($transfer->subcategory) }}</dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if($transfer->status === 'completed') bg-green-100 text-green-800
                                    @elseif($transfer->status === 'pending') bg-yellow-100 text-yellow-800
                                    @elseif($transfer->status === 'processing') bg-blue-100 text-blue-800
                                    @elseif($transfer->status === 'failed') bg-red-100 text-red-800
                                    @elseif($transfer->status === 'cancelled') bg-gray-100 text-gray-800
                                    @elseif($transfer->status === 'reversed') bg-purple-100 text-purple-800
                                    @else bg-gray-100 text-gray-800
                                    @endif">
                                    {{ ucfirst($transfer->status) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Verification Status</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                    @if($transfer->verification_status === 'verified') bg-green-100 text-green-800
                                    @elseif($transfer->verification_status === 'pending') bg-yellow-100 text-yellow-800
                                    @elseif($transfer->verification_status === 'rejected') bg-red-100 text-red-800
                                    @else bg-gray-100 text-gray-800
                                    @endif">
                                    {{ ucfirst($transfer->verification_status) }}
                                </span>
                            </dd>
                        </div>
                    </dl>
                </div>

                <!-- Transfer Details -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Transfer Details</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Transfer Method</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ ucfirst($transfer->transfer_method ?? 'N/A') }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Transfer Speed</dt>
                            <dd class="mt-1">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    {{ ucfirst($transfer->transfer_speed ?? 'N/A') }}
                                </span>
                            </dd>
                        </div>
                        @if($transfer->estimated_arrival)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Estimated Arrival</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->estimated_arrival->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->actual_arrival)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Actual Arrival</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->actual_arrival->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                    </dl>
                </div>

                <!-- Financial Details -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Financial Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Amount</dt>
                            <dd class="mt-1 text-lg font-semibold text-gray-900">
                                {{ $transfer->currency }}{{ number_format($transfer->amount, 2) }}
                            </dd>
                        </div>
                        @if($transfer->exchange_rate)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Exchange Rate</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ number_format($transfer->exchange_rate, 4) }}</dd>
                            </div>
                        @endif
                        @if($transfer->converted_amount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Converted Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->currency }}{{ number_format($transfer->converted_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->fee_amount > 0)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Fee Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->currency }}{{ number_format($transfer->fee_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->tax_amount > 0)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Tax Amount</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->currency }}{{ number_format($transfer->tax_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->net_amount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Net Amount</dt>
                                <dd class="mt-1 text-sm font-semibold text-gray-900">
                                    {{ $transfer->currency }}{{ number_format($transfer->net_amount, 2) }}
                                </dd>
                            </div>
                        @endif
                    </dl>
                </div>

                <!-- Account Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @if($transfer->fromAccount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">From Account</dt>
                                <dd class="mt-1">
                                    <div class="text-sm text-gray-900">{{ $transfer->fromAccount->account_name }}</div>
                                    <div class="text-sm text-gray-500 font-mono">{{ $transfer->fromAccount->account_number }}</div>
                                </dd>
                            </div>
                        @endif
                        @if($transfer->toAccount)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">To Account</dt>
                                <dd class="mt-1">
                                    <div class="text-sm text-gray-900">{{ $transfer->toAccount->account_name }}</div>
                                    <div class="text-sm text-gray-500 font-mono">{{ $transfer->toAccount->account_number }}</div>
                                </dd>
                            </div>
                        @endif
                        @if($transfer->beneficiary)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Beneficiary</dt>
                                <dd class="mt-1">
                                    <div class="text-sm text-gray-900">{{ $transfer->beneficiary->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $transfer->beneficiary->email }}</div>
                                </dd>
                            </div>
                        @endif
                    </dl>
                </div>

                <!-- Description and Notes -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Description & Notes</h3>
                    <div class="space-y-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Description</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $transfer->description }}</dd>
                        </div>
                        @if($transfer->notes)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Notes</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $transfer->notes }}</dd>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- User Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">User Information</h3>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Name</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $transfer->user->name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Email</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $transfer->user->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Customer ID</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $transfer->user->customer_id }}</dd>
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Timeline</h3>
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Created</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $transfer->created_at->format('M d, Y g:i A') }}
                            </dd>
                        </div>
                        @if($transfer->processed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Processed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->processed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->completed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Completed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->completed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        @if($transfer->reversed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reversed</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $transfer->reversed_at->format('M d, Y g:i A') }}
                                </dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Last Updated</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $transfer->updated_at->format('M d, Y g:i A') }}
                            </dd>
                        </div>
                    </div>
                </div>

                <!-- Technical Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Technical Details</h3>
                    <div class="space-y-3">
                        @if($transfer->ip_address)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">IP Address</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $transfer->ip_address }}</dd>
                            </div>
                        @endif
                        @if($transfer->reversal_reason)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reversal Reason</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $transfer->reversal_reason }}</dd>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
