@extends('components.layouts.admin')

@section('title', 'System Settings')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">System Settings</h1>
            <p class="text-gray-600">Configure system status and maintenance options</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.settings.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Settings
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.settings.system.update') }}" class="space-y-6">
        @csrf
        
        <!-- System Status -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">System Status</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="maintenance_mode">Maintenance Mode</flux:label>
                    <flux:select id="maintenance_mode" name="maintenance_mode">
                        <option value="1" {{ old('maintenance_mode', $settings['maintenance_mode'] ?? false) ? 'selected' : '' }}>Enabled</option>
                        <option value="0" {{ !old('maintenance_mode', $settings['maintenance_mode'] ?? false) ? 'selected' : '' }}>Disabled</option>
                    </flux:select>
                    <flux:error name="maintenance_mode" />
                    <flux:description>Enable maintenance mode to restrict access to the system</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="debug_mode">Debug Mode</flux:label>
                    <flux:select id="debug_mode" name="debug_mode">
                        <option value="1" {{ old('debug_mode', $settings['debug_mode'] ?? false) ? 'selected' : '' }}>Enabled</option>
                        <option value="0" {{ !old('debug_mode', $settings['debug_mode'] ?? false) ? 'selected' : '' }}>Disabled</option>
                    </flux:select>
                    <flux:error name="debug_mode" />
                    <flux:description>Enable debug mode for development (not recommended for production)</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- System Optimization -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">System Optimization</flux:heading>
            <div class="space-y-4">
                <p class="text-sm text-gray-600">Use these tools to optimize your system performance and clear caches.</p>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <flux:button type="button" onclick="runOptimizeClear()" variant="outline" class="w-full justify-center">
                        <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                        Run Optimize:Clear
                    </flux:button>
                    
                    <flux:button type="button" onclick="runStorageLink()" variant="outline" class="w-full justify-center">
                        <flux:icon name="link" class="w-4 h-4 mr-2" />
                        Run Storage:Link
                    </flux:button>
                </div>
                
                <div class="text-xs text-gray-500">
                    <p><strong>Optimize:Clear</strong> - Clears all caches and optimizes the application</p>
                    <p><strong>Storage:Link</strong> - Creates symbolic links for storage directories</p>
                </div>
            </div>
        </flux:card>

        <!-- Current System Status -->
        <flux:card>
            <div class="flex justify-between items-center mb-4">
                <flux:heading size="lg">Current System Status</flux:heading>
                <flux:button type="button" onclick="refreshSystemStatus()" variant="outline" class="text-xs">
                    <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                    Refresh Status
                </flux:button>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="text-center p-4 {{ ($settings['maintenance_mode'] ?? false) ? 'bg-yellow-50 border-yellow-200' : 'bg-green-50 border-green-200' }} border rounded-lg">
                    <flux:icon name="{{ ($settings['maintenance_mode'] ?? false) ? 'exclamation-triangle' : 'check-circle' }}" class="w-8 h-8 mx-auto {{ ($settings['maintenance_mode'] ?? false) ? 'text-yellow-600' : 'text-green-600' }}" />
                    <div class="mt-2 text-sm font-medium {{ ($settings['maintenance_mode'] ?? false) ? 'text-yellow-800' : 'text-green-800' }}">
                        {{ ($settings['maintenance_mode'] ?? false) ? 'Maintenance Mode' : 'Operational' }}
                    </div>
                    <div class="text-xs {{ ($settings['maintenance_mode'] ?? false) ? 'text-yellow-600' : 'text-green-600' }} mt-1">
                        {{ ($settings['maintenance_mode'] ?? false) ? 'System is under maintenance' : 'All systems operational' }}
                    </div>
                </div>
                <div class="text-center p-4 {{ ($settings['debug_mode'] ?? false) ? 'bg-blue-50 border-blue-200' : 'bg-gray-50 border-gray-200' }} border rounded-lg">
                    <flux:icon name="bug-ant" class="w-8 h-8 mx-auto {{ ($settings['debug_mode'] ?? false) ? 'text-blue-600' : 'text-gray-600' }}" />
                    <div class="mt-2 text-sm font-medium {{ ($settings['debug_mode'] ?? false) ? 'text-blue-800' : 'text-gray-800' }}">
                        Debug {{ ($settings['debug_mode'] ?? false) ? 'On' : 'Off' }}
                    </div>
                    <div class="text-xs {{ ($settings['debug_mode'] ?? false) ? 'text-blue-600' : 'text-gray-600' }} mt-1">
                        {{ ($settings['debug_mode'] ?? false) ? 'Debug mode is enabled' : 'Debug mode is disabled' }}
                    </div>
                </div>
            </div>
            
            <!-- Environment Information -->
            <div class="mt-6 pt-4 border-t border-gray-200">
                <h4 class="text-sm font-medium text-gray-900 mb-3">Environment Information</h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-xs">
                    <div class="bg-gray-50 p-3 rounded">
                        <div class="font-medium text-gray-700">Environment</div>
                        <div class="text-gray-600">{{ config('app.env', 'unknown') }}</div>
                    </div>
                    <div class="bg-gray-50 p-3 rounded">
                        <div class="font-medium text-gray-700">Debug Mode</div>
                        <div class="text-gray-600">{{ config('app.debug') ? 'Enabled' : 'Disabled' }}</div>
                    </div>
                    <div class="bg-gray-50 p-3 rounded">
                        <div class="font-medium text-gray-700">Maintenance Mode</div>
                        <div class="text-gray-600">{{ app()->isDownForMaintenance() ? 'Active' : 'Inactive' }}</div>
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Security Recommendations -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Security Recommendations</flux:heading>
            <div class="space-y-4">
                <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                    <div class="flex">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-yellow-600 mt-0.5 mr-3" />
                        <div>
                            <h4 class="text-sm font-medium text-yellow-800">Maintenance Mode</h4>
                            <p class="text-sm text-yellow-700 mt-1">Only enable maintenance mode when performing system updates or maintenance. Remember to disable it when finished.</p>
                        </div>
                    </div>
                </div>
                <div class="p-4 bg-red-50 border border-red-200 rounded-lg">
                    <div class="flex">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-red-600 mt-0.5 mr-3" />
                        <div>
                            <h4 class="text-sm font-medium text-red-800">Debug Mode</h4>
                            <p class="text-sm text-red-700 mt-1">Never enable debug mode in production environments as it can expose sensitive information.</p>
                        </div>
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-between items-center">
            <flux:button type="button" variant="outline" onclick="resetForm()" class="text-xs">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Reset Form
            </flux:button>
            
            <div class="flex space-x-3">
                <flux:button type="button" variant="outline" href="{{ route('admin.settings.index') }}" class="text-xs">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" class="text-xs">
                    Save System Settings
                </flux:button>
            </div>
        </div>
    </form>
</div>

<script>
function resetForm() {
    if (confirm('Are you sure you want to reset the form? All unsaved changes will be lost.')) {
        document.querySelector('form').reset();
    }
}

function refreshSystemStatus() {
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Refreshing...';
    button.disabled = true;
    
    // Reload the page to get fresh status
    setTimeout(() => {
        window.location.reload();
    }, 1000);
}

function runOptimizeClear() {
    if (!confirm('This will clear all caches and optimize the application. Continue?')) {
        return;
    }
    
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Running...';
    button.disabled = true;
    
    fetch('{{ route("admin.settings.optimize-clear") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ Optimize:Clear completed successfully!\n\n' + data.message);
        } else {
            alert('❌ Optimize:Clear failed!\n\n' + data.message);
        }
    })
    .catch(error => {
        alert('❌ Optimize:Clear failed!\n\nError: ' + error.message);
    })
    .finally(() => {
        button.innerHTML = originalText;
        button.disabled = false;
    });
}

function runStorageLink() {
    if (!confirm('This will create symbolic links for storage directories. Continue?')) {
        return;
    }
    
    const button = event.target;
    const originalText = button.innerHTML;
    button.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Running...';
    button.disabled = true;
    
    fetch('{{ route("admin.settings.storage-link") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ Storage:Link completed successfully!\n\n' + data.message);
        } else {
            alert('❌ Storage:Link failed!\n\n' + data.message);
        }
    })
    .catch(error => {
        alert('❌ Storage:Link failed!\n\nError: ' + error.message);
    })
    .finally(() => {
        button.innerHTML = originalText;
        button.disabled = false;
    });
}
</script>
@endsection