@extends('components.layouts.admin')

@section('title', 'Transaction Limits')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Transaction Limits</h1>
            <p class="text-gray-600">Configure daily, monthly, and per-transaction limits</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.settings.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Settings
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.settings.limits.update') }}" class="space-y-6">
        @csrf
        
        <!-- Transfer Limits -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Transfer Limits</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="daily_transfer_limit">Daily Transfer Limit</flux:label>
                    <flux:input 
                        id="daily_transfer_limit" 
                        name="daily_transfer_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('daily_transfer_limit', $settings['daily_transfer_limit']) }}"
                        placeholder="10000.00"
                        required
                    />
                    <flux:error name="daily_transfer_limit" />
                    <flux:description>Maximum amount that can be transferred per day</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="monthly_transfer_limit">Monthly Transfer Limit</flux:label>
                    <flux:input 
                        id="monthly_transfer_limit" 
                        name="monthly_transfer_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('monthly_transfer_limit', $settings['monthly_transfer_limit']) }}"
                        placeholder="100000.00"
                        required
                    />
                    <flux:error name="monthly_transfer_limit" />
                    <flux:description>Maximum amount that can be transferred per month</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- Withdrawal Limits -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Withdrawal Limits</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="daily_withdrawal_limit">Daily Withdrawal Limit</flux:label>
                    <flux:input 
                        id="daily_withdrawal_limit" 
                        name="daily_withdrawal_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('daily_withdrawal_limit', $settings['daily_withdrawal_limit']) }}"
                        placeholder="5000.00"
                        required
                    />
                    <flux:error name="daily_withdrawal_limit" />
                    <flux:description>Maximum amount that can be withdrawn per day</flux:description>
                </flux:field>

                <flux:field>
                    <flux:label for="monthly_withdrawal_limit">Monthly Withdrawal Limit</flux:label>
                    <flux:input 
                        id="monthly_withdrawal_limit" 
                        name="monthly_withdrawal_limit" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('monthly_withdrawal_limit', $settings['monthly_withdrawal_limit']) }}"
                        placeholder="50000.00"
                        required
                    />
                    <flux:error name="monthly_withdrawal_limit" />
                    <flux:description>Maximum amount that can be withdrawn per month</flux:description>
                </flux:field>
            </div>
        </flux:card>

        <!-- Current Limits Summary -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Current Limits Summary</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                <div class="text-center p-4 bg-blue-50 rounded-lg">
                    <div class="text-2xl font-bold text-blue-600">${{ number_format($settings['daily_transfer_limit'], 2) }}</div>
                    <div class="text-sm text-blue-700">Daily Transfer Limit</div>
                </div>
                <div class="text-center p-4 bg-green-50 rounded-lg">
                    <div class="text-2xl font-bold text-green-600">${{ number_format($settings['monthly_transfer_limit'], 2) }}</div>
                    <div class="text-sm text-green-700">Monthly Transfer Limit</div>
                </div>
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-between items-center">
            <flux:button type="button" variant="outline" onclick="resetForm()" class="text-xs">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Reset Form
            </flux:button>
            
            <div class="flex space-x-3">
                <flux:button type="button" variant="outline" href="{{ route('admin.settings.index') }}" class="text-xs">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" class="text-xs">
                    Save Transaction Limits
                </flux:button>
            </div>
        </div>
    </form>
</div>

<script>
function resetForm() {
    if (confirm('Are you sure you want to reset the form? All unsaved changes will be lost.')) {
        document.querySelector('form').reset();
    }
}

// Auto-format currency inputs
document.querySelectorAll('input[type="number"]').forEach(input => {
    input.addEventListener('blur', function() {
        if (this.value && !isNaN(this.value)) {
            this.value = parseFloat(this.value).toFixed(2);
        }
    });
});
</script>
@endsection
