@extends('components.layouts.admin')

@section('title', 'Compliance Settings')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Compliance Settings</h1>
            <p class="text-gray-600">Configure KYC, AML, and regulatory compliance requirements</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.settings.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Settings
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.settings.compliance.update') }}" class="space-y-6">
        @csrf
        
        <!-- KYC Settings -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">KYC (Know Your Customer) Settings</flux:heading>
            <div class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <flux:field>
                        <flux:label for="kyc_required">KYC Required</flux:label>
                        <flux:select id="kyc_required" name="kyc_required">
                            <option value="1" {{ old('kyc_required', $settings['kyc_required']) ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ !old('kyc_required', $settings['kyc_required']) ? 'selected' : '' }}>No</option>
                        </flux:select>
                        <flux:error name="kyc_required" />
                        <flux:description>Require KYC verification for all customers</flux:description>
                    </flux:field>

                    <flux:field>
                        <flux:label for="kyc_verification_required">KYC Verification Required</flux:label>
                        <flux:select id="kyc_verification_required" name="kyc_verification_required">
                            <option value="1" {{ old('kyc_verification_required', $settings['kyc_verification_required']) ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ !old('kyc_verification_required', $settings['kyc_verification_required']) ? 'selected' : '' }}>No</option>
                        </flux:select>
                        <flux:error name="kyc_verification_required" />
                        <flux:description>Require manual verification of KYC documents</flux:description>
                    </flux:field>
                </div>
            </div>
        </flux:card>

        <!-- AML Settings -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">AML (Anti-Money Laundering) Settings</flux:heading>
            <div class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <flux:field>
                        <flux:label for="aml_monitoring">AML Monitoring</flux:label>
                        <flux:select id="aml_monitoring" name="aml_monitoring">
                            <option value="1" {{ old('aml_monitoring', $settings['aml_monitoring']) ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !old('aml_monitoring', $settings['aml_monitoring']) ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="aml_monitoring" />
                        <flux:description>Enable anti-money laundering monitoring</flux:description>
                    </flux:field>

                    <flux:field>
                        <flux:label for="transaction_monitoring">Transaction Monitoring</flux:label>
                        <flux:select id="transaction_monitoring" name="transaction_monitoring">
                            <option value="1" {{ old('transaction_monitoring', $settings['transaction_monitoring']) ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !old('transaction_monitoring', $settings['transaction_monitoring']) ? 'selected' : '' }}>Disabled</option>
                        </flux:select>
                        <flux:error name="transaction_monitoring" />
                        <flux:description>Monitor transactions for suspicious activity</flux:description>
                    </flux:field>
                </div>

                <flux:field>
                    <flux:label for="suspicious_activity_threshold">Suspicious Activity Threshold</flux:label>
                    <flux:input 
                        id="suspicious_activity_threshold" 
                        name="suspicious_activity_threshold" 
                        type="number"
                        step="0.01"
                        min="0"
                        value="{{ old('suspicious_activity_threshold', $settings['suspicious_activity_threshold']) }}"
                        placeholder="10000.00"
                        required
                    />
                    <flux:error name="suspicious_activity_threshold" />
                    <flux:description>Amount threshold for flagging suspicious activity</flux:description>
                </flux:field>
            </div>
        </flux:card>
        <!-- Current Compliance Status -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Current Compliance Status</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                <div class="text-center p-4 {{ $settings['kyc_required'] ? 'bg-green-50' : 'bg-red-50' }} rounded-lg">
                    <flux:icon name="{{ $settings['kyc_required'] ? 'check-circle' : 'x-circle' }}" class="w-8 h-8 mx-auto {{ $settings['kyc_required'] ? 'text-green-600' : 'text-red-600' }}" />
                    <div class="mt-2 text-sm font-medium {{ $settings['kyc_required'] ? 'text-green-800' : 'text-red-800' }}">
                        KYC {{ $settings['kyc_required'] ? 'Required' : 'Not Required' }}
                    </div>
                </div>
                <div class="text-center p-4 {{ $settings['aml_monitoring'] ? 'bg-green-50' : 'bg-red-50' }} rounded-lg">
                    <flux:icon name="{{ $settings['aml_monitoring'] ? 'check-circle' : 'x-circle' }}" class="w-8 h-8 mx-auto {{ $settings['aml_monitoring'] ? 'text-green-600' : 'text-red-600' }}" />
                    <div class="mt-2 text-sm font-medium {{ $settings['aml_monitoring'] ? 'text-green-800' : 'text-red-800' }}">
                        AML {{ $settings['aml_monitoring'] ? 'Enabled' : 'Disabled' }}
                    </div>
                </div>
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-between items-center">
            <flux:button type="button" variant="outline" onclick="resetForm()" class="text-xs">
                <flux:icon name="arrow-path" class="w-4 h-4 mr-2" />
                Reset Form
            </flux:button>
            
            <div class="flex space-x-3">
                <flux:button type="button" variant="outline" href="{{ route('admin.settings.index') }}" class="text-xs">
                    Cancel
                </flux:button>
                <flux:button icon="check" type="submit" class="text-xs">
                    Save Compliance Settings
                </flux:button>
            </div>
        </div>
    </form>
</div>

<script>
function resetForm() {
    if (confirm('Are you sure you want to reset the form? All unsaved changes will be lost.')) {
        document.querySelector('form').reset();
    }
}

// Auto-format currency inputs
document.querySelectorAll('input[type="number"]').forEach(input => {
    input.addEventListener('blur', function() {
        if (this.value && !isNaN(this.value)) {
            this.value = parseFloat(this.value).toFixed(2);
        }
    });
});
</script>
@endsection
