@extends('components.layouts.admin')

@section('title', 'Transaction Reports')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Transaction Reports</h1>
            <p class="text-gray-600">Transaction volume analysis and financial insights</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.reports.export.transactions', request()->query()) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export CSV
            </flux:button>
            <flux:button href="{{ route('admin.reports.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Reports
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Start Date -->
                <div>
                    <flux:label for="start_date">Start Date</flux:label>
                    <flux:date-picker 
                        id="start_date" 
                        name="start_date" 
                        value="{{ $startDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- End Date -->
                <div>
                    <flux:label for="end_date">End Date</flux:label>
                    <flux:date-picker 
                        id="end_date" 
                        name="end_date" 
                        value="{{ $endDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- Group By -->
                <div>
                    <flux:label for="group_by">Group By</flux:label>
                    <flux:select id="group_by" name="group_by">
                        <option value="day" {{ $groupBy === 'day' ? 'selected' : '' }}>Day</option>
                        <option value="week" {{ $groupBy === 'week' ? 'selected' : '' }}>Week</option>
                        <option value="month" {{ $groupBy === 'month' ? 'selected' : '' }}>Month</option>
                        <option value="year" {{ $groupBy === 'year' ? 'selected' : '' }}>Year</option>
                    </flux:select>
                </div>

                <!-- Filter Button -->
                <div class="flex items-end">
                    <flux:button type="submit" variant="primary" class="text-xs">
                        <flux:icon name="magnifying-glass" class="w-4 h-4 mr-2" />
                        Apply Filters
                    </flux:button>
                </div>
            </div>
        </form>
    </flux:card>

    <!-- Volume Summary -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="arrow-path" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Transactions</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($volumeReport->sum('count')) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="currency-dollar" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Volume</p>
                    <p class="text-2xl font-semibold text-gray-900">${{ number_format($volumeReport->sum('total_amount'), 2) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="chart-bar" class="w-8 h-8 text-purple-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Average Amount</p>
                    <p class="text-2xl font-semibold text-gray-900">${{ number_format($volumeReport->avg('avg_amount'), 2) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Transaction Volume Trends -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Transaction Volume Trends</flux:heading>
            @if($volumeReport->count() > 0)
                <div class="space-y-3">
                    @foreach($volumeReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->period)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-4">
                                <div class="text-right">
                                    <div class="text-sm font-medium text-gray-900">{{ number_format($data->count) }}</div>
                                    <div class="text-xs text-gray-500">transactions</div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium text-gray-900">${{ number_format($data->total_amount, 2) }}</div>
                                    <div class="text-xs text-gray-500">volume</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No transaction data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- Transaction Type Breakdown -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Transaction Type Breakdown</flux:heading>
            @if($typeReport->count() > 0)
                <div class="space-y-3">
                    @foreach($typeReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ ucfirst(str_replace('_', ' ', $data->type)) }}
                            </span>
                            <div class="flex items-center space-x-4">
                                <div class="text-right">
                                    <div class="text-sm font-medium text-gray-900">{{ number_format($data->count) }}</div>
                                    <div class="text-xs text-gray-500">count</div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-medium text-gray-900">${{ number_format($data->total_amount, 2) }}</div>
                                    <div class="text-xs text-gray-500">volume</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No transaction type data available for the selected period.</p>
            @endif
        </flux:card>
    </div>

    <!-- Transaction Status Analysis -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Transaction Status Analysis</flux:heading>
        @if($statusReport->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                @foreach($statusReport as $data)
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-gray-900">{{ number_format($data->count) }}</div>
                        <div class="text-sm text-gray-500">{{ ucfirst($data->status) }}</div>
                        <div class="text-xs text-gray-400 mt-1">${{ number_format($data->total_amount, 2) }} volume</div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No transaction status data available for the selected period.</p>
        @endif
    </flux:card>

    <!-- Top Transaction Types -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Top Transaction Types by Volume</flux:heading>
        @if($typeReport->count() > 0)
            <div class="space-y-4">
                @foreach($typeReport->take(5) as $data)
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-900">
                            {{ ucfirst(str_replace('_', ' ', $data->type)) }}
                        </span>
                        <div class="flex items-center space-x-2">
                            <div class="w-48 bg-gray-200 rounded-full h-2">
                                <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($data->total_amount / $typeReport->max('total_amount')) * 100 }}%"></div>
                            </div>
                            <span class="text-sm text-gray-500 w-20 text-right">${{ number_format($data->total_amount, 2) }}</span>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-sm text-gray-500">No transaction type data available for the selected period.</p>
        @endif
    </flux:card>
</div>
@endsection
