@extends('components.layouts.admin')

@section('title', 'KYC Reports')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">KYC Reports</h1>
            <p class="text-gray-600">KYC document submission trends and verification analytics</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.reports.export.kyc', request()->query()) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export CSV
            </flux:button>
            <flux:button href="{{ route('admin.reports.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Reports
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Start Date -->
                <div>
                    <flux:label for="start_date">Start Date</flux:label>
                    <flux:date-picker 
                        id="start_date" 
                        name="start_date" 
                        value="{{ $startDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- End Date -->
                <div>
                    <flux:label for="end_date">End Date</flux:label>
                    <flux:date-picker 
                        id="end_date" 
                        name="end_date" 
                        value="{{ $endDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- Group By -->
                <div>
                    <flux:label for="group_by">Group By</flux:label>
                    <flux:select id="group_by" name="group_by">
                        <option value="day" {{ $groupBy === 'day' ? 'selected' : '' }}>Day</option>
                        <option value="week" {{ $groupBy === 'week' ? 'selected' : '' }}>Week</option>
                        <option value="month" {{ $groupBy === 'month' ? 'selected' : '' }}>Month</option>
                        <option value="year" {{ $groupBy === 'year' ? 'selected' : '' }}>Year</option>
                    </flux:select>
                </div>

                <!-- Filter Button -->
                <div class="flex items-end">
                    <flux:button type="submit" variant="primary" class="text-xs">
                        <flux:icon name="magnifying-glass" class="w-4 h-4 mr-2" />
                        Apply Filters
                    </flux:button>
                </div>
            </div>
        </form>
    </flux:card>

    <!-- Status Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="identification" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Documents</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['total_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="clock" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['pending_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Approved</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['approved_documents']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="x-circle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Rejected</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['rejected_documents']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- KYC Submission Trends -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">KYC Submission Trends</flux:heading>
            @if($submissionReport->count() > 0)
                <div class="space-y-3">
                    @foreach($submissionReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->period)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-orange-600 h-2 rounded-full" style="width: {{ ($data->count / $submissionReport->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No KYC submission data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- Document Status Breakdown -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Document Status Breakdown</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Approved</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: {{ ($statusReport['approved_documents'] / $statusReport['total_documents']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['approved_documents']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Pending</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-yellow-600 h-2 rounded-full" style="width: {{ ($statusReport['pending_documents'] / $statusReport['total_documents']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['pending_documents']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Rejected</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-red-600 h-2 rounded-full" style="width: {{ ($statusReport['rejected_documents'] / $statusReport['total_documents']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['rejected_documents']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Expired</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-gray-600 h-2 rounded-full" style="width: {{ ($statusReport['expired_documents'] / $statusReport['total_documents']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['expired_documents']) }}</span>
                    </div>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Document Type Distribution -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Document Type Distribution</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <div class="text-center p-4 bg-blue-50 rounded-lg">
                <flux:icon name="identification" class="w-8 h-8 text-blue-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-blue-900">{{ number_format($statusReport['passport_documents']) }}</div>
                <div class="text-sm text-blue-700">Passport</div>
            </div>
            <div class="text-center p-4 bg-green-50 rounded-lg">
                <flux:icon name="credit-card" class="w-8 h-8 text-green-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-green-900">{{ number_format($statusReport['drivers_license']) }}</div>
                <div class="text-sm text-green-700">Driver's License</div>
            </div>
            <div class="text-center p-4 bg-purple-50 rounded-lg">
                <flux:icon name="id-card" class="w-8 h-8 text-purple-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-purple-900">{{ number_format($statusReport['national_id']) }}</div>
                <div class="text-sm text-purple-700">National ID</div>
            </div>
            <div class="text-center p-4 bg-yellow-50 rounded-lg">
                <flux:icon name="document-text" class="w-8 h-8 text-yellow-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-yellow-900">{{ number_format($statusReport['utility_bill']) }}</div>
                <div class="text-sm text-yellow-700">Utility Bill</div>
            </div>
            <div class="text-center p-4 bg-red-50 rounded-lg">
                <flux:icon name="banknotes" class="w-8 h-8 text-red-600 mx-auto mb-2" />
                <div class="text-xl font-bold text-red-900">{{ number_format($statusReport['bank_statement']) }}</div>
                <div class="text-sm text-red-700">Bank Statement</div>
            </div>
        </div>
    </flux:card>

    <!-- Approval Rate Analysis -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Approval Rate Analysis</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center p-6 bg-green-50 rounded-lg">
                <div class="text-3xl font-bold text-green-900">
                    {{ number_format(($statusReport['approved_documents'] / $statusReport['total_documents']) * 100, 1) }}%
                </div>
                <div class="text-sm text-green-700">Overall Approval Rate</div>
                <div class="text-xs text-green-600 mt-1">
                    {{ number_format($statusReport['approved_documents']) }} of {{ number_format($statusReport['total_documents']) }} documents
                </div>
            </div>
            <div class="text-center p-6 bg-yellow-50 rounded-lg">
                <div class="text-3xl font-bold text-yellow-900">
                    {{ number_format(($statusReport['pending_documents'] / $statusReport['total_documents']) * 100, 1) }}%
                </div>
                <div class="text-sm text-yellow-700">Pending Rate</div>
                <div class="text-xs text-yellow-600 mt-1">
                    {{ number_format($statusReport['pending_documents']) }} documents awaiting review
                </div>
            </div>
            <div class="text-center p-6 bg-red-50 rounded-lg">
                <div class="text-3xl font-bold text-red-900">
                    {{ number_format(($statusReport['rejected_documents'] / $statusReport['total_documents']) * 100, 1) }}%
                </div>
                <div class="text-sm text-red-700">Rejection Rate</div>
                <div class="text-xs text-red-600 mt-1">
                    {{ number_format($statusReport['rejected_documents']) }} documents rejected
                </div>
            </div>
        </div>
    </flux:card>
</div>
@endsection
