@extends('components.layouts.admin')

@section('title', 'Account Reports')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Account Reports</h1>
            <p class="text-gray-600">Account creation trends and status analytics</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.reports.export.accounts', request()->query()) }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-down-tray" class="w-4 h-4 mr-2" />
                Export CSV
            </flux:button>
            <flux:button href="{{ route('admin.reports.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Reports
            </flux:button>
        </div>
    </div>

    <!-- Filters -->
    <flux:card>
        <form method="GET" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- Start Date -->
                <div>
                    <flux:label for="start_date">Start Date</flux:label>
                    <flux:date-picker 
                        id="start_date" 
                        name="start_date" 
                        value="{{ $startDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- End Date -->
                <div>
                    <flux:label for="end_date">End Date</flux:label>
                    <flux:date-picker 
                        id="end_date" 
                        name="end_date" 
                        value="{{ $endDate }}"
                        selectable-header
                        class="text-xs"
                    />
                </div>

                <!-- Group By -->
                <div>
                    <flux:label for="group_by">Group By</flux:label>
                    <flux:select id="group_by" name="group_by">
                        <option value="day" {{ $groupBy === 'day' ? 'selected' : '' }}>Day</option>
                        <option value="week" {{ $groupBy === 'week' ? 'selected' : '' }}>Week</option>
                        <option value="month" {{ $groupBy === 'month' ? 'selected' : '' }}>Month</option>
                        <option value="year" {{ $groupBy === 'year' ? 'selected' : '' }}>Year</option>
                    </flux:select>
                </div>

                <!-- Filter Button -->
                <div class="flex items-end">
                    <flux:button type="submit" variant="primary" class="text-xs">
                        <flux:icon name="magnifying-glass" class="w-4 h-4 mr-2" />
                        Apply Filters
                    </flux:button>
                </div>
            </div>
        </form>
    </flux:card>

    <!-- Status Summary -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="credit-card" class="w-8 h-8 text-blue-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Accounts</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['total_accounts']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="check-circle" class="w-8 h-8 text-green-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Active Accounts</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['active_accounts']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="pause-circle" class="w-8 h-8 text-yellow-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Suspended</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['suspended_accounts']) }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <flux:icon name="x-circle" class="w-8 h-8 text-red-600" />
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Closed</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($statusReport['closed_accounts']) }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Account Creation Trends Chart -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Account Creation Trends</flux:heading>
            @if($creationReport->count() > 0)
                <div class="space-y-3">
                    @foreach($creationReport as $data)
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-medium text-gray-900">
                                {{ \Carbon\Carbon::parse($data->period)->format('M j, Y') }}
                            </span>
                            <div class="flex items-center space-x-2">
                                <div class="w-32 bg-gray-200 rounded-full h-2">
                                    <div class="bg-green-600 h-2 rounded-full" style="width: {{ ($data->count / $creationReport->max('count')) * 100 }}%"></div>
                                </div>
                                <span class="text-sm text-gray-500 w-12 text-right">{{ $data->count }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No account creation data available for the selected period.</p>
            @endif
        </flux:card>

        <!-- Account Type Distribution -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Account Type Distribution</flux:heading>
            <div class="space-y-4">
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Savings Accounts</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full" style="width: {{ ($statusReport['savings_accounts'] / $statusReport['total_accounts']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['savings_accounts']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Checking Accounts</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-green-600 h-2 rounded-full" style="width: {{ ($statusReport['checking_accounts'] / $statusReport['total_accounts']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['checking_accounts']) }}</span>
                    </div>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-sm text-gray-700">Business Accounts</span>
                    <div class="flex items-center space-x-2">
                        <div class="w-24 bg-gray-200 rounded-full h-2">
                            <div class="bg-purple-600 h-2 rounded-full" style="width: {{ ($statusReport['business_accounts'] / $statusReport['total_accounts']) * 100 }}%"></div>
                        </div>
                        <span class="text-sm font-medium text-gray-900">{{ number_format($statusReport['business_accounts']) }}</span>
                    </div>
                </div>
            </div>
        </flux:card>
    </div>

    <!-- Account Status Breakdown -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Account Status Breakdown</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center p-6 bg-green-50 rounded-lg">
                <flux:icon name="check-circle" class="w-12 h-12 text-green-600 mx-auto mb-2" />
                <div class="text-2xl font-bold text-green-900">{{ number_format($statusReport['active_accounts']) }}</div>
                <div class="text-sm text-green-700">Active Accounts</div>
                <div class="text-xs text-green-600 mt-1">
                    {{ number_format(($statusReport['active_accounts'] / $statusReport['total_accounts']) * 100, 1) }}% of total
                </div>
            </div>
            <div class="text-center p-6 bg-yellow-50 rounded-lg">
                <flux:icon name="pause-circle" class="w-12 h-12 text-yellow-600 mx-auto mb-2" />
                <div class="text-2xl font-bold text-yellow-900">{{ number_format($statusReport['suspended_accounts']) }}</div>
                <div class="text-sm text-yellow-700">Suspended Accounts</div>
                <div class="text-xs text-yellow-600 mt-1">
                    {{ number_format(($statusReport['suspended_accounts'] / $statusReport['total_accounts']) * 100, 1) }}% of total
                </div>
            </div>
            <div class="text-center p-6 bg-red-50 rounded-lg">
                <flux:icon name="x-circle" class="w-12 h-12 text-red-600 mx-auto mb-2" />
                <div class="text-2xl font-bold text-red-900">{{ number_format($statusReport['closed_accounts']) }}</div>
                <div class="text-sm text-red-700">Closed Accounts</div>
                <div class="text-xs text-red-600 mt-1">
                    {{ number_format(($statusReport['closed_accounts'] / $statusReport['total_accounts']) * 100, 1) }}% of total
                </div>
            </div>
        </div>
    </flux:card>
</div>
@endsection
