@extends('components.layouts.admin')

@section('title', 'Edit Admin Profile')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Edit Profile</h1>
            <p class="text-gray-600">Update your profile information and settings</p>
        </div>
        <div class="flex space-x-3">
            <flux:button icon="arrow-left" href="{{ route('admin.profile.show') }}" variant="outline" class="text-xs">
                Back to Profile
            </flux:button>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.profile.update') }}" enctype="multipart/form-data" class="space-y-6">
        @csrf
        @method('PUT')
        
        <!-- Basic Information -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="name">Full Name</flux:label>
                    <flux:input 
                        id="name" 
                        name="name" 
                        value="{{ old('name', $admin->name) }}"
                        placeholder="Enter your full name"
                        required
                    />
                    <flux:error name="name" />
                </flux:field>

                <flux:field>
                    <flux:label for="email">Email Address</flux:label>
                    <flux:input 
                        id="email" 
                        name="email" 
                        type="email"
                        value="{{ old('email', $admin->email) }}"
                        placeholder="Enter your email address"
                        required
                    />
                    <flux:error name="email" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Password Change -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Change Password</flux:heading>
            <p class="text-sm text-gray-600 mb-4">Leave blank to keep current password</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <flux:field>
                    <flux:label for="current_password">Current Password</flux:label>
                    <flux:input 
                        id="current_password" 
                        name="current_password" 
                        type="password"
                        placeholder="Enter current password"
                    />
                    <flux:error name="current_password" />
                </flux:field>

                <flux:field>
                    <flux:label for="password">New Password</flux:label>
                    <flux:input 
                        id="password" 
                        name="password" 
                        type="password"
                        placeholder="Enter new password"
                    />
                    <flux:error name="password" />
                </flux:field>

                <flux:field>
                    <flux:label for="password_confirmation">Confirm New Password</flux:label>
                    <flux:input 
                        id="password_confirmation" 
                        name="password_confirmation" 
                        type="password"
                        placeholder="Confirm new password"
                    />
                    <flux:error name="password_confirmation" />
                </flux:field>
            </div>
        </flux:card>

        <!-- Actions -->
        <div class="flex justify-end space-x-3">
            <flux:button icon="arrow-left" href="{{ route('admin.profile.show') }}" variant="outline">
                Cancel
            </flux:button>
            <flux:button icon="check" type="submit" class="text-xs">
                Update Profile
            </flux:button>
        </div>
    </form>
</div>
@endsection
