@extends('components.layouts.admin')

@section('title', 'Permission Statistics')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Permission Statistics</h1>
            <p class="text-gray-600">Analytics and insights for system permissions</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Permissions
            </flux:button>
            <flux:button href="{{ route('admin.roles.statistics') }}" variant="outline" class="text-xs">
                <flux:icon name="shield-check" class="w-4 h-4 mr-2" />
                Role Statistics
            </flux:button>
        </div>
    </div>

    <!-- Overview Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-500 rounded-lg flex items-center justify-center">
                        <flux:icon name="key" class="w-5 h-5 text-white" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Permissions</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['total_permissions'] }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-500 rounded-lg flex items-center justify-center">
                        <flux:icon name="shield-check" class="w-5 h-5 text-white" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total Roles</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['total_roles'] }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-yellow-500 rounded-lg flex items-center justify-center">
                        <flux:icon name="check-circle" class="w-5 h-5 text-white" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Assigned Permissions</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['permissions_with_roles'] }}</p>
                </div>
            </div>
        </flux:card>

        <flux:card>
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-red-500 rounded-lg flex items-center justify-center">
                        <flux:icon name="exclamation-triangle" class="w-5 h-5 text-white" />
                    </div>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Unassigned Permissions</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $stats['permissions_without_roles'] }}</p>
                </div>
            </div>
        </flux:card>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Most Used Permission -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Most Used Permission</flux:heading>
            @if($stats['most_used_permission'])
                <div class="flex items-center p-4 bg-blue-50 border border-blue-200 rounded-lg">
                    <div class="flex-shrink-0">
                        <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center">
                            <flux:icon name="key" class="w-6 h-6 text-white" />
                        </div>
                    </div>
                    <div class="ml-4 flex-1">
                        <div class="text-lg font-semibold text-gray-900">
                            {{ ucfirst(str_replace('-', ' ', $stats['most_used_permission']->name)) }}
                        </div>
                        <div class="text-sm text-gray-500">{{ $stats['most_used_permission']->name }}</div>
                        <div class="text-sm text-blue-600 font-medium">
                            Assigned to {{ $stats['most_used_permission']->roles_count }} role(s)
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-8 text-gray-500">
                    <flux:icon name="key" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                    <p>No permission data available</p>
                </div>
            @endif
        </flux:card>

        <!-- Permissions by Category -->
        <flux:card>
            <flux:heading size="lg" class="mb-4">Permissions by Category</flux:heading>
            <div class="space-y-3">
                @foreach($stats['permissions_by_category'] as $category => $count)
                    <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                                <span class="text-xs font-bold text-white">{{ substr($category, 0, 1) }}</span>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-900 capitalize">{{ str_replace('-', ' ', $category) }}</div>
                                <div class="text-xs text-gray-500">{{ $category }}-*</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-lg font-bold text-gray-900">{{ $count }}</div>
                            <div class="text-xs text-gray-500">permissions</div>
                        </div>
                    </div>
                @endforeach
            </div>
        </flux:card>
    </div>

    <!-- Roles by Permissions -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Roles by Permission Count</flux:heading>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Permissions</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Users</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Created</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($stats['roles_by_permissions'] as $role)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-lg bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                            <flux:icon name="shield-check" class="w-6 h-6 text-white" />
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">
                                            {{ ucfirst(str_replace('-', ' ', $role->name)) }}
                                        </div>
                                        <div class="text-sm text-gray-500">{{ $role->name }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        {{ $role->permissions_count }} permissions
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        {{ $role->users->count() }} users
                                    </span>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ $role->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <flux:button href="{{ route('admin.roles.show', $role) }}" variant="outline" size="sm">
                                    <flux:icon name="eye" class="w-4 h-4" />
                                </flux:button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </flux:card>

    <!-- Quick Actions -->
    <flux:card>
        <flux:heading size="lg" class="mb-4">Quick Actions</flux:heading>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <flux:button href="{{ route('admin.permissions.create') }}" class="w-full">
                <flux:icon name="plus" class="w-4 h-4 mr-2" />
                Create New Permission
            </flux:button>
            <flux:button href="{{ route('admin.roles.create') }}" variant="outline" class="w-full">
                <flux:icon name="shield-check" class="w-4 h-4 mr-2" />
                Create New Role
            </flux:button>
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="w-full">
                <flux:icon name="list-bullet" class="w-4 h-4 mr-2" />
                View All Permissions
            </flux:button>
        </div>
    </flux:card>
</div>
@endsection
