@extends('components.layouts.admin')

@section('title', 'Permission Details')

@section('content')
<div class="space-y-6">
    <!-- Success Message -->
    @if (session('success'))
        <x-admin.message type="success">
            {{ session('success') }}
        </x-admin.message>
    @endif

    <!-- Error Message -->
    @if (session('error'))
        <x-admin.message type="error">
            {{ session('error') }}
        </x-admin.message>
    @endif

    <!-- Header -->
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Permission Details</h1>
            <p class="text-gray-600">View and manage permission information and assignments</p>
        </div>
        <div class="flex space-x-3">
            <flux:button href="{{ route('admin.permissions.index') }}" variant="outline" class="text-xs">
                <flux:icon name="arrow-left" class="w-4 h-4 mr-2" />
                Back to Permissions
            </flux:button>
            <flux:button href="{{ route('admin.permissions.edit', $permission) }}" class="text-xs">
                <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                Edit Permission
            </flux:button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Permission Information -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Basic Information</flux:heading>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Permission Name</label>
                        <div class="flex items-center space-x-2">
                            <span class="text-lg font-semibold text-gray-900">{{ ucfirst(str_replace('-', ' ', $permission->name)) }}</span>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                {{ $permission->name }}
                            </span>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800 capitalize">
                            {{ str_replace('-', ' ', explode('-', $permission->name)[0]) }}
                        </span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Guard Name</label>
                        <span class="text-lg font-semibold text-gray-900">{{ $permission->guard_name }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Created</label>
                        <span class="text-sm text-gray-900">{{ $permission->created_at->format('M d, Y H:i') }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Last Updated</label>
                        <span class="text-sm text-gray-900">{{ $permission->updated_at->format('M d, Y H:i') }}</span>
                    </div>
                </div>
            </flux:card>

            <!-- Roles with this Permission -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Roles with this Permission ({{ $permission->roles->count() }})</flux:heading>
                @if($permission->roles->count() > 0)
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                        @foreach($permission->roles as $role)
                            <div class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <flux:icon name="shield-check" class="w-5 h-5 text-blue-500 mr-3" />
                                <div>
                                    <div class="text-sm font-medium text-gray-900">
                                        {{ ucfirst(str_replace('-', ' ', $role->name)) }}
                                    </div>
                                    <div class="text-xs text-gray-500">{{ $role->name }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <flux:icon name="shield-check" class="w-12 h-12 mx-auto mb-4 text-gray-300" />
                        <p>No roles assigned to this permission.</p>
                    </div>
                @endif
            </flux:card>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Statistics -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Statistics</flux:heading>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Total Roles</span>
                        <span class="text-lg font-bold text-gray-900">{{ $permission->roles->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Total Users</span>
                        <span class="text-lg font-bold text-gray-900">{{ $permission->users->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-500">Created</span>
                        <span class="text-sm text-gray-900">{{ $permission->created_at->format('M d, Y') }}</span>
                    </div>
                </div>
            </flux:card>

            <!-- Quick Actions -->
            <flux:card>
                <flux:heading size="lg" class="mb-4">Quick Actions</flux:heading>
                <div class="space-y-3">
                    <flux:button href="{{ route('admin.permissions.edit', $permission) }}" class="w-full">
                        <flux:icon name="pencil" class="w-4 h-4 mr-2" />
                        Edit Permission
                    </flux:button>
                    <flux:button href="{{ route('admin.roles.index') }}" variant="outline" class="w-full">
                        <flux:icon name="shield-check" class="w-4 h-4 mr-2" />
                        Manage Roles
                    </flux:button>
                    @if($permission->roles->count() == 0)
                        <form method="POST" action="{{ route('admin.permissions.destroy', $permission) }}" onsubmit="return confirm('Are you sure you want to delete this permission?')">
                            @csrf
                            @method('DELETE')
                            <flux:button type="submit" variant="outline" class="w-full text-red-600 hover:text-red-700">
                                <flux:icon name="trash" class="w-4 h-4 mr-2" />
                                Delete Permission
                            </flux:button>
                        </form>
                    @else
                        <flux:button disabled variant="outline" class="w-full text-gray-400 cursor-not-allowed" title="Cannot delete permission assigned to roles">
                            <flux:icon name="trash" class="w-4 h-4 mr-2" />
                            Delete Permission
                        </flux:button>
                    @endif
                </div>
            </flux:card>
        </div>
    </div>

    <!-- Roles with this Permission (Detailed) -->
    @if($roles->count() > 0)
        <flux:card>
            <flux:heading size="lg" class="mb-4">Roles with this Permission ({{ $roles->total() }})</flux:heading>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Role</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Guard</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Users</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Created</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($roles as $role)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10">
                                            <div class="h-10 w-10 rounded-lg bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center">
                                                <flux:icon name="shield-check" class="w-6 h-6 text-white" />
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900">{{ ucfirst(str_replace('-', ' ', $role->name)) }}</div>
                                            <div class="text-sm text-gray-500">{{ $role->name }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $role->guard_name }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        {{ $role->users->count() }} users
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $role->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <flux:button href="{{ route('admin.roles.show', $role) }}" variant="outline" size="sm">
                                        <flux:icon name="eye" class="w-4 h-4" />
                                    </flux:button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($roles->hasPages())
                <div class="px-6 py-4 border-t border-gray-200">
                    {{ $roles->links() }}
                </div>
            @endif
        </flux:card>
    @endif
</div>
@endsection
