@extends('components.layouts.admin')

@section('title', 'KYC Document Details')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">KYC Document Details</h1>
                <p class="text-gray-600">{{ $kyc->document_type_label }} - {{ $kyc->user->name }}</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="pencil" href="{{ route('admin.kyc.edit', $kyc) }}" variant="outline">
                    Edit Document
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.kyc.index') }}" variant="outline">
                    Back to KYC
                </flux:button>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Document Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Information</h3>
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Document Type</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $kyc->document_type_label }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Document Name</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $kyc->document_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Name</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $kyc->file_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Size</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $kyc->file_size_human }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">MIME Type</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $kyc->mime_type }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Uploaded</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $kyc->created_at->format('M d, Y H:i') }}</dd>
                        </div>
                    </dl>
                </div>

                <!-- Document Preview -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Preview</h3>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-8 text-center">
                        @if($kyc->mime_type && str_starts_with($kyc->mime_type, 'image/'))
                            <img 
                                src="{{asset($kyc->file_path) }}" 
                                alt="Document Preview" 
                                class="max-w-full max-h-96 mx-auto rounded-lg shadow-sm"
                                onclick="openImageModal('{{ Storage::url($kyc->file_path) }}', '{{ $kyc->document_name }}')"
                                style="cursor: pointer;"
                            />
                            <p class="mt-2 text-sm text-gray-500">Click to view full size</p>
                        @elseif($kyc->mime_type === 'application/pdf')
                            <div class="flex flex-col items-center">
                                <flux:icon name="document-text" class="w-16 h-16 text-red-500 mb-4" />
                                <p class="text-lg font-medium text-gray-900">PDF Document</p>
                                <p class="text-sm text-gray-500">{{ $kyc->file_name }}</p>
                                <div class="mt-4 flex space-x-3">
                                    <flux:button 
                                        href="{{ route('admin.kyc.view', $kyc) }}" 
                                        target="_blank"
                                        variant="primary"
                                    >
                                        View PDF
                                    </flux:button>
                                    <flux:button 
                                        href="{{ route('admin.kyc.download', $kyc) }}" 
                                        variant="outline"
                                    >
                                        Download
                                    </flux:button>
                                </div>
                            </div>
                        @else
                            <div class="flex flex-col items-center">
                                <flux:icon name="document" class="w-16 h-16 text-gray-400 mb-4" />
                                <p class="text-lg font-medium text-gray-900">Document File</p>
                                <p class="text-sm text-gray-500">{{ $kyc->file_name }}</p>
                                <div class="mt-4">
                                    <flux:button 
                                        href="{{ route('admin.kyc.download', $kyc) }}" 
                                        variant="primary"
                                    >
                                        Download
                                    </flux:button>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Review Information -->
                @if($kyc->reviewed_at)
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Review Information</h3>
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ 
                                        $kyc->status === 'approved' ? 'bg-green-100 text-green-800' : 
                                        ($kyc->status === 'rejected' ? 'bg-red-100 text-red-800' : 
                                        ($kyc->status === 'expired' ? 'bg-gray-100 text-gray-800' : 'bg-yellow-100 text-yellow-800')) 
                                    }}">
                                        {{ $kyc->status_label }}
                                    </span>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Verification Level</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $kyc->verification_level_label ?? 'N/A' }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reviewed By</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $kyc->reviewer->name ?? 'N/A' }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reviewed At</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $kyc->reviewed_at->format('M d, Y H:i') }}</dd>
                            </div>
                            @if($kyc->expires_at)
                                <div>
                                    <dt class="text-sm font-medium text-gray-500">Expires At</dt>
                                    <dd class="mt-1 text-sm text-gray-900">{{ $kyc->expires_at->format('M d, Y H:i') }}</dd>
                                </div>
                            @endif
                        </dl>

                        @if($kyc->review_notes)
                            <div class="mt-4">
                                <dt class="text-sm font-medium text-gray-500">Review Notes</dt>
                                <dd class="mt-1 text-sm text-gray-900 bg-gray-50 p-3 rounded-lg">{{ $kyc->review_notes }}</dd>
                            </div>
                        @endif

                        @if($kyc->rejection_reason)
                            <div class="mt-4">
                                <dt class="text-sm font-medium text-gray-500">Rejection Reason</dt>
                                <dd class="mt-1 text-sm text-red-900 bg-red-50 p-3 rounded-lg">{{ $kyc->rejection_reason }}</dd>
                            </div>
                        @endif
                    </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- User Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">User Information</h3>
                    <div class="space-y-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-12 w-12">
                                <div class="h-12 w-12 rounded-full bg-gray-200 flex items-center justify-center">
                                    <flux:icon name="user" class="w-6 h-6 text-gray-500" />
                                </div>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900">{{ $kyc->user->name }}</div>
                                <div class="text-sm text-gray-500">{{ $kyc->user->email }}</div>
                            </div>
                        </div>

                        @if($userProfile)
                            <dl class="space-y-2">
                                <div>
                                    <dt class="text-xs font-medium text-gray-500">KYC Status</dt>
                                    <dd class="text-sm text-gray-900">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ 
                                            $userProfile->kyc_status === 'verified' ? 'bg-green-100 text-green-800' : 
                                            ($userProfile->kyc_status === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') 
                                        }}">
                                            {{ $userProfile->kyc_status_label }}
                                        </span>
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-xs font-medium text-gray-500">AML Status</dt>
                                    <dd class="text-sm text-gray-900">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ 
                                            $userProfile->aml_status === 'clear' ? 'bg-green-100 text-green-800' : 
                                            ($userProfile->aml_status === 'flagged' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') 
                                        }}">
                                            {{ $userProfile->aml_status_label }}
                                        </span>
                                    </dd>
                                </div>
                                <div>
                                    <dt class="text-xs font-medium text-gray-500">Compliance Status</dt>
                                    <dd class="text-sm text-gray-900">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ 
                                            $userProfile->compliance_status === 'compliant' ? 'bg-green-100 text-green-800' : 
                                            ($userProfile->compliance_status === 'non_compliant' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') 
                                        }}">
                                            {{ $userProfile->compliance_status_label }}
                                        </span>
                                    </dd>
                                </div>
                            </dl>
                        @endif
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        @if($kyc->status === 'pending')
                            <form method="POST" action="{{ route('admin.kyc.approve', $kyc) }}" class="w-full" id="approve-form">
                                @csrf
                                <flux:button icon="check-circle" type="submit" variant="primary" class="w-full" onclick="return handleApprove()">
                                    Approve Document
                                </flux:button>
                            </form>

                            <form method="POST" action="{{ route('admin.kyc.reject', $kyc) }}" class="w-full" id="reject-form">
                                @csrf
                                <flux:button icon="x-circle" type="submit" variant="danger" class="w-full" onclick="return handleReject()">
                                    Reject Document
                                </flux:button>
                            </form>
                        @endif

                        <flux:button 
                            href="{{ route('admin.kyc.download', $kyc) }}" 
                            variant="outline" 
                            class="w-full"
                            icon="arrow-down-tray"
                        >
                            Download Document
                        </flux:button>

                        <flux:button 
                            href="{{ route('admin.users.show', $kyc->user) }}" 
                            variant="outline" 
                            class="w-full"
                            icon="user"
                        >
                            View User Profile
                        </flux:button>
                    </div>
                </div>

                <!-- Other Documents -->
                @if($otherDocuments->count() > 0)
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Other Documents</h3>
                        <div class="space-y-3">
                            @foreach($otherDocuments as $document)
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $document->document_type_label }}</div>
                                        <div class="text-xs text-gray-500">{{ $document->created_at->format('M d, Y') }}</div>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ 
                                            $document->status === 'approved' ? 'bg-green-100 text-green-800' : 
                                            ($document->status === 'rejected' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800') 
                                        }}">
                                            {{ $document->status_label }}
                                        </span>
                                        <flux:button 
                                            href="{{ route('admin.kyc.show', $document) }}" 
                                            variant="outline" 
                                            size="sm"
                                        >
                                            View
                                        </flux:button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Image Modal -->
    <div id="imageModal" class="fixed inset-0 bg-black bg-opacity-75 z-50 hidden" onclick="closeImageModal()">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="relative max-w-4xl max-h-full" onclick="event.stopPropagation()">
                <button 
                    onclick="closeImageModal()" 
                    class="absolute -top-10 right-0 text-white hover:text-gray-300 transition-colors"
                >
                    <flux:icon name="x-mark" class="w-8 h-8" />
                </button>
                <img id="modalImage" src="" alt="" class="max-w-full max-h-full rounded-lg shadow-2xl" />
                <div class="mt-2 text-center">
                    <p id="modalImageTitle" class="text-white text-lg font-medium"></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function openImageModal(imageSrc, imageTitle) {
            document.getElementById('modalImage').src = imageSrc;
            document.getElementById('modalImageTitle').textContent = imageTitle;
            document.getElementById('imageModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeImageModal() {
            document.getElementById('imageModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
        }

        // Close modal on Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeImageModal();
            }
        });

                        // Handle approve button click
                function handleApprove() {
                    return confirm('Approve this document?');
                }

                // Handle reject button click
                function handleReject() {
                    return confirm('Reject this document?');
                }
    </script>
@endsection
