@extends('components.layouts.admin')

@section('title', 'Edit KYC Document')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit KYC Document</h1>
                <p class="text-gray-600">{{ $kyc->document_type_label }} - {{ $kyc->user->name }}</p>
            </div>
            <div class="flex space-x-3">
                <flux:button icon="eye" href="{{ route('admin.kyc.show', $kyc) }}" variant="outline">
                    View Document
                </flux:button>
                <flux:button icon="arrow-left" href="{{ route('admin.kyc.index') }}" variant="outline">
                    Back to KYC
                </flux:button>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Form -->
            <div class="lg:col-span-2">
                <form method="POST" action="{{ route('admin.kyc.update', $kyc) }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <!-- Document Information -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <flux:label for="document_type">Document Type</flux:label>
                                <flux:input 
                                    id="document_type" 
                                    value="{{ $kyc->document_type_label }}" 
                                    disabled
                                />
                            </div>
                            <div>
                                <flux:label for="document_name">Document Name</flux:label>
                                <flux:input 
                                    id="document_name" 
                                    value="{{ $kyc->document_name }}" 
                                    disabled
                                />
                            </div>
                            <div>
                                <flux:label for="file_name">File Name</flux:label>
                                <flux:input 
                                    id="file_name" 
                                    value="{{ $kyc->file_name }}" 
                                    disabled
                                />
                            </div>
                            <div>
                                <flux:label for="file_size">File Size</flux:label>
                                <flux:input 
                                    id="file_size" 
                                    value="{{ $kyc->file_size_human }}" 
                                    disabled
                                />
                            </div>
                        </div>
                    </div>

                    <!-- Review Status -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Review Status</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <flux:label for="status">Status</flux:label>
                                <flux:select id="status" name="status">
                                    @foreach(\App\Models\KycDocument::STATUSES as $value => $label)
                                        <option value="{{ $value }}" {{ old('status', $kyc->status) == $value ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </flux:select>
                                @error('status')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:label for="verification_level">Verification Level</flux:label>
                                <flux:select id="verification_level" name="verification_level">
                                    <option value="">Select Level</option>
                                    @foreach(\App\Models\KycDocument::VERIFICATION_LEVELS as $value => $label)
                                        <option value="{{ $value }}" {{ old('verification_level', $kyc->verification_level) == $value ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </flux:select>
                                @error('verification_level')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <flux:label for="expires_at">Expires At</flux:label>
                                <flux:date-picker 
                                    id="expires_at" 
                                    name="expires_at" 
                                    value="{{ $kyc->expires_at?->format('Y-m-d') }}"
                                />
                                @error('expires_at')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Review Notes -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Review Notes</h3>
                        <div>
                            <flux:label for="review_notes">Review Notes</flux:label>
                            <flux:textarea 
                                id="review_notes" 
                                name="review_notes" 
                                rows="4"
                                placeholder="Enter review notes..."
                            >{{ old('review_notes', $kyc->review_notes) }}</flux:textarea>
                            @error('review_notes')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <!-- Rejection Reason -->
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Rejection Information</h3>
                        <div>
                            <flux:label for="rejection_reason">Rejection Reason</flux:label>
                            <flux:textarea 
                                id="rejection_reason" 
                                name="rejection_reason" 
                                rows="3"
                                placeholder="Enter rejection reason if applicable..."
                            >{{ old('rejection_reason', $kyc->rejection_reason) }}</flux:textarea>
                            @error('rejection_reason')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-sm text-gray-500">Only required if status is set to "Rejected"</p>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="flex justify-end space-x-3">
                        <flux:button type="button" onclick="history.back()" variant="outline">
                            Cancel
                        </flux:button>
                        <flux:button type="submit" variant="primary">
                            Update Document
                        </flux:button>
                    </div>
                </form>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Document Preview -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Document Preview</h3>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 text-center">
                        @if($kyc->mime_type && str_starts_with($kyc->mime_type, 'image/'))
                            <img 
                                src="{{ Storage::url($kyc->file_path) }}" 
                                alt="Document Preview" 
                                class="max-w-full max-h-48 mx-auto rounded-lg shadow-sm"
                            />
                        @elseif($kyc->mime_type === 'application/pdf')
                            <div class="flex flex-col items-center">
                                <flux:icon name="document-text" class="w-12 h-12 text-red-500 mb-2" />
                                <p class="text-sm font-medium text-gray-900">PDF Document</p>
                                <p class="text-xs text-gray-500">{{ $kyc->file_name }}</p>
                            </div>
                        @else
                            <div class="flex flex-col items-center">
                                <flux:icon name="document" class="w-12 h-12 text-gray-400 mb-2" />
                                <p class="text-sm font-medium text-gray-900">Document File</p>
                                <p class="text-xs text-gray-500">{{ $kyc->file_name }}</p>
                            </div>
                        @endif
                    </div>
                    <div class="mt-4 flex space-x-2">
                        <flux:button 
                            href="{{ route('admin.kyc.download', $kyc) }}" 
                            variant="outline" 
                            size="sm"
                            class="flex-1"
                        >
                            Download
                        </flux:button>
                        @if($kyc->mime_type === 'application/pdf')
                            <flux:button 
                                href="{{ route('admin.kyc.view', $kyc) }}" 
                                target="_blank"
                                variant="outline" 
                                size="sm"
                                class="flex-1"
                            >
                                View PDF
                            </flux:button>
                        @endif
                    </div>
                </div>

                <!-- User Information -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">User Information</h3>
                    <div class="space-y-3">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-10 w-10">
                                <div class="h-10 w-10 rounded-full bg-gray-200 flex items-center justify-center">
                                    <flux:icon name="user" class="w-5 h-5 text-gray-500" />
                                </div>
                            </div>
                            <div class="ml-3">
                                <div class="text-sm font-medium text-gray-900">{{ $kyc->user->name }}</div>
                                <div class="text-sm text-gray-500">{{ $kyc->user->email }}</div>
                            </div>
                        </div>
                        
                        <flux:button 
                            href="{{ route('admin.users.show', $kyc->user) }}" 
                            variant="outline" 
                            size="sm"
                            class="w-full"
                        >
                            <flux:icon name="user" class="w-4 h-4 mr-2" />
                            View User Profile
                        </flux:button>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        @if($kyc->status === 'pending')
                            <form method="POST" action="{{ route('admin.kyc.approve', $kyc) }}" class="w-full">
                                @csrf
                                <flux:button icon="check-circle" type="submit" variant="primary" class="w-full" onclick="return confirm('Approve this document?')">
                                    Approve Document
                                </flux:button>
                            </form>

                            <form method="POST" action="{{ route('admin.kyc.reject', $kyc) }}" class="w-full">
                                @csrf
                                <flux:button icon="x-circle" type="submit" variant="danger" class="w-full" onclick="return confirm('Reject this document?')">
                                    Reject Document
                                </flux:button>
                            </form>
                        @endif

                        <form method="POST" action="{{ route('admin.kyc.destroy', $kyc) }}" class="w-full" onsubmit="return confirm('Are you sure you want to delete this document? This action cannot be undone.')">
                            @csrf
                            @method('DELETE')
                            <flux:button type="submit" variant="danger" class="w-full" icon="trash">
                                Delete Document
                            </flux:button>
                        </form>
                    </div>
                </div>

                <!-- Review History -->
                @if($kyc->reviewed_at)
                    <div class="bg-white rounded-xl border border-gray-200 shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Review History</h3>
                        <dl class="space-y-2">
                            <div>
                                <dt class="text-xs font-medium text-gray-500">Reviewed By</dt>
                                <dd class="text-sm text-gray-900">{{ $kyc->reviewer->name ?? 'N/A' }}</dd>
                            </div>
                            <div>
                                <dt class="text-xs font-medium text-gray-500">Reviewed At</dt>
                                <dd class="text-sm text-gray-900">{{ $kyc->reviewed_at->format('M d, Y H:i') }}</dd>
                            </div>
                            @if($kyc->review_notes)
                                <div>
                                    <dt class="text-xs font-medium text-gray-500">Previous Notes</dt>
                                    <dd class="text-sm text-gray-900 bg-gray-50 p-2 rounded">{{ $kyc->review_notes }}</dd>
                                </div>
                            @endif
                        </dl>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        // Show/hide rejection reason based on status
        document.addEventListener('DOMContentLoaded', function() {
            const statusSelect = document.getElementById('status');
            const rejectionReasonField = document.getElementById('rejection_reason').closest('.bg-white');
            
            function toggleRejectionReason() {
                if (statusSelect.value === 'rejected') {
                    rejectionReasonField.style.display = 'block';
                } else {
                    rejectionReasonField.style.display = 'none';
                }
            }
            
            statusSelect.addEventListener('change', toggleRejectionReason);
            toggleRejectionReason(); // Initial call
        });
    </script>
@endsection
